/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorderEvent;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorderProxy;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.DlgcMaxDurationParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcAppendParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcAudioClockRateParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcAudioCodecParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcEnabledEventsParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcFileFormatParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcMinDurationParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcPromptParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcSilenceTerminationParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcSpeechDetectorFinalTimeoutParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcSpeechDetectorInitialTimeoutParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcStartBeepParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcVideoCodecParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcVideoFMTPParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcVideoMaxBitRateParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState_Activating;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState_Active;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState_Idle;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState_Paused;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.recorder.states.DlgcRecorderState_Stopping;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDInitTimeoutParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDPatternParameter;
import com.vendor.dialogic.javax.media.mscontrol.signals.parameters.DlgcSDSigTimeoutParameter;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.mediagroup.SpeechDetectorConstants;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.resource.RTC;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcRecorder
extends DlgcResource<MediaGroup, RecorderEvent>
implements Recorder {
    private static DlgcParameters supportedParameters;
    private static Set<EventType> supportedEventTypes;
    private static Set<Qualifier> supportedQualifiers;
    private static Logger log;
    private static DlgcSupportedFeatures supportedFeatures;
    protected static DlgcRecorderState_Idle IDLE;
    protected static DlgcRecorderState_Activating ACTIVATING;
    protected static DlgcRecorderState_Active ACTIVE;
    protected static DlgcRecorderState_Paused PAUSED;
    protected static DlgcRecorderState_Stopping STOPPING;

    public DlgcRecorder(MediaGroup mg) {
        super(mg);
        this.setState(IDLE);
    }

    @Override
    protected DlgcParameters getSupportedParameters() {
        return supportedParameters;
    }

    public void processRecordAckMsg(MsmlDocument.Msml message, SipServletResponse sipResponse) {
        this.setState(ACTIVE);
        log.debug("DlgcRecorder::processRecordAckMsg");
        int resultResponse = sipResponse.getStatus();
        log.debug("DlgcRecorder::processRecordAckMsg response: " + sipResponse.toString());
        boolean bStatus = false;
        String msg = null;
        DlgcXMediaMixer mixer = null;
        DlgcXMediaGroup mg = (DlgcXMediaGroup)this.getContainer();
        if (mg != null) {
            mixer = (DlgcXMediaMixer)mg.joinedWithMixer();
        }
        if (resultResponse > 200) {
            msg = "Fail to Start Recorder: " + sipResponse.getReasonPhrase();
            if (mixer != null) {
                mixer.setConfRecordingState(DlgcXMediaMixer.ConfRecordingState.NOT_RECORDING);
            }
        } else {
            bStatus = true;
            msg = "Recorder Started";
            if (mixer != null) {
                mixer.setConfRecordingState(DlgcXMediaMixer.ConfRecordingState.RECORDING);
            }
        }
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.error("SYNC_2_ASYNC DlgcRecorder::processRecordAckMsg:Ack Major error running Player Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                log.debug("SYNC_2_ASYNC DlgcRecorder::processRecordAckMsg:Ack calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, msg);
                log.debug("SYNC_2_ASYNC DlgcRecorder::processRecordAckMsg:Ack returned from Monitor notifyRequestCompleted");
            }
        }
    }

    public void processRecordCmpltEvent(DlgcRecorderEvent event) {
        log.debug("DlgcRecorder::processRecordCompleteEvent:: calling postMediaEvent EventType: " + event.getEventType().toString());
        this.postMediaEvent(event);
        this.setState(IDLE);
        DlgcXMediaGroup mg = (DlgcXMediaGroup)this.container;
        if (mg.getActiveResources() > 0) {
            log.debug("DlgcRecorder::processRecordCmpltEvent - calling media group resourceStopNotifier(RECORDER) ");
            mg.resourceStopNotifier("RECORDER");
        }
    }

    protected void monitorNotify(String cmd, String statusMsg, boolean bStatus, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype) {
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC DlgcRecorder:: " + cmd + " in a synchronous mode but note DlgcSync2AsyncMonitor is NULL");
            } else {
                monitor.setExceptionType(extype);
                log.debug("SYNC_2_ASYNC DlgcRecorder:: " + cmd + " calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, statusMsg);
                log.debug("SYNC_2_ASYNC DlgcRecorder:: " + cmd + " returning from Monitor notifyRequestCompleted");
            }
        }
    }

    public void record(URI streamID, RTC[] rtcs, Parameters parameters) throws MsControlException {
        if (streamID == null) {
            throw new MsControlException("StreamID is NULL");
        }
        String result = this.verifyRTCs(rtcs);
        if (result == null) {
            String errorMsg = "Record Aborted..not joined to either a Network Connection or Mixer";
            try {
                boolean isJOINED = ((DlgcMediaGroup)this.container).isJoinedToNetworkConectionOrMixer();
                if (!isJOINED) {
                    this.monitorNotify("record", errorMsg, false, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.JOIN_EXCEPTION);
                    throw new JoinException(errorMsg);
                }
                log.info("JSR309 API REQUEST:record() : MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
                ((DlgcRecorderState)this.getState()).recordMsg(this, streamID, rtcs, parameters);
            }
            catch (MsControlException msex) {
                log.debug("recorder-Exception ... Inside Recorder Re-Throw");
                throw msex;
            }
        } else {
            this.monitorNotify("record", result, false, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.UNSUPPORTED_EXCEPTION);
            throw new UnsupportedException(result);
        }
    }

    protected String verifyRTCs(RTC[] rtcs) throws MsControlException {
        String result = null;
        if (rtcs == null) {
            return result;
        }
        for (RTC aRtc : rtcs) {
            if (aRtc.getAction() != MediaGroup.SIGDET_STOPPLAY.getAction()) {
                result = "RTC not supported: " + aRtc.getAction().toString();
                break;
            }
            log.debug("Recorder Play Barge IN enabled");
        }
        return result;
    }

    public void sendRecordMsg(URI streamID, RTC[] rtcs, Parameters parameters) {
    }

    public void sendStopMsg() {
    }

    public void stop() {
        log.info("JSR309 API REQUEST:record stop() : MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
        ((DlgcRecorderState)this.getState()).stopMsg(this);
    }

    public static Set<EventType> getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    @Override
    public DlgcRecorderProxy getProxy() {
        DlgcResourceContainer container = (DlgcResourceContainer)this.container;
        String componentProxyId = container.getProxyId();
        String sasId = ((DlgcMediaSession)container.getMediaSession()).getProxyId();
        String msObjId = ((DlgcMediaSession)container.getMediaSession()).getMediaObject();
        return new DlgcRecorderProxy(sasId, componentProxyId, msObjId);
    }

    public static void loadSupportedFeatures(DlgcSupportedFeatures sf) {
        sf.appendSfParameters(supportedFeatures.getSupportedParameters());
        sf.appendSfEventTypes(supportedFeatures.getSupportedEventTypes());
        sf.appendSfValues(supportedFeatures.getSupportedValues());
        sf.appendSfQualifiers(supportedFeatures.getSupportedQualifiers());
    }

    static {
        log = LoggerFactory.getLogger(DlgcRecorder.class);
        supportedFeatures = new DlgcSupportedFeatures();
        IDLE = new DlgcRecorderState_Idle();
        ACTIVATING = new DlgcRecorderState_Activating();
        ACTIVE = new DlgcRecorderState_Active();
        PAUSED = new DlgcRecorderState_Paused();
        STOPPING = new DlgcRecorderState_Stopping();
        supportedEventTypes = new HashSet<EventType>();
        supportedEventTypes.add(RecorderEvent.RECORD_COMPLETED);
        supportedQualifiers = new HashSet<Qualifier>();
        supportedQualifiers.add(RecorderEvent.PROMPT_FAILURE);
        supportedQualifiers.add(RecorderEvent.DURATION_EXCEEDED);
        supportedParameters = new DlgcParameters();
        supportedParameters.put(Recorder.APPEND, DlgcAppendParameter.instance);
        supportedParameters.put(Recorder.MAX_DURATION, DlgcMaxDurationParameter.instance);
        supportedParameters.put(Recorder.MIN_DURATION, DlgcMinDurationParameter.instance);
        supportedParameters.put(Recorder.PROMPT, DlgcPromptParameter.instance);
        supportedParameters.put(Recorder.ENABLED_EVENTS, DlgcEnabledEventsParameter.instance);
        supportedParameters.put(Recorder.SILENCE_TERMINATION_ON, DlgcSilenceTerminationParameter.instance);
        supportedParameters.put(Recorder.START_BEEP, DlgcStartBeepParameter.instance);
        supportedParameters.put(SpeechDetectorConstants.FINAL_TIMEOUT, DlgcSpeechDetectorFinalTimeoutParameter.instance);
        supportedParameters.put(SpeechDetectorConstants.INITIAL_TIMEOUT, DlgcSpeechDetectorInitialTimeoutParameter.instance);
        supportedParameters.put(Recorder.AUDIO_CLOCKRATE, DlgcAudioClockRateParameter.instance);
        supportedParameters.put(Recorder.FILE_FORMAT, DlgcFileFormatParameter.instance);
        supportedParameters.put(Recorder.AUDIO_CODEC, DlgcAudioCodecParameter.instance);
        supportedParameters.put(SignalDetector.INITIAL_TIMEOUT, DlgcSDInitTimeoutParameter.instance);
        supportedParameters.put(SignalDetector.INTER_SIG_TIMEOUT, DlgcSDSigTimeoutParameter.instance);
        supportedParameters.put(Recorder.VIDEO_CODEC, DlgcVideoCodecParameter.instance);
        supportedParameters.put(Recorder.VIDEO_FMTP, DlgcVideoFMTPParameter.instance);
        supportedParameters.put(Recorder.VIDEO_MAX_BITRATE, DlgcVideoMaxBitRateParameter.instance);
        for (int i = 0; i < 32; ++i) {
            supportedParameters.put(SignalDetector.PATTERN[i], DlgcSDPatternParameter.instance);
        }
        supportedFeatures.setSfParameters(supportedParameters.keySet());
        supportedFeatures.setSfEventTypes(supportedEventTypes);
        supportedFeatures.setSfQualifiers(supportedQualifiers);
    }
}

