/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.net.URI;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.RTC;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcPlayerProxy
extends DlgcProxy
implements Player,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcPlayerProxy.class);

    public DlgcPlayerProxy(String id, String mediaSessionId, String objectId) {
        super(id, mediaSessionId, objectId);
    }

    public void play(URI[] arg0, RTC[] arg1, Parameters arg2) throws MsControlException {
        if (DlgcInstrumentPropertyMgr.bUseProxyDoAction) {
            log.debug("DlgcPlayerProxy::play  using playSync");
        } else {
            log.debug("DlgcPlayerProxy::play  using playAsync");
            this.playAsync(arg0, arg1, arg2);
        }
    }

    protected void playAsync(final URI[] arg0, final RTC[] arg1, final Parameters arg2) throws MsControlException {
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Player:Play Request");
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering PlayerProxy::playAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        Player player = mg.getPlayer();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXPlayer)player).setMonitor(monitor);
                        }
                        player.play(arg0, arg1, arg2);
                        DlgcPlayerProxy pproxy = ((DlgcPlayer)player).getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    log.debug("Exiting PlayerProxy::playAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC playAsync:: Waiting synchronously for Player play request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC Player: Play Monitor returned with the following status: " + monitor.getStatusString());
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXPlayer)mg.getPlayer()).setMonitor(null);
            }
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to get player. play failed", (Throwable)e);
            throw new MsControlException(appLogId + "Failed to get player. play failed", (Throwable)e);
        }
    }

    public void play(URI arg0, RTC[] arg1, Parameters arg2) throws MsControlException {
        log.debug("test DlgcPlayerProxy::play Entering");
        if (null != arg1 && arg1.length > 0 && arg1[0].getAction() == Player.STOP && arg1[0].getTrigger() == Player.PLAY_START) {
            throw new UnsupportedException("Player : RTC combination RTC(Player.PLAY_START, Player.STOP) is not supported.");
        }
        if (null != arg2 && !arg2.isEmpty() && arg2.containsKey((Object)BEHAVIOUR_IF_BUSY)) {
            throw new MsControlException("Player : BEHAVIOUR_IF_BUSY, FAIL_IF_BUSY, STOP_IF_BUSY is not supported in this version of the connector.");
        }
        log.debug("test DlgcPlayerProxy::play  using playAsync");
        this.playAsync(arg0, arg1, arg2);
        log.debug("test DlgcPlayerProxy::play leaving");
    }

    protected void playAsync(final URI arg0, final RTC[] arg1, final Parameters arg2) throws MsControlException {
        Object syncSasId = null;
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Player:Play Request");
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession synAppSession) {
                    log.debug("PlayerProxy::playAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)synAppSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        Player player = mg.getPlayer();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXPlayer)player).setMonitor(monitor);
                        }
                        player.play(arg0, arg1, arg2);
                        DlgcPlayerProxy pproxy = ((DlgcPlayer)player).getProxy();
                        pproxy.saveMediaSession(synAppSession, session);
                    }
                    catch (MsControlException e) {
                        // empty catch block
                    }
                    log.debug("Exiting test PlayerProxy::playAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC playAsync:: OUTSIDE Waiting synchronously for Player play request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC Player: OUTSIDE Play Monitor returned with the following status: " + monitor.getStatusString());
                boolean status = monitor.getStatus();
                String statusMsg = monitor.getStatusString();
                DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype = monitor.getExceptionType();
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXPlayer)mg.getPlayer()).setMonitor(null);
                if (!status) {
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.JOIN_EXCEPTION) == 0) {
                        log.debug("DlgcPlayerProxy-Exception ... executing Monitor Notify JOIN method");
                        throw new JoinException(statusMsg);
                    }
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.UNSUPPORTED_EXCEPTION) == 0) {
                        log.debug("DlgcPlayerProxy-Exception ... executing Monitor Notify UNSUPPORTED method");
                        throw new UnsupportedException(statusMsg);
                    }
                    log.debug("DlgcPlayerProxy-Exception ... executing Monitor Notify MsControl method");
                    throw new MsControlException(statusMsg);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedException) {
                throw new UnsupportedException(e.getMessage());
            }
            if (e instanceof JoinException) {
                throw new JoinException(e.getMessage());
            }
            log.debug(e.toString());
            throw new MsControlException(e.getMessage());
        }
    }

    public void stop(boolean arg0) {
        if (DlgcInstrumentPropertyMgr.bUseProxyDoAction) {
            log.debug("DlgcPlayerProxy::stop  using stopSync");
        } else {
            log.debug("DlgcPlayerProxy::stop  using stopAsync");
            this.stopAsync(arg0);
        }
    }

    protected void stopAsync(final boolean arg0) {
        log.debug("Entering Player Proxy Stop()");
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Player:Stop Request");
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering PlayerProxy::stopAsync Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        Player player = mg.getPlayer();
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            ((DlgcXPlayer)player).setMonitor(monitor);
                        }
                        player.stop(arg0);
                        DlgcPlayerProxy pproxy = ((DlgcPlayer)player).getProxy();
                        pproxy.saveMediaSession(appSession, session);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    log.debug("Exiting playerProxy::stopAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC playAsync:: OUTSIDE Waiting synchronously for Player Stop request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC Player: OUTSIDE Play Stop Monitor returned with the following status: " + monitor.getStatusString());
                DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
                ((DlgcXPlayer)mg.getPlayer()).setMonitor(null);
            }
        }
        catch (Exception e) {
            log.error("Failed to stop", (Throwable)e);
        }
        log.debug("Leaving Player Proxy Stop()");
    }

    public MediaGroup getContainer() {
        DlgcMediaGroup mgImpl = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            mgImpl = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to getContainer", (Throwable)e);
        }
        return (MediaGroup)mgImpl.getProxy();
    }

    public void addListener(MediaEventListener<PlayerEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            Player player = mg.getPlayer();
            player.addListener(arg0);
            DlgcPlayerProxy pproxy = ((DlgcPlayer)player).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to addListener", (Throwable)e);
        }
    }

    public MediaSession getMediaSession() {
        DlgcMediaSession ms = null;
        SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
        String mediaId = this.getMsObjectId();
        try {
            ms = (DlgcMediaSession)appSession.getAttribute(mediaId);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to GetProxyMediaSession", (Throwable)e);
        }
        return ms.getProxy();
    }

    public void removeListener(MediaEventListener<PlayerEvent> arg0) {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxId);
            Player player = mg.getPlayer();
            player.removeListener(arg0);
            DlgcPlayerProxy pproxy = ((DlgcPlayer)player).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to removeListener", (Throwable)e);
        }
    }
}

