/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceEvent;
import java.util.Iterator;
import java.util.List;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.ResourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcPlayerEvent
extends DlgcResourceEvent<Player>
implements PlayerEvent {
    private static Logger log = LoggerFactory.getLogger(DlgcPlayerEvent.class);
    Action changeAction = null;
    int playIndex = 1;
    int playOffset = 0;

    public DlgcPlayerEvent(MsmlDocument.Msml message, Player source) {
        super(message, source);
        if (message == null) {
            return;
        }
        DlgcPlayerEvent.getMsmlPlayerEventValues(message, this);
        if (this.reason.equals("Not_found")) {
            this.setError(MediaErr.UNKNOWN_ERROR);
            this.setQualifier(NO_QUALIFIER);
            this.setErrorText("Invalid URI media file target");
        } else if (this.reason.equals("play.terminate")) {
            this.setQualifier(ResourceEvent.STOPPED);
        } else if (this.reason.equals("Error")) {
            this.setError(MediaErr.UNKNOWN_ERROR);
            this.setQualifier(NO_QUALIFIER);
            this.setErrorText("Generic Player Error");
        }
    }

    public static void getMsmlPlayerEventValues(MsmlDocument.Msml message, DlgcPlayerEvent playerEventObj) {
        MsmlDocument.Msml.Event msmlEvent = message.getEvent();
        List nameList = msmlEvent.getNameList();
        List valueList = msmlEvent.getValueList();
        Iterator nameIt = nameList.iterator();
        int index = 0;
        while (nameIt.hasNext()) {
            String name = (String)nameIt.next();
            if (name.compareToIgnoreCase("play.end") == 0) {
                playerEventObj.reason = (String)valueList.get(index);
            } else if (name.compareToIgnoreCase("play.amt") == 0) {
                playerEventObj.playOffset = Integer.valueOf((String)valueList.get(index));
            }
            ++index;
        }
    }

    public Action getChangeType() {
        return this.changeAction;
    }

    public int getIndex() {
        return this.playIndex;
    }

    public int getOffset() {
        return this.playOffset;
    }

    public void setOffset(int offset) {
        this.playOffset = offset;
    }
}

