/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayerEvent;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayerProxy;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.DlgcMaxDurationParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.player.DlgcBehaviorIfBusyParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.player.DlgcEnabledEventsParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.player.DlgcIntervalParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.player.DlgcRepeatCountParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.player.DlgcStartOffsetParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcAudioCodecParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.parameters.recorder.DlgcFileFormatParameter;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Activating;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Active;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Idle;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Paused;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Stop_Acked;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Stopping;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.player.states.DlgcPlayerState_Waiting_StopAck_PlayComplete;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.join.JoinException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.RTC;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcPlayer
extends DlgcResource<MediaGroup, PlayerEvent>
implements Player {
    private static final long serialVersionUID = 1L;
    private static DlgcSupportedFeatures supportedFeatures = new DlgcSupportedFeatures();
    protected DlgcSigDetectorFSM mySignalDetectorFSM;
    protected DlgcSignalGenerator sigGenObj;
    protected Queue<DlgcPlayRequest> requestQueue = new ConcurrentLinkedQueue<DlgcPlayRequest>();
    protected Queue<DlgcPlayRequest> stoppedQueue = new ConcurrentLinkedQueue<DlgcPlayRequest>();
    private static DlgcParameters supportedParameters;
    private static Set<EventType> supportedEventTypes;
    private static Set<Qualifier> supportedQualifiers;
    private static Logger log;
    public static DlgcPlayerState_Idle IDLE;
    public static DlgcPlayerState_Activating ACTIVATING;
    public static DlgcPlayerState_Active ACTIVE;
    public static DlgcPlayerState_Paused PAUSED;
    public static DlgcPlayerState_Stopping STOPPING;
    public static DlgcPlayerState_Stop_Acked STOPP_ACKED;
    public static DlgcPlayerState_Waiting_StopAck_PlayComplete WAIT_FOR_STOP_ACK_BUT_PLAY_COMPLETE;
    public DlgcPlayerEvent savedPlayCompleteEvent;

    public DlgcPlayer(MediaGroup mg) {
        super(mg);
        this.setState(IDLE);
        this.mySignalDetectorFSM = null;
        this.sigGenObj = null;
        this.savedPlayCompleteEvent = null;
    }

    public void play(URI[] streamIds, RTC[] rtcs, Parameters parameters) throws MsControlException {
        String errorMsg = "Player Aborted..not joined to either a Network Connection or Mixer";
        try {
            boolean isJOINED = ((DlgcMediaGroup)this.container).isJoinedToNetworkConectionOrMixer();
            if (!isJOINED) {
                this.monitorNotify("player", errorMsg, false, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.JOIN_EXCEPTION);
                throw new JoinException(errorMsg);
            }
            log.info("JSR309 API REQUEST:play() : MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
            ((DlgcPlayerState)this.getState()).playMsg(this, streamIds, rtcs, parameters);
        }
        catch (MsControlException msex) {
            log.debug("player-Exception ... Inside Player Re-Throw");
            throw msex;
        }
    }

    protected void monitorNotify(String cmd, String statusMsg, boolean bStatus, DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype) {
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.debug("SYNC_2_ASYNC DlgcPlayer:: " + cmd + " in a synchronous mode but note DlgcSync2AsyncMonitor is NULL");
            } else {
                monitor.setExceptionType(extype);
                log.debug("SYNC_2_ASYNC DlgcPlayer:: " + cmd + " calling Monitor notifyRequestCompleted");
                monitor.notifyRequestCompleted(bStatus, statusMsg);
                log.debug("SYNC_2_ASYNC DlgcPlayer:: " + cmd + " returning from Monitor notifyRequestCompleted");
            }
        }
    }

    public void play(URI streamId, RTC[] rtcs, Parameters parameters) throws MsControlException {
        if (streamId == null) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            throw new MsControlException(appLogId + "Invalid streamId - null specified");
        }
        URI[] streamIdList = new URI[]{streamId};
        log.info("JSR309 API REQUEST:play() : MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
        if (parameters != null) {
            Set aSet = parameters.entrySet();
            Map.Entry e2 = null;
            if (aSet != null) {
                for (Map.Entry e2 : aSet) {
                    log.debug("DlgcPlayer::play Pareameter: " + ((Parameter)e2.getKey()).toString() + "  Value: " + e2.getValue().toString());
                }
            }
        }
        this.play(streamIdList, rtcs, parameters);
    }

    public void playCollect(DlgcSigDetectorFSM signalDetectorFSM, int numOfSignals, Parameter[] patterns, Parameters parameters, boolean bargeEnable) throws MsControlException {
        this.mySignalDetectorFSM = signalDetectorFSM;
        ((DlgcPlayerState)this.getState()).playCollectMsg(this, numOfSignals, patterns, parameters, bargeEnable);
    }

    public void collectOnly(DlgcSigDetectorFSM signalDetectorFSM, int numOfSignals, Parameter[] patterns, Parameters parameters, boolean bargeEnable) throws MsControlException {
        this.mySignalDetectorFSM = signalDetectorFSM;
        ((DlgcPlayerState)this.getState()).collectOnlyMsg(this, numOfSignals, patterns, parameters, bargeEnable);
    }

    public void playDtmfSignals(DlgcSignalGenerator sg, String signals, RTC[] rtcs, Parameters params) throws MsControlException {
        this.sigGenObj = sg;
        ((DlgcPlayerState)this.getState()).playSigGenMsg(this, signals, params);
    }

    public void processPlayCmpltEvent(DlgcPlayerEvent event) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "Entering DlgcPlayer::processPlayCmpltEvent");
        if (event == null) {
            log.error(appLogId + "processPlayCmpltEvent the event is null..returning immediately");
            return;
        }
        if (event.getQualifier().equals(PlayerEvent.STOPPED)) {
            while (this.stoppedQueue.poll() != null) {
                DlgcPlayerEvent stoppedRequestEvent = event;
                stoppedRequestEvent.setOffset(0);
                this.postMediaEvent(stoppedRequestEvent);
            }
        }
        this.setState(IDLE);
        DlgcPlayRequest request = this.requestQueue.poll();
        if (request != null) {
            try {
                this.play(request.streamIds, request.rtcs, request.parameters);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else {
            DlgcMediaGroup mg = (DlgcMediaGroup)this.getContainer();
            DlgcNetworkConnection nc = mg.joinedWithNetworkConnection();
            if (nc != null) {
                String ncState = nc.getPresentState();
                log.debug(appLogId + "DlgcPlayer::Received Player Play Stop NC State Present State= " + ncState);
                if (ncState.compareTo("DlgcParkedState") != 0) {
                    log.debug(appLogId + "DlgcPlayer::Received Player Play Stop and calling application play stop listener");
                    nc.unpark();
                    this.postMediaEvent(event);
                } else {
                    log.debug(appLogId + "DlgcPlayer::Received Player Play Stop and DELAYING calling application play stop listener until back in conference");
                    DlgcIpmsSession dlgsession = nc.getDlgIpmsSession();
                    dlgsession.getSipSession().setAttribute("DlgcPlayerEvent", (Object)event);
                    dlgsession.getSipSession().setAttribute("DlgcPlayer", (Object)this);
                    nc.unpark();
                }
            } else {
                log.warn(appLogId + "MG Player not joined with Network connection");
            }
        }
    }

    public void processPlayCollectCmpltEvent() {
        this.setState(IDLE);
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        DlgcXMediaGroup mg = (DlgcXMediaGroup)this.container;
        if (mg.getActiveResources() > 0) {
            log.debug("DlgcXPlayer::processRecordCmpltEvent - calling media group resourceStopNotifier(PLAYER) ");
            mg.resourceStopNotifier("PLAYER");
        } else {
            log.debug(appLogId + "DlgcPlay: processPlayCollectCmpltEvent received");
            DlgcPlayRequest request = this.requestQueue.poll();
            if (request != null) {
                try {
                    this.play(request.streamIds, request.rtcs, request.parameters);
                }
                catch (MsControlException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void processPlaySigGenCmpltEvent() {
        this.setState(IDLE);
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "DlgcPlay: processPlaySigGenCmpltEvent received");
        DlgcPlayRequest request = this.requestQueue.poll();
        if (request != null) {
            try {
                this.play(request.streamIds, request.rtcs, request.parameters);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void processSipInfoResponse(SipServletResponse sipResponse, DlgcSipConnectorContentIdsProxy sipReqProxy) {
        log.debug("JMCRUZ Entering DlgcPlayer::processSipInfoResponse");
        if (sipResponse != null) {
            if (this.mySignalDetectorFSM != null) {
                try {
                    this.mySignalDetectorFSM.evSipInfo(sipResponse);
                    ((DlgcPlayerState)this.getState()).playCollectAckMsg(this, sipResponse);
                }
                catch (MsControlException ex) {
                    String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
                    log.error(appLogId + "processSipInfoRequest fail for playCollect due to : ", (Throwable)ex);
                }
            } else if (this.sigGenObj != null) {
                this.sigGenObj.processSipInfoResponse(sipResponse, sipReqProxy);
                try {
                    ((DlgcPlayerState)this.getState()).playSigGenAckMsg(this, sipResponse);
                }
                catch (MsControlException e) {
                    e.printStackTrace();
                }
            } else {
                this.handlePlayInfoResponse(sipResponse);
            }
        }
        log.debug("Leaving DlgcPlayer::processSipInfoResponse");
    }

    public void handlePlayInfoResponse(SipServletResponse sipResponse) {
    }

    public void queuePlayRequest(URI[] streamIds, RTC[] rtcs, Parameters parameters) throws MsControlException {
        Parameters params = this.getParameters(parameters);
        if (params.get((Object)BEHAVIOUR_IF_BUSY).equals(QUEUE_IF_BUSY)) {
            this.requestQueue.add(new DlgcPlayRequest(streamIds, rtcs, parameters));
        } else if (params.get((Object)BEHAVIOUR_IF_BUSY).equals(STOP_IF_BUSY)) {
            this.stop(true);
            this.requestQueue.add(new DlgcPlayRequest(streamIds, rtcs, parameters));
        } else if (params.get((Object)BEHAVIOUR_IF_BUSY).equals(FAIL_IF_BUSY)) {
            throw new MsControlException("Player BUSY");
        }
    }

    public void sendPlayMsg(URI[] streamIds, RTC[] rtcs, Parameters parameters) throws MsControlException {
    }

    public void sendPlayCollectMsg(int numOfSignals, Parameter[] pattern, Parameters parameters, boolean bargeEnabled) throws MsControlException {
    }

    public void sendCollectMsg(int numOfSignals, Parameter[] pattern, Parameters parameters, boolean bargeEnabled) throws MsControlException {
        log.debug("Not supported in DlgcPlayer");
    }

    public void sendSigGenMsg(String signals, Parameters parameters) throws MsControlException {
    }

    public void sendStopMsg(boolean stopAll) {
    }

    public void stop(boolean stopAll) {
        try {
            log.info("JSR309 API REQUEST:play stop() : MG MEDIA OBJID: " + ((DlgcMediaGroup)this.container).getMediaObject());
            ((DlgcPlayerState)this.getState()).stopMsg(this, stopAll);
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected DlgcParameters getSupportedParameters() {
        return supportedParameters;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    public static void loadSupportedFeatures(DlgcSupportedFeatures sf) {
        sf.appendSfParameters(supportedFeatures.getSupportedParameters());
        sf.appendSfEventTypes(supportedFeatures.getSupportedEventTypes());
        sf.appendSfValues(supportedFeatures.getSupportedValues());
        sf.appendSfQualifiers(supportedFeatures.getSupportedQualifiers());
    }

    @Override
    public DlgcPlayerProxy getProxy() {
        DlgcResourceContainer container = (DlgcResourceContainer)this.container;
        String componentProxyId = container.getProxyId();
        String sasId = ((DlgcMediaSession)container.getMediaSession()).getProxyId();
        String msObjId = ((DlgcMediaSession)container.getMediaSession()).getMediaObject();
        return new DlgcPlayerProxy(sasId, componentProxyId, msObjId);
    }

    public void setPlayerState(DlgcPlayerState s) {
        this.setState(s);
    }

    public DlgcPlayerState getPlayerState() {
        return (DlgcPlayerState)this.getState();
    }

    public DlgcSigDetectorFSM getAssociatedSignalDetectorFSM() {
        return this.mySignalDetectorFSM;
    }

    public void processPlayAckMsg(SipServletResponse message) {
    }

    public void saveCompleteEvent(DlgcPlayerEvent event) {
        this.savedPlayCompleteEvent = event;
    }

    public DlgcPlayerEvent getCompleteEvent() {
        return this.savedPlayCompleteEvent;
    }

    static {
        log = LoggerFactory.getLogger(DlgcPlayer.class);
        IDLE = new DlgcPlayerState_Idle();
        ACTIVATING = new DlgcPlayerState_Activating();
        ACTIVE = new DlgcPlayerState_Active();
        PAUSED = new DlgcPlayerState_Paused();
        STOPPING = new DlgcPlayerState_Stopping();
        STOPP_ACKED = new DlgcPlayerState_Stop_Acked();
        WAIT_FOR_STOP_ACK_BUT_PLAY_COMPLETE = new DlgcPlayerState_Waiting_StopAck_PlayComplete();
        supportedEventTypes = new HashSet<EventType>();
        supportedEventTypes.add(PlayerEvent.PLAY_COMPLETED);
        supportedQualifiers = new HashSet<Qualifier>();
        supportedQualifiers.add(PlayerEvent.DURATION_EXCEEDED);
        supportedQualifiers.add(PlayerEvent.END_OF_PLAY_LIST);
        supportedParameters = new DlgcParameters();
        supportedParameters.put(INTERVAL, DlgcIntervalParameter.instance);
        supportedParameters.put(MAX_DURATION, DlgcMaxDurationParameter.instance);
        supportedParameters.put(REPEAT_COUNT, DlgcRepeatCountParameter.instance);
        supportedParameters.put(START_OFFSET, DlgcStartOffsetParameter.instance);
        supportedParameters.put(ENABLED_EVENTS, DlgcEnabledEventsParameter.instance);
        supportedParameters.put(BEHAVIOUR_IF_BUSY, DlgcBehaviorIfBusyParameter.instance);
        supportedParameters.put(Player.AUDIO_CODEC, DlgcAudioCodecParameter.instance);
        supportedParameters.put(Player.FILE_FORMAT, DlgcFileFormatParameter.instance);
        supportedFeatures.setSfParameters(supportedParameters.keySet());
        supportedFeatures.setSfEventTypes(supportedEventTypes);
        supportedFeatures.setSfQualifiers(supportedQualifiers);
    }

    class DlgcPlayRequest
    implements Serializable {
        public URI[] streamIds;
        public RTC[] rtcs;
        public Parameters parameters;

        public DlgcPlayRequest(URI[] streamIds, RTC[] rtcs, Parameters parameters) {
            this.streamIds = streamIds;
            this.rtcs = rtcs;
            this.parameters = parameters;
        }
    }
}

