/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxyHelper;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayerProxy;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorderProxy;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetectorProxy;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGeneratorProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalGenerator;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaGroupProxy
extends DlgcProxy
implements MediaGroup,
Serializable {
    private static final long serialVersionUID = 78377750392L;
    private static Logger log = LoggerFactory.getLogger(DlgcMediaGroupProxy.class);

    public DlgcMediaGroupProxy(String sasId, String containerId, String msObjId) {
        super(sasId, containerId, msObjId);
    }

    public Player getPlayer() throws MsControlException {
        DlgcPlayerProxy pproxy = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxyId);
            Player player = mg.getPlayer();
            pproxy = ((DlgcPlayer)player).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to create getPlayer", (Throwable)e);
            throw new MsControlException("Failed to create getPlayer", (Throwable)e);
        }
        return pproxy;
    }

    public Recorder getRecorder() throws MsControlException {
        DlgcRecorderProxy pproxy = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxyId);
            Recorder recorder = mg.getRecorder();
            pproxy = ((DlgcRecorder)recorder).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to create getRecorder", (Throwable)e);
            throw new MsControlException("Failed to create getRecorder", (Throwable)e);
        }
        return pproxy;
    }

    public SignalDetector getSignalDetector() throws MsControlException {
        DlgcSignalDetectorProxy pproxy = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxyId);
            SignalDetector res = mg.getSignalDetector();
            pproxy = ((DlgcSignalDetector)res).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to create getSignalDetector", (Throwable)e);
            throw new MsControlException("Failed to create getSignalDetector", (Throwable)e);
        }
        return pproxy;
    }

    public SignalGenerator getSignalGenerator() throws MsControlException {
        DlgcSignalGeneratorProxy pproxy = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String containerProxyId = this.getContainerProxyId();
            String mediaId = this.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxyId);
            SignalGenerator gen = mg.getSignalGenerator();
            pproxy = ((DlgcSignalGenerator)gen).getProxy();
            pproxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to create getSignalDetector", (Throwable)e);
            throw new MsControlException("Failed to create getSignalDetector", (Throwable)e);
        }
        return pproxy;
    }

    public void stop() {
        if (DlgcInstrumentPropertyMgr.bUseProxyDoAction) {
            log.debug("DlgcMediaGroupProxy::stop  using stopSync");
        } else {
            log.debug("DlgcMediaGroupProxy::stop  using MediaGroup Stop All based on stopAsync");
            this.stopAsync();
        }
    }

    public void stopAsync() {
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            final String containerProxyId = this.getContainerProxyId();
            final String mediaId = this.getMsObjectId();
            String sasId = this.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("MediaGroup Stop All");
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxyId);
                    mg.setMonitor(monitor);
                    mg.stop();
                }
            });
            log.debug("stopAsync:: Waiting synchronously for Media Group Stop request to return");
            monitor.waitForRequestCompletion();
            log.debug("stopAsync: Media Group Stop() Monitor returned with the following status: " + monitor.getStatusString());
            DlgcMediaGroup mg = (DlgcMediaGroup)session.getMediaObjectByProxyId(containerProxyId);
            mg.setMonitor(null);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "stopAsync Failed Execute Media Group Stop with the following exception: " + e.toString());
        }
    }

    public JoinableStream getJoinableStream(JoinableStream.StreamType strType) throws MsControlException {
        return DlgcProxyHelper.getJoinableStream(this, strType);
    }

    public JoinableStream[] getJoinableStreams() throws MsControlException {
        return DlgcProxyHelper.getJoinableStreams(this);
    }

    public Joinable[] getJoinees() throws MsControlException {
        return DlgcProxyHelper.getJoinees(this);
    }

    public Joinable[] getJoinees(Joinable.Direction dir) throws MsControlException {
        return DlgcProxyHelper.getJoinees(this, dir);
    }

    public void join(Joinable.Direction dir, Joinable component) throws MsControlException {
        DlgcProxyHelper.join(this, dir, component);
    }

    public void joinInitiate(Joinable.Direction dir, Joinable component, Serializable serial) throws MsControlException {
        DlgcProxyHelper.joinInitiate(this, dir, component, serial);
    }

    public void unjoin(Joinable component) throws MsControlException {
        DlgcProxyHelper.unjoin(this, component);
    }

    public void unjoinInitiate(Joinable component, Serializable serial) throws MsControlException {
        DlgcProxyHelper.unjoinInitiate(this, component, serial);
    }

    public void addListener(JoinEventListener evLIstener) {
        DlgcProxyHelper.addListener((DlgcProxy)this, evLIstener);
    }

    public MediaSession getMediaSession() {
        return DlgcProxyHelper.getMediaSession(this);
    }

    public void removeListener(JoinEventListener jeListener) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, jeListener);
    }

    public void confirm() throws MsControlException {
        DlgcProxyHelper.confirm(this);
    }

    public MediaConfig getConfig() {
        return DlgcProxyHelper.getConfig(this);
    }

    public <R> R getResource(Class<R> resourteType) throws MsControlException {
        return DlgcProxyHelper.getResource(this, resourteType);
    }

    public void triggerAction(Action anAction) {
        DlgcProxyHelper.triggerAction(this, anAction);
    }

    public Parameters createParameters() {
        return DlgcProxyHelper.createParameters(this);
    }

    public Iterator<MediaObject> getMediaObjects() {
        return DlgcProxyHelper.getMediaObjects(this);
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> objType) {
        return DlgcProxyHelper.getMediaObjects(this, objType);
    }

    public Parameters getParameters(Parameter[] arg0) {
        return DlgcProxyHelper.getParameters(this, arg0);
    }

    public URI getURI() {
        return DlgcProxyHelper.getURI(this);
    }

    public void release() {
        DlgcProxyHelper.release(this);
    }

    public void setParameters(Parameters arg0) {
        DlgcProxyHelper.setParameters(this, arg0);
    }

    public void addListener(AllocationEventListener arg0) {
        DlgcProxyHelper.addListener((DlgcProxy)this, arg0);
    }

    public void removeListener(AllocationEventListener arg0) {
        DlgcProxyHelper.removeListener((DlgcProxy)this, arg0);
    }
}

