/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.mediagroup.MediaGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaGroupConfig
extends DlgcMediaConfig {
    private static final long serialVersionUID = 1L;
    private static DlgcSupportedFeatures supportedFeatures;
    private static Logger log;

    public DlgcMediaGroupConfig() {
    }

    public DlgcMediaGroupConfig(Configuration<MediaGroup> mgConf) {
        if (mgConf == MediaGroup.PLAYER) {
            this.myConfiguration = MediaGroup.PLAYER;
            this.resourceList.add(DlgcPlayer.class);
        } else if (mgConf == MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR) {
            this.myConfiguration = MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR;
            this.resourceList.add(DlgcPlayer.class);
            this.resourceList.add(DlgcRecorder.class);
            this.resourceList.add(DlgcSignalDetector.class);
        } else if (mgConf == MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR_SIGNALGENERATOR) {
            this.myConfiguration = MediaGroup.PLAYER_RECORDER_SIGNALDETECTOR_SIGNALGENERATOR;
            this.resourceList.add(DlgcPlayer.class);
            this.resourceList.add(DlgcRecorder.class);
            this.resourceList.add(DlgcSignalDetector.class);
            this.resourceList.add(DlgcSignalGenerator.class);
        } else if (mgConf == MediaGroup.PLAYER_SIGNALDETECTOR) {
            this.myConfiguration = MediaGroup.PLAYER_SIGNALDETECTOR;
            this.resourceList.add(DlgcPlayer.class);
            this.resourceList.add(DlgcSignalDetector.class);
        } else if (mgConf == MediaGroup.SIGNALDETECTOR) {
            this.myConfiguration = MediaGroup.SIGNALDETECTOR;
            this.resourceList.add(DlgcSignalDetector.class);
        } else {
            log.error("The Media Group Configuration is recognized");
        }
    }

    public static DlgcMediaConfig configurationInstance(Configuration<MediaGroup> predefinedConfig) {
        return new DlgcMediaGroupConfig(predefinedConfig);
    }

    public static DlgcSupportedFeatures loadSupportedFeatures() {
        return supportedFeatures;
    }

    static void loadMediaGroupFeatures() {
        DlgcPlayer.loadSupportedFeatures(supportedFeatures);
        DlgcRecorder.loadSupportedFeatures(supportedFeatures);
        DlgcSignalDetector.loadSupportedFeatures(supportedFeatures);
        DlgcSignalGenerator.loadSupportedFeatures(supportedFeatures);
    }

    static {
        log = LoggerFactory.getLogger(DlgcMediaGroupConfig.class);
        supportedFeatures = new DlgcSupportedFeatures();
        DlgcMediaGroupConfig.loadMediaGroupFeatures();
    }
}

