/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.mediagroup;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameter;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroupProxy;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorFSM;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSigDetectorStates;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalGenerator;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.Resource;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaGroup
extends DlgcJoinableContainer
implements MediaGroup {
    private static final long serialVersionUID = -1L;
    protected int stopAllResourcesCount = 0;
    Queue<String> activeResources = null;
    private static DlgcParameters supportedParameters;
    private static Logger log;
    private boolean isActive = false;

    public DlgcMediaGroup(MediaConfig cfg, MediaSession ms, Parameters params) {
        super(ms, "MG-");
        this.buildUri(this.getClass().getName());
        this.joinMasterPriority = 3;
        this.stopAllResourcesCount = 0;
        this.activeResources = null;
        this.initMediaGroupResourceTypes(cfg, params);
    }

    protected void initMediaGroupResourceTypes(MediaConfig cfg, Parameters params) {
        Iterator<Class<?>> iter = ((DlgcMediaConfig)cfg).getResourceList();
        while (iter.hasNext()) {
            try {
                Class<?> resourceClass = iter.next();
                Constructor<?> ctr = resourceClass.getConstructor(MediaGroup.class);
                Resource resource = (Resource)ctr.newInstance(this);
                this.resourceMap.put(resourceClass, resource);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.setDefaultParameters(this.getDefaultParameters());
        if (params != null) {
            this.setParameters(params);
        }
    }

    public DlgcMediaGroup(MediaConfig cfg, MediaSession ms, Parameters params, String prefix) {
        super(ms, prefix);
        String mediaObjectId = null;
        this.stopAllResourcesCount = 0;
        this.activeResources = null;
        if (null != params && !params.isEmpty()) {
            Set paramSet = params.entrySet();
            Iterator paramIt = paramSet.iterator();
            Map.Entry pair = null;
            while (paramIt.hasNext()) {
                pair = (Map.Entry)paramIt.next();
                if (!((Parameter)pair.getKey()).toString().equalsIgnoreCase("MEDIAOBJECT_ID")) continue;
                mediaObjectId = pair.getValue().toString();
            }
        }
        if (null != mediaObjectId) {
            this.buildUri(this.getClass().getName() + "/" + mediaObjectId);
        } else {
            this.buildUri(this.getClass().getName());
        }
        this.joinMasterPriority = 3;
    }

    public DlgcNetworkConnection joinedWithNetworkConnection() {
        DlgcNetworkConnection nc = null;
        DlgcXMediaMixer mx = null;
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = this.getJoinees()) {
                if (j instanceof NetworkConnection) {
                    nc = (DlgcNetworkConnection)j;
                    log.debug("joinedWithNetworkConnection(): Returning NetworkConnection " + nc.toDebug());
                } else {
                    if (!(j instanceof MediaMixer)) continue;
                    mx = (DlgcXMediaMixer)j;
                    nc = mx.getActiveControlLeg();
                    log.debug("joinedWithNetworkConnection(): Returning Mixer Control Leg " + nc.toDebug());
                }
                break;
            }
        }
        catch (MsControlException e) {
            log.error("joinedWithNetworkConnection() exception: " + e.toString());
        }
        return nc;
    }

    public DlgcNetworkConnection joinedWithNetworkConnectionX() {
        DlgcNetworkConnection nc = null;
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = this.getJoinees()) {
                if (!(j instanceof NetworkConnection)) continue;
                nc = (DlgcNetworkConnection)j;
                break;
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
        return nc;
    }

    public DlgcMediaMixer joinedWithMixer() {
        DlgcMediaMixer mx = null;
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = this.getJoinees()) {
                if (!(j instanceof MediaMixer)) continue;
                mx = (DlgcMediaMixer)j;
                break;
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
        return mx;
    }

    public void moveNetConnectionFromIvrBackToConference() {
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = this.getJoinees()) {
                if (!(j instanceof NetworkConnection)) continue;
                DlgcNetworkConnection nc = (DlgcNetworkConnection)j;
                nc.unpark();
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    public Parameters getDefaultParameters() {
        DlgcParameters parameters = new DlgcParameters();
        for (Parameter param : supportedParameters.keySet()) {
            parameters.put(param, ((DlgcParameter)supportedParameters.get(param)).getValue());
        }
        return parameters;
    }

    public Player getPlayer() throws MsControlException {
        return this.getResource(DlgcPlayer.class);
    }

    public Recorder getRecorder() throws MsControlException {
        return this.getResource(DlgcRecorder.class);
    }

    public SignalDetector getSignalDetector() throws MsControlException {
        return this.getResource(DlgcSignalDetector.class);
    }

    public SignalGenerator getSignalGenerator() throws MsControlException {
        return this.getResource(DlgcSignalGenerator.class);
    }

    @Override
    public void join(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        log.info("JSR309 API REQUEST:MediaGroup join(): MG MEDIA OBJID: " + this.getMediaObject());
        super.join(direction, joinee);
        if (joinee instanceof MediaMixer) {
            ((DlgcMediaMixer)joinee).addLeg(this);
        }
    }

    @Override
    public void joinNotify(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        super.join(direction, joinee);
        if (joinee instanceof MediaMixer) {
            ((DlgcMediaMixer)joinee).addLeg(this);
        }
    }

    public void stop() {
        log.info("JSR309 API REQUEST:MediaGroup stop(): Stop all active Resources under the Media Group with MG MEDIA OBJID: " + this.getMediaObject());
        this.whatAreTheActiveResources();
        Iterator it = this.activeResources.iterator();
        this.stopAllResourcesCount = this.activeResources.size();
        if (this.stopAllResourcesCount > 0) {
            log.debug("stopAllResourcesCount: " + new Integer(this.stopAllResourcesCount).toString());
            this.stopExecute();
        } else {
            log.debug("DlgcMediaGroup::stop() MG STOP ALL: No Resources are running under this Media Group...nothing to stop...returning");
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.debug("DlgcMediaGroup::stop():Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("DlgcMediaGroup::stop()::stop calling Monitor notifyRequestCompleted with no resource found to do stop ");
                monitor.notifyRequestCompleted(bStatus, "Media Group Stop - with no resource found to do stop");
                log.debug("DlgcMediaGroup::stop()::stop returned from Monitor notifyRequestCompleted with no resource found to do stop ");
            }
        }
        log.info("LEAVING JSR309 API REQUEST:MediaGroup stop()");
    }

    public void stopExecute() {
        log.info("Entering DlgcMediaGroup::stopExecute: Stop all active Resources under the Media Group with MG MEDIA OBJID: " + this.getMediaObject());
        if (this.stopAllResourcesCount > 0) {
            log.debug("stopAllResourcesCount: " + new Integer(this.stopAllResourcesCount).toString());
            String res = this.activeResources.peek();
            if (res.equalsIgnoreCase("PLAYER_DETECTOR")) {
                log.debug("MG STOP ALL: Calling Detector Resource Stop");
                this.tryToForcePlayerDetectorStop();
            } else if (res.equalsIgnoreCase("DETECTOR")) {
                log.debug("MG STOP ALL: Calling Detector Resource Stop");
                this.tryToForceDetectorStop();
            } else if (res.equalsIgnoreCase("PLAYER")) {
                log.debug("MG STOP ALL: Calling Player Resource Stop");
                this.tryToForcePlayerStop();
            } else if (res.equalsIgnoreCase("RECORDER")) {
                log.debug("MG STOP ALL: Calling Recorder Resource Stop");
                this.tryToForceRecorderStop();
            } else {
                log.error("MediaGroup.stop() should never get here ");
                DlgcSync2AsyncMonitor monitor = this.getMonitor();
                if (monitor == null) {
                    log.debug("DlgcMediaGroup::stop():Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
                } else {
                    boolean bStatus = true;
                    log.debug("DlgcMediaGroup::stop()::stop calling Monitor notifyRequestCompleted should never get here ");
                    monitor.notifyRequestCompleted(bStatus, "Media Group Stop - should never get here");
                    log.debug("DlgcMediaGroup::stop()::stop returned from Monitor notifyRequestCompleted should never get here ");
                }
            }
        } else {
            log.debug("MG STOP ALL: No Resources are running under this Media Group...nothing to stop");
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.debug("DlgcMediaGroup::stop():Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("DlgcMediaGroup::stop()::stop calling Monitor notifyRequestCompleted with no resource found to do stop ");
                monitor.notifyRequestCompleted(bStatus, "Media Group Stop - with no resource found to do stop");
                log.debug("DlgcMediaGroup::stop()::stop returned from Monitor notifyRequestCompleted with no resource found to do stop ");
            }
        }
        log.info("LEAVING DlgcMediaGroup::stopExecute");
    }

    public synchronized void resourceStopNotifier(String resourceJustStopped) {
        log.debug("stopNextResource:: resource that was stopped: " + resourceJustStopped);
        String res = this.activeResources.poll();
        if (res != null) {
            --this.stopAllResourcesCount;
            if (res.equalsIgnoreCase(resourceJustStopped)) {
                log.error("stopNextResource:: resource " + resourceJustStopped + " just Stopped and remove from activeResource List ");
            } else {
                log.debug("stopNextResource:: Queue resource " + res + " passed in Resource to stop: " + resourceJustStopped);
            }
        }
        if (this.stopAllResourcesCount == 0) {
            this.activeResources.clear();
            log.debug("stopNextResource informing Media Group Proxy Monitor that we are done processing Media Group ");
            DlgcSync2AsyncMonitor monitor = this.getMonitor();
            if (monitor == null) {
                log.debug("DlgcMediaGroup::stopNextResource():Stop in a synchronous mode but DlgcSync2AsyncMonitor is NULL");
            } else {
                boolean bStatus = true;
                log.debug("DlgcMediaGroup::stopNextResource()::stop calling Monitor notifyRequestCompleted Media Group Proxy Monitor - we are done processing Media Group Stop");
                monitor.notifyRequestCompleted(bStatus, "Media Group Stop - with no resource found to do stop");
                log.debug("DlgcMediaGroup::stopNextResource()::stop returned from Monitor notifyRequestCompleted - we are done processing Media Group Stop ");
            }
        } else {
            log.debug("DlgcMediaGroup::stopNextResource() checking for another resource stop");
            if (this.stopAllResourcesCount != 0) {
                log.debug("DlgcMediaGroup::stopNextResource() checking for another resource stop -> calling stopExecute again");
                this.stopExecute();
            }
        }
        log.debug(" Leaving stopNextResource ");
    }

    protected void tryToForcePlayerDetectorStop() {
        try {
            DlgcXPlayer player = (DlgcXPlayer)this.getPlayer();
            DlgcSigDetectorFSM sdFSM = player.getAssociatedSignalDetectorFSM();
            if (sdFSM == null) {
                log.debug("tryToForcePlayerDetectorStop:: but Detector FSM was found null..skipping request.");
            } else {
                DlgcSignalDetector sd = sdFSM.getSignalDetector();
                DlgcSigDetectorStates state = (DlgcSigDetectorStates)sdFSM.getPresentState();
                if (state == DlgcSigDetectorStates.initialState || state == DlgcSigDetectorStates.stopPendingState || state == DlgcSigDetectorStates.waitForFlushBufferState) {
                    log.debug("Inside tryToForcePlayerDetectorStop:: Detector state not active State thus no need to execute stop request. State: " + state.getName());
                } else {
                    log.debug("Inside tryToForcePlayerDetectorStop:: Detector state is in active State executing stop State: " + state.getName());
                    sd.stop();
                }
            }
        }
        catch (MsControlException msControlException) {
            // empty catch block
        }
    }

    protected void tryToForceDetectorStop() {
        try {
            DlgcXSignalDetector sd = (DlgcXSignalDetector)this.getSignalDetector();
            if (sd != null) {
                log.debug("tryToForceDetectorStop:: got valid detector");
                DlgcSigDetectorFSM detectorFSM = sd.getDetectorFSM();
                if (detectorFSM == null) {
                    log.debug("tryToForceDetectorStop:: but Detector FSM was found null..skipping request.");
                } else {
                    String state = detectorFSM.getPresentStateName();
                    if (state.equalsIgnoreCase("DlgcReceivingRdyState")) {
                        log.debug("Inside tryToForceDetectorStop:: Detector state is in active State executing stop State: " + state);
                        sd.stop();
                    } else {
                        log.debug("Inside tryToForceDetectorStop:: Detector state not active State thus no need to execute stop request. State: " + state);
                    }
                }
            }
        }
        catch (MsControlException e) {
            log.error(e.toString());
        }
    }

    public int getActiveResources() {
        return this.stopAllResourcesCount;
    }

    public boolean isItDetectorResourceActive() {
        return this.activeResources.contains(new String("DETECTOR"));
    }

    public void resetActiveResourceList() {
        this.activeResources = null;
    }

    protected void whatAreTheActiveResources() {
        this.activeResources = new LinkedList<String>();
        try {
            DlgcXRecorder recorder;
            String recorderState;
            DlgcXPlayer player = (DlgcXPlayer)this.getPlayer();
            DlgcSigDetectorFSM playerSDFSM = player.getAssociatedSignalDetectorFSM();
            DlgcXSignalDetector sd = (DlgcXSignalDetector)this.getSignalDetector();
            if (sd.getSignalingType() == DlgcSignalDetector.SIGNAL_TYPES.ASYNC_COLLECT) {
                log.debug("whatAreTheActiveResources:: In Async COllection mode");
                DlgcSigDetectorFSM detectorFSM = sd.getDetectorFSM();
                String detectorPresentState = detectorFSM.getPresentStateName();
                if (detectorPresentState.equalsIgnoreCase("DlgcReceivingRdyState")) {
                    log.debug("whatAreTheActiveResources:: Adding detector found in the following state: " + detectorPresentState);
                    this.activeResources.add("DETECTOR");
                } else {
                    log.debug("whatAreTheActiveResources:: detector found but in the following state: " + detectorPresentState + "..not active..ignoring");
                }
            } else if (sd.getSignalingType() == DlgcSignalDetector.SIGNAL_TYPES.PLAY_AND_COLLECT) {
                log.debug("whatAreTheActiveResources:: In PLAY_AND_COLLECT mode... it will be handle by the player session below...");
            }
            String playerState = player.getPlayerPresentState();
            if (playerState != null && playerState.equalsIgnoreCase("DlgcPlayerState_Active")) {
                log.debug("Inside whatAreTheActiveResources:: Adding Player Resource to Active Media Group Resource List");
                this.activeResources.add("PLAYER");
            }
            if ((recorderState = (recorder = (DlgcXRecorder)this.getRecorder()).getRecorderPresentState()) != null && recorderState.equalsIgnoreCase("DlgcRecorderState_Active")) {
                log.debug("Inside whatAreTheActiveResources:: Adding Recorder Resource to Active Media Group Resource List");
                this.activeResources.add("RECORDER");
            }
        }
        catch (MsControlException e) {
            log.debug("whatAreTheActiveResources Ignoring Exception");
        }
    }

    protected void tryToForcePlayerStop() {
        try {
            DlgcXPlayer player = (DlgcXPlayer)this.getPlayer();
            String playerState = player.getPlayerPresentState();
            if (playerState == null) {
                log.debug("tryToForcePlayerStop:: playerState not found.. skipping request Player Stop.");
            } else if (playerState.equalsIgnoreCase("DlgcPlayerState_Active")) {
                log.debug("Inside tryToForcePlayerStop:: Executing Play Stop State: " + playerState);
                player.stop(true);
            } else {
                log.debug("tryToForcePlayerStop:: playerState is : " + playerState + " no need to call Play Stop");
            }
        }
        catch (MsControlException e) {
            log.debug("tryToForcePlayerStop:: " + e.toString());
        }
    }

    protected void tryToForceRecorderStop() {
        try {
            DlgcXRecorder recorder = (DlgcXRecorder)this.getRecorder();
            String recorderState = recorder.getRecorderPresentState();
            if (recorderState == null) {
                log.debug("tryToForceRecorderStop:: recorderState not found.. skipping request Recorder Stop.");
            } else if (recorderState.equalsIgnoreCase("DlgcRecorderState_Active")) {
                log.debug("Inside tryToForceRecorderStop:: Executing Record Stop State: " + recorderState);
                recorder.stop();
            } else {
                log.debug("tryToForceRecorderStop:: playerState is : " + recorderState + " no need to call Record Stop");
            }
        }
        catch (MsControlException e) {
            log.debug("tryToForceRecorderStop:: " + e.toString());
        }
    }

    @Override
    public JoinableContainer getMasterJoinable() {
        JoinableContainer jc = null;
        try {
            Joinable[] joinableArray = this.getJoinees();
            if (joinableArray[0] instanceof MediaMixer) {
                DlgcXMediaMixer mx = (DlgcXMediaMixer)joinableArray[0];
                jc = mx.getActiveControlLeg();
            } else {
                jc = (JoinableContainer)joinableArray[0];
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
        return jc;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    @Override
    public void processSipInfo(SipServletResponse response, DlgcSipConnectorContentIdsProxy sipReqProxy) {
        DlgcResource<?, ?> resource;
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> Entering DlgcMediaGroup: processSipInfo()");
        if (response.getStatus() >= 400) {
            log.error("DlgcMediaGroup::processSipInfo() - receive response error: " + new Integer(response.getStatus()).toString());
            DlgcJoinableContainer jc = (DlgcJoinableContainer)this.getMasterJoinable();
            if (jc instanceof DlgcNetworkConnection) {
                DlgcNetworkConnection nc = (DlgcNetworkConnection)jc;
                try {
                    DlgcSdpPortManager sdp = (DlgcSdpPortManager)nc.getSdpPortManager();
                    log.debug("Sending Application NETWORK_STREAM_FAILURE Notification");
                    sdp.sendApplicationEvent(SdpPortManagerEvent.NETWORK_STREAM_FAILURE, null, SdpPortManagerEvent.RESOURCE_UNAVAILABLE, "Media Server Disconnected Stream", SdpPortManagerEvent.STOPPED);
                }
                catch (MsControlException e) {
                    e.printStackTrace();
                }
            } else if (jc instanceof DlgcMediaMixer) {
                log.error("DlgcMediaGroup::processSipInfo() - receive response error: ignoring for DlgcMediaMixer");
            } else {
                log.error("DlgcMediaGroup::processSipInfo() - receive response error: ignoring for DlgcMediaMixer");
            }
            return;
        }
        SipServletRequest request = response.getRequest();
        if (request != null && (resource = sipReqProxy.getCachedResource()) != null) {
            resource.processSipInfoResponse(response, sipReqProxy);
        }
        log.debug(appLogId + "==> Returning DlgcMediaGroup: processSipInfo()");
    }

    @Override
    public void processSipInvite(SipServletResponse response) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> Entering DlgcMediaGroup: processSipInvite()");
        try {
            if (response.getStatus() == 200) {
                this.allocEventType = AllocationEvent.ALLOCATION_CONFIRMED;
                SipServletRequest request = response.createAck();
                request.send();
                this.isActive = true;
                this.startSessionTimer(response);
            } else {
                this.allocEventType = AllocationEvent.IRRECOVERABLE_FAILURE;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.isConfirmed = true;
        this.postAllocationEvent();
        log.debug(appLogId + "==> Returning DlgcMediaGroup: processSipInvite()");
    }

    @Override
    public void release() {
        if (!this.released) {
            try {
                Joinable[] joinableArray;
                for (Joinable j : joinableArray = this.getJoinees()) {
                    if (!(j instanceof MediaMixer) || !this.isActive) continue;
                    ((DlgcMediaMixer)j).removeLeg(this);
                }
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
        super.release();
    }

    public void sendMediaMessage(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        try {
            Joinable[] joinableArray;
            for (Joinable j : joinableArray = this.getJoinees()) {
                if (j instanceof NetworkConnection) {
                    DlgcNetworkConnection nc = (DlgcNetworkConnection)j;
                    nc.sendMediaMessage(message, notifier);
                    continue;
                }
                if (!(j instanceof MediaMixer)) continue;
                DlgcMediaMixer mx = (DlgcMediaMixer)j;
                mx.sendSipMessage(message, notifier);
            }
        }
        catch (MsControlException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processSipBye(SipServletRequest request) {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        log.debug(appLogId + "==> Entering DlgcMediaGroup: processSipBye()");
        this.isActive = false;
        super.processSipBye(request);
        log.debug(appLogId + "==> Returning DlgcMediaGroup: processSipBye()");
    }

    @Override
    public DlgcProxy getProxy() {
        DlgcMediaSession ms = (DlgcMediaSession)this.getMediaSession();
        String sasId = ms.getProxyId();
        String containerProxyId = this.getProxyId();
        String msId = ms.getMediaObject();
        return new DlgcMediaGroupProxy(sasId, containerProxyId, msId);
    }

    @Override
    public String toDebug() {
        String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
        String retStr = new String();
        retStr = retStr + appLogId + "\n $$$$$$ JMC Object DlgcMediaGroup = " + " \n";
        retStr = retStr + "Debug ID = " + this.debugId.toString() + " \n";
        retStr = retStr + "$$$$$$";
        return retStr;
    }

    static {
        log = LoggerFactory.getLogger(DlgcMediaGroup.class);
        supportedParameters = new DlgcParameters();
        supportedParameters.putAll(DlgcPlayer.loadSupportedParameters());
        supportedParameters.putAll(DlgcRecorder.loadSupportedParameters());
        supportedParameters.putAll(DlgcSignalDetector.loadSupportedParameters());
    }
}

