/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.join;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixerProxy;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapterProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcJoinableStream
implements JoinableStream,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcJoinableStream.class);
    private JoinableStream.StreamType type;
    private DlgcJoinableContainer container;
    private Map<DlgcSipConnectorContentIdsProxy, Joinable.Direction> JoineeMap = new HashMap<DlgcSipConnectorContentIdsProxy, Joinable.Direction>();

    public DlgcJoinableStream(JoinableStream.StreamType type, DlgcJoinableContainer container) {
        this.type = type;
        this.container = container;
    }

    public void addJoinee(Joinable joinee, Joinable.Direction direction) {
        DlgcJoinableStream js = null;
        DlgcJoinableContainer jContainer = null;
        if (joinee instanceof DlgcJoinableStream) {
            js = (DlgcJoinableStream)joinee;
            jContainer = js.container;
            DlgcSipConnectorContentIdsProxy prox = new DlgcSipConnectorContentIdsProxy(jContainer, null, js.type);
            this.JoineeMap.put(prox, direction);
        }
    }

    public JoinableContainer getContainer() {
        return this.container;
    }

    public JoinableStream.StreamType getType() {
        return this.type;
    }

    public Joinable[] getJoinees() throws MsControlException {
        return this.getJoineesLocal();
    }

    public void printJoineeMap() {
        log.debug("<<<<<<<<< printJoineeMap >>>>>>>>>>>>>>>>>");
        for (Map.Entry<DlgcSipConnectorContentIdsProxy, Joinable.Direction> entry : this.JoineeMap.entrySet()) {
            DlgcSipConnectorContentIdsProxy key = entry.getKey();
            Joinable.Direction d = entry.getValue();
            log.debug("Joinee Key (ContainerProxyId) = " + key.containerProxyId + " Joinee Value (Direction) = " + d.toString());
        }
    }

    private Joinable[] getJoineesLocal() {
        Joinable[] joineeArray = new Joinable[this.JoineeMap.size()];
        int i = 0;
        for (Map.Entry<DlgcSipConnectorContentIdsProxy, Joinable.Direction> entry : this.JoineeMap.entrySet()) {
            DlgcSipConnectorContentIdsProxy prox = entry.getKey();
            DlgcJoinableContainer theContainer = prox.getContainer();
            if (theContainer != null) {
                DlgcJoinableStream jss = new DlgcJoinableStream(prox.getStreamType(), theContainer);
                joineeArray[i++] = jss;
                continue;
            }
            log.debug("getJoineesLocal() : proxy container return null... ignoring this entry");
        }
        if (i == 0) {
            joineeArray = null;
            log.debug("getJoineesLocal():: returning null joineeArray");
        }
        return joineeArray;
    }

    public Joinable.Direction getJoineeDirection(JoinableStream peerStream) {
        DlgcJoinableStream js = (DlgcJoinableStream)peerStream;
        DlgcSipConnectorContentIdsProxy prox = new DlgcSipConnectorContentIdsProxy(js.container, null, js.type);
        Joinable.Direction dir = this.JoineeMap.get(prox);
        return dir;
    }

    public Joinable[] getJoinees(Joinable.Direction direction) throws MsControlException {
        ArrayList<DlgcJoinableStream> filteredList = new ArrayList<DlgcJoinableStream>();
        for (Map.Entry<DlgcSipConnectorContentIdsProxy, Joinable.Direction> entry : this.JoineeMap.entrySet()) {
            if (entry.getValue() != direction) continue;
            DlgcSipConnectorContentIdsProxy prox = entry.getKey();
            DlgcJoinableStream jss = new DlgcJoinableStream(prox.getStreamType(), prox.getContainer());
            filteredList.add(jss);
        }
        return (Joinable[])filteredList.toArray();
    }

    public void join(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        JoinableStream.StreamType sType = this.getType();
        DlgcJoinableStream joineeStream = null;
        if (joinee instanceof DlgcMixerAdapterProxy) {
            DlgcMixerAdapterProxy maProxy = (DlgcMixerAdapterProxy)joinee;
            String containerProxyId = maProxy.getContainerProxyId();
            SipApplicationSession appSession = maProxy.getProxySAS();
            String mediaId = maProxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMixerAdapter ma = (DlgcMixerAdapter)session.getMediaObjectByProxyId(containerProxyId);
            DlgcMediaMixer mm = ma.getMixer();
            joineeStream = (DlgcJoinableStream)mm.getJoinableStream(sType);
            joinee = mm;
        } else if (joinee instanceof DlgcMediaMixerProxy) {
            DlgcMediaMixerProxy mxProxy = (DlgcMediaMixerProxy)joinee;
            String containerProxyId = mxProxy.getContainerProxyId();
            SipApplicationSession appSession = mxProxy.getProxySAS();
            String mediaId = mxProxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaMixer mm = (DlgcMediaMixer)session.getMediaObjectByProxyId(containerProxyId);
            joineeStream = (DlgcJoinableStream)mm.getJoinableStream(sType);
            joinee = mm;
        } else {
            log.error("DLgcJoinableStream::join: joinee is not of proper type...error...returning");
            return;
        }
        if (this.container instanceof DlgcXNetworkConnection) {
            DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.container;
            if (sType.compareTo((Enum)JoinableStream.StreamType.audio) == 0) {
                nc.setJoinableStreamMode(DlgcNetworkConnection.JoinableStreamMode.AUDIO);
            } else if (sType.compareTo((Enum)JoinableStream.StreamType.video) == 0) {
                nc.setJoinableStreamMode(DlgcNetworkConnection.JoinableStreamMode.VIDEO);
            }
            nc.join(direction, (Joinable)joinee);
        } else {
            log.error("DlgcJoinableStream::join: Container type not supported - at this time connector only supports nc.getJoinableStream().join(mixer or mixeradapter) only");
        }
    }

    public void joinInitiate(Joinable.Direction arg0, Joinable arg1, Serializable arg2) throws MsControlException {
    }

    public void joinNotify(Joinable.Direction direction, Joinable joinee) {
        boolean bTrace = DlgcInstrumentPropertyMgr.bTraceJoin;
        if (bTrace) {
            log.debug("DlgcJoinableStream::joinNotify Entering");
            log.debug("Adding joinee  = " + ((JoinableStream)joinee).getContainer().toString() + " Direction = " + direction.toString());
            log.debug("To This container = " + this.container.getMediaObject());
        }
        this.addJoinee(joinee, direction);
    }

    public void removeJoinee(Joinable joinee) {
        if (joinee instanceof DlgcJoinableStream) {
            DlgcJoinableStream js = (DlgcJoinableStream)joinee;
            DlgcJoinableContainer jContainer = js.container;
            DlgcSipConnectorContentIdsProxy prox = new DlgcSipConnectorContentIdsProxy(jContainer, null, js.type);
            this.JoineeMap.remove(prox);
        }
    }

    private Joinable.Direction reverseDirection(Joinable.Direction direction) {
        Joinable.Direction dir = direction;
        if (direction.equals((Object)Joinable.Direction.SEND)) {
            dir = Joinable.Direction.RECV;
        } else if (direction.equals((Object)Joinable.Direction.RECV)) {
            dir = Joinable.Direction.SEND;
        }
        return dir;
    }

    public void unjoin(Joinable joinee) throws MsControlException {
        this.removeJoinee(joinee);
        ((DlgcJoinableStream)joinee).unjoinNotify((Joinable)this);
    }

    public void unjoinNotify(Joinable joinee) {
        this.removeJoinee(joinee);
    }

    public boolean isItJoinedToNcMixerOrAdapter() {
        Joinable[] jArray = this.getJoineesLocal();
        boolean isJOINED = false;
        if (jArray == null) {
            isJOINED = false;
        } else {
            for (Joinable j : jArray) {
                if (j instanceof NetworkConnection) {
                    isJOINED = true;
                    break;
                }
                if (j instanceof MediaMixer) {
                    isJOINED = true;
                    break;
                }
                if (!(j instanceof MixerAdapter)) continue;
                isJOINED = true;
                break;
            }
        }
        return isJOINED;
    }

    public void unjoinInitiate(Joinable arg0, Serializable arg1) throws MsControlException {
    }

    private boolean isMaster(Joinable joinee) {
        DlgcJoinableContainer joineeContainer = ((DlgcJoinableStream)joinee).container;
        return this.container.getJoinMasterPriority() < joineeContainer.getJoinMasterPriority();
    }
}

