/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.join;

import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinEvent;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableStream;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.TranscodingException;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.servlet.sip.ServletTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcJoinableContainer
extends DlgcResourceContainer
implements JoinableContainer {
    private static final long serialVersionUID = 1494534591931668680L;
    private static Logger log = LoggerFactory.getLogger(DlgcJoinableContainer.class);
    private Map<JoinableStream.StreamType, DlgcJoinableStream> JoinableStreamMap = new HashMap<JoinableStream.StreamType, DlgcJoinableStream>();
    private List<JoinEventListener> JoinEventListenerList = new ArrayList<JoinEventListener>();
    protected int joinMasterPriority;
    protected Integer debugId = null;

    public DlgcJoinableContainer(MediaSession ms, String prefix) {
        super(ms, prefix);
        Random randomGenerator = new Random();
        this.debugId = new Integer(randomGenerator.nextInt(100000));
        this.JoinableStreamMap.put(JoinableStream.StreamType.audio, new DlgcJoinableStream(JoinableStream.StreamType.audio, this));
        this.JoinableStreamMap.put(JoinableStream.StreamType.video, new DlgcJoinableStream(JoinableStream.StreamType.video, this));
    }

    public void printContainerJoinableStreamMap() {
        log.debug("<<<<<<<<< printContainerJoinableStreamMap >>>>>>>>>>>>>>>>>");
        for (Map.Entry<JoinableStream.StreamType, DlgcJoinableStream> entry : this.JoinableStreamMap.entrySet()) {
            DlgcJoinableStream val = entry.getValue();
            DlgcJoinableContainer jc = (DlgcJoinableContainer)val.getContainer();
            JoinableStream.StreamType t = entry.getKey();
            log.debug("Joinee Key (StreamType) = " + t.name() + " DlgcJoinableStream = " + jc.mediaObjectID);
        }
    }

    public JoinableStream getJoinableStream(JoinableStream.StreamType type) throws MsControlException {
        boolean bTrace = DlgcInstrumentPropertyMgr.bTraceJoin;
        if (bTrace) {
            log.debug("INSIDE DlgcJoinableContainer::getJoinableString Streamtype passed in = " + type.name());
            this.printContainerJoinableStreamMap();
        }
        return this.JoinableStreamMap.get(type);
    }

    public JoinableStream[] getJoinableStreams() throws MsControlException {
        JoinableStream[] streamArray = new JoinableStream[this.JoinableStreamMap.size()];
        return this.JoinableStreamMap.values().toArray(streamArray);
    }

    public void addListener(JoinEventListener listener) {
        this.JoinEventListenerList.add(listener);
    }

    public boolean isNewJoinee(JoinableContainer joinee) {
        Iterator<DlgcJoinableStream> iter = this.JoinableStreamMap.values().iterator();
        while (iter.hasNext()) {
            if (!iter.next().getContainer().equals(joinee)) continue;
            return false;
        }
        return true;
    }

    public void removeListener(JoinEventListener listener) {
        this.JoinEventListenerList.remove(listener);
    }

    public Joinable[] getJoinees() throws MsControlException {
        ArrayList<JoinableContainer> joineeList = new ArrayList<JoinableContainer>();
        Iterator<DlgcJoinableStream> iter = this.JoinableStreamMap.values().iterator();
        while (iter.hasNext()) {
            Joinable[] joinableArray = iter.next().getJoinees();
            if (joinableArray == null) continue;
            for (Joinable j : joinableArray) {
                if (j != null) {
                    JoinableContainer jc = ((JoinableStream)j).getContainer();
                    if (joineeList.contains(jc)) continue;
                    joineeList.add(jc);
                    continue;
                }
                log.debug("getJoinees() conatiner is null avoiding adding it to the joinee list...");
            }
        }
        Joinable[] joineeArray = new Joinable[joineeList.size()];
        return joineeList.toArray(joineeArray);
    }

    public boolean isJoinedToNetworkConectionOrMixer() throws MsControlException {
        boolean isJOINED = false;
        Joinable[] jSourceArray = this.getJoinees();
        if (jSourceArray == null) {
            isJOINED = false;
        } else {
            for (Joinable source : jSourceArray) {
                if (source instanceof NetworkConnection) {
                    isJOINED = true;
                    break;
                }
                if (source instanceof MediaMixer) {
                    isJOINED = true;
                    break;
                }
                if (!(source instanceof MixerAdapter)) continue;
                isJOINED = true;
                break;
            }
        }
        return isJOINED;
    }

    public Joinable[] getJoinees(Joinable.Direction direction) throws MsControlException {
        ArrayList<Joinable> joineeList = new ArrayList<Joinable>();
        Iterator<DlgcJoinableStream> iter = this.JoinableStreamMap.values().iterator();
        while (iter.hasNext()) {
            joineeList.add((Joinable)Arrays.asList(iter.next().getJoinees(direction)));
        }
        return (Joinable[])joineeList.toArray();
    }

    public int getJoinMasterPriority() {
        return this.joinMasterPriority;
    }

    public void join(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        boolean bTrace = DlgcInstrumentPropertyMgr.bTraceJoin;
        if (bTrace) {
            log.debug("Entering DlgcJoinableContainer:: join(Direction, Joinee)");
        }
        if (!this.validate(direction, joinee)) {
            throw new TranscodingException("Unsupported join configuration");
        }
        if (joinee instanceof JoinableStream) {
            DlgcJoinableStream stream;
            if (bTrace) {
                log.debug("Joinee is instanceOf JoinableStream ");
            }
            if ((stream = this.JoinableStreamMap.get(((JoinableStream)joinee).getType())) != null) {
                if (bTrace) {
                    log.debug("(DlgcJoinableStream) destStream = " + stream.getContainer().toString());
                }
            } else {
                throw new MsControlException("Invalid joinee... Unsupported stream type provided");
            }
            stream.joinNotify(direction, joinee);
            DlgcJoinableStream peerJoinable = (DlgcJoinableStream)joinee;
            peerJoinable.joinNotify(this.reverseDirection(direction), joinee);
        } else {
            JoinableStream[] srcStreamList;
            if (bTrace) {
                log.debug("Joinee is instanceOf JoinableContainer");
                log.debug("Join This = " + this.mediaObjectID + " ==> ");
                log.debug("Joinee = " + ((DlgcJoinableContainer)joinee).mediaObjectID);
            }
            for (JoinableStream srcStream : srcStreamList = this.getJoinableStreams()) {
                JoinableStream destStream = ((JoinableContainer)joinee).getJoinableStream(srcStream.getType());
                if (destStream == null) continue;
                if (bTrace) {
                    log.debug("(JoinableContainer) destStream = " + destStream.getContainer().toString());
                }
                ((DlgcJoinableStream)srcStream).joinNotify(direction, (Joinable)destStream);
            }
            if (bTrace) {
                log.debug("Reverse Join peer ==> this");
            }
            JoinableContainer peerJoinable = (JoinableContainer)joinee;
            peerJoinable = (JoinableContainer)joinee;
            ((DlgcJoinableContainer)peerJoinable).joinNotify(this.reverseDirection(direction), (Joinable)this);
        }
    }

    public void joinInitiate(Joinable.Direction direction, Joinable joinee, Serializable context) throws MsControlException {
        log.info("JSR309 API REQUEST:MediaGroup joinInitiate(): MG MEDIA OBJID: " + this.getMediaObject());
        log.debug("DlgcJoinableContainer::joinInitiate(): this toString: " + this.toString());
        log.debug("DlgcJoinableContainer::joinInitiate(): joinee: " + joinee.toString());
        this.join(direction, joinee);
        if (joinee instanceof MediaGroup) {
            log.debug("DlgcJoinableContainer::joinInitiate - sending JOINED event to the application for joinee: MediaGroup");
            DlgcJoinEvent event = new DlgcJoinEvent(JoinEvent.JOINED, (Joinable)this, joinee, context);
            this.postJoinEvent(event);
        }
    }

    public void postJoinEvent(JoinEvent event) {
        Iterator<JoinEventListener> iter = this.JoinEventListenerList.iterator();
        while (iter.hasNext()) {
            iter.next().onEvent(event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void joinNotify(Joinable.Direction direction, Joinable joinee) throws MsControlException {
        if (joinee instanceof JoinableStream) {
            DlgcJoinableStream stream = this.JoinableStreamMap.get(((JoinableStream)joinee).getType());
            if (stream == null) throw new MsControlException("Invalid joinee... Unsupported stream type provided");
            stream.joinNotify(direction, joinee);
            return;
        } else {
            JoinableStream[] srcStreamList;
            for (JoinableStream srcStream : srcStreamList = this.getJoinableStreams()) {
                JoinableStream destStream = ((JoinableContainer)joinee).getJoinableStream(srcStream.getType());
                if (destStream == null) continue;
                ((DlgcJoinableStream)srcStream).joinNotify(direction, (Joinable)destStream);
            }
        }
    }

    @Override
    public void processTimeout(ServletTimer timer) {
        if (!this.released) {
            this.sendSipMessage(new DlgcSipMessage(this, "BYE", null, "none", null));
        }
        this.postAllocationEvent(AllocationEvent.IRRECOVERABLE_FAILURE);
    }

    private Joinable.Direction reverseDirection(Joinable.Direction direction) {
        Joinable.Direction dir = direction;
        if (direction.equals((Object)Joinable.Direction.SEND)) {
            dir = Joinable.Direction.RECV;
        } else if (direction.equals((Object)Joinable.Direction.RECV)) {
            dir = Joinable.Direction.SEND;
        }
        return dir;
    }

    public void unjoin(Joinable joinee) throws MsControlException {
        if (joinee instanceof JoinableStream) {
            log.info("JSR309 API REQUEST:MediaGroup unjoin() on JoinableStream: MG MEDIA OBJID: " + this.getMediaObject());
            DlgcJoinableStream stream = this.JoinableStreamMap.get(((JoinableStream)joinee).getType());
            if (stream == null) {
                throw new MsControlException("Invalid joinee... Unsupported stream type provided");
            }
            stream.unjoinNotify(joinee);
            DlgcJoinableStream peerJoinable = (DlgcJoinableStream)joinee;
            peerJoinable.unjoinNotify(joinee);
        } else {
            JoinableStream[] srcStreamList;
            log.info("JSR309 API REQUEST:MediaGroup unjoin(): MG MEDIA OBJID: " + this.getMediaObject());
            for (JoinableStream srcStream : srcStreamList = this.getJoinableStreams()) {
                JoinableStream destStream = ((JoinableContainer)joinee).getJoinableStream(srcStream.getType());
                if (destStream == null) continue;
                ((DlgcJoinableStream)srcStream).unjoinNotify((Joinable)destStream);
            }
            JoinableContainer peerJoinable = (JoinableContainer)joinee;
            ((DlgcJoinableContainer)peerJoinable).unjoinNotify((Joinable)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unjoinNotify(Joinable joinee) throws MsControlException {
        if (joinee instanceof JoinableStream) {
            DlgcJoinableStream stream = this.JoinableStreamMap.get(((JoinableStream)joinee).getType());
            if (stream == null) throw new MsControlException("Invalid joinee... Unsupported stream type provided");
            stream.unjoinNotify(joinee);
            return;
        } else {
            JoinableStream[] srcStreamList;
            for (JoinableStream srcStream : srcStreamList = this.getJoinableStreams()) {
                JoinableStream destStream = ((JoinableContainer)joinee).getJoinableStream(srcStream.getType());
                if (destStream == null) continue;
                ((DlgcJoinableStream)srcStream).unjoinNotify((Joinable)destStream);
            }
        }
    }

    public Joinable.Direction getStreamDirection(JoinableStream peerStream) throws MsControlException {
        DlgcJoinableStream stream = (DlgcJoinableStream)this.getJoinableStream(peerStream.getType());
        return stream.getJoineeDirection(peerStream);
    }

    public void unjoinInitiate(Joinable joinee, Serializable context) throws MsControlException {
        this.unjoin(joinee);
    }

    public JoinableContainer getMasterJoinable() {
        return null;
    }

    public boolean validate(Joinable.Direction direction, Joinable joinee) {
        boolean result = true;
        if (this instanceof NetworkConnection) {
            if (joinee instanceof NetworkConnection) {
                result = true;
            } else if (joinee instanceof MediaMixer) {
                result = true;
            }
        } else if (this instanceof MediaGroup) {
            if (joinee instanceof MediaGroup) {
                result = false;
            } else if (joinee instanceof MediaMixer) {
                if (direction.equals((Object)Joinable.Direction.SEND)) {
                    result = false;
                }
            } else if (!direction.equals((Object)Joinable.Direction.DUPLEX) && joinee instanceof NetworkConnection) {
                result = false;
            }
        } else if (this instanceof MediaMixer) {
            if (joinee instanceof MediaMixer) {
                result = false;
            } else if (direction.equals((Object)Joinable.Direction.RECV)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public String toDebug() {
        String retStr = new String();
        retStr = retStr + "\n $$$$$$ JMC Object DlgcjoinableContainer =  \n";
        retStr = retStr + "Debug ID = " + this.debugId.toString() + " \n";
        retStr = retStr + "$$$$$$";
        return retStr;
    }
}

