/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.fsm;

import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipSession;
import com.vendor.dialogic.javax.media.mscontrol.fsm.DlgcState;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import java.io.Serializable;
import javax.media.mscontrol.MsControlException;
import javax.servlet.sip.SipServletResponse;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcFSM
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String sMessage = "Event Request Not Implemented ";
    protected final String StateEnteringCondition = "Entering Condition";
    protected final String StateLeavingCondition = "Leaving Condition";
    protected DlgcState nextState = null;
    protected DlgcState prevState = null;
    protected boolean debugEnabled = log.isDebugEnabled();
    protected boolean infoEnabled = log.isInfoEnabled();
    private static Logger log = LoggerFactory.getLogger(DlgcFSM.class);

    public synchronized void logFSMState(String modName, String evName, String cond) {
        if (this.infoEnabled) {
            String msg = cond.toString() + "{ " + modName + ": event[" + evName + "] ==> " + "PresentState:" + this.nextState.getName().toString() + ")}";
            log.debug(msg);
        }
    }

    public synchronized void logFSMNextState(String modName, String evName, String cond) {
        if (this.infoEnabled) {
            String msg = cond.toString() + "{ " + modName + ": event[" + evName + "] ==> " + "NextState:" + this.nextState.getName().toString() + ")}";
            log.debug(msg);
        }
    }

    public void evSipBye(SipServletResponse response) throws MsControlException {
        log.debug("evSipBye: Event Request Not Implemented ");
    }

    public void evSipInvite(SipServletResponse response) throws MsControlException {
        log.debug("evSipInvite: Event Request Not Implemented ");
    }

    public void evSipInvite(Response response, DlgcaSipSession session) throws MsControlException {
        log.debug("evSipInvite Standalone: Event Request Not Implemented ");
    }

    public void evSipInfo(SipServletResponse response) throws MsControlException {
        log.debug("evSipInfo: Event Request Not Implemented ");
    }

    public void evSipInfo(Response response, DlgcaSipSession session) throws MsControlException {
        log.debug("evSipInfo Standalone:  Event Request Not Implemented ");
    }

    public void evSipInfo(MsmlDocument.Msml message) throws MsControlException {
        log.debug("evSipInfo Msml Overload method Event Request Not Implemented ");
    }

    public synchronized void setState(DlgcState newState) {
        this.prevState = this.nextState;
        this.nextState = newState;
    }

    public synchronized DlgcState getPresentState() {
        return this.nextState;
    }

    public synchronized String getPresentStateName() {
        return this.nextState.getName();
    }

    public synchronized DlgcState getBasePreviousState() {
        return this.prevState;
    }

    public synchronized String getBasePreviousStateName() {
        return this.prevState.getName();
    }
}

