/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.asyncMgr;

import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackInterface;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynWorkDispatcherImplementor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.ibm.DlgcIbmAsyncDispatcherFactory;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.mobicents.DlgcMobicentsAsyncDispatcherFactory;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.occas.DlgcOccasAsyncDispatcherFactory;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.tropo.DlgcTropoAsyncDispatcherFactory;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.Serializable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcAsynDispatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static DlgcAsynWorkDispatcherImplementor dispatcherImpl;
    private static Logger log;

    public DlgcAsynDispatcher(Properties prop) {
        log.debug("DlgcAsyncDispatcher::CTOR - Creating ASYN DISPATCHER FOR CONNECTOR SIP MODE as SERVELT");
        if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("TELESTAX") == 0) {
            log.debug("Loading DlgcAsynDispatcherFactor for TELESTAX PLATFORM");
            DlgcMobicentsAsyncDispatcherFactory factory = new DlgcMobicentsAsyncDispatcherFactory();
            dispatcherImpl = factory.createDispatcher();
        } else if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("IBM") == 0) {
            log.debug("Loading DlgcAsynDispatcherFactor for IBM LIBERTY PLATFORM");
            DlgcIbmAsyncDispatcherFactory factory = new DlgcIbmAsyncDispatcherFactory();
            dispatcherImpl = factory.createDispatcher();
        } else if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("OCCAS5") == 0) {
            log.debug("Loading DlgcAsynDispatcherFactor for ORACLE PLATFORM");
            DlgcOccasAsyncDispatcherFactory factory = new DlgcOccasAsyncDispatcherFactory();
            dispatcherImpl = factory.createDispatcher();
        } else if (DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("TROPO") == 0) {
            log.debug("Loading DlgcAsynDispatcherFactor for TROPO PLATFORM");
            DlgcTropoAsyncDispatcherFactory factory = new DlgcTropoAsyncDispatcherFactory();
            dispatcherImpl = factory.createDispatcher();
        } else {
            log.error("Major Error - Could not load DlgcAsynDispatcherFactory invalid platform environment value");
        }
    }

    public static void asyncDispatch(String sasId, DlgcAsynCallbackInterface asyncWork) {
        if (dispatcherImpl == null) {
            log.error("Major error dispatcherImpl is null - fail to call asyncDisptch method");
        } else {
            dispatcherImpl.asyncDispatch(sasId, asyncWork);
        }
    }

    static {
        log = LoggerFactory.getLogger(DlgcAsynDispatcher.class);
    }
}

