/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.asip;

import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipMgr;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.media.mscontrol.resource.Resource;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.SupportedHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcaSipSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DlgcaSipMgr dlgcaSipMgr = null;
    private static Logger log = LoggerFactory.getLogger(DlgcaSipSession.class);
    private DlgcaMediaServer dlgcMediaServer = null;
    private Integer tag = null;
    private Integer msmlVal = null;
    private Dialog sipDialog = null;
    private DlgcXNetworkConnection dialog309Owner = null;
    Map<String, Resource<ResourceContainer>> tagIdRequestTo309Map = null;
    Map<Long, Request> cseqIdResponseToRequestMap = null;
    static String XMS_MSML_NAME = "msml";
    private Map<String, Object> attributeMap = null;
    String sessionID = null;

    public DlgcaSipMgr getDlgcaSipMgr() {
        return this.dlgcaSipMgr;
    }

    public DlgcaSipSession(DlgcXNetworkConnection nc, DlgcaSipMgr dlgcaSipMgr) {
        this.dlgcaSipMgr = dlgcaSipMgr;
        this.dialog309Owner = nc;
        this.dlgcMediaServer = dlgcaSipMgr.getActiveMediaServer();
        int randomSeed = (int)System.nanoTime() & 0xFFFFFFF;
        this.tag = new Random(randomSeed).nextInt();
        this.msmlVal = new Random(randomSeed).nextInt();
        this.cseqIdResponseToRequestMap = new HashMap<Long, Request>();
        this.tagIdRequestTo309Map = new HashMap<String, Resource<ResourceContainer>>();
        this.attributeMap = new HashMap<String, Object>();
        Integer sID = new Random(randomSeed).nextInt();
        this.sessionID = "ALONG-" + sID.toString();
    }

    public Dialog getSipDialog() {
        return this.sipDialog;
    }

    public DlgcXNetworkConnection getDialog309Owner() {
        return this.dialog309Owner;
    }

    public void setDialog309Owner(DlgcXNetworkConnection dialog309Owner) {
        this.dialog309Owner = dialog309Owner;
    }

    public Resource<ResourceContainer> gettagIdRequestTo309Map(String tagId) {
        return this.tagIdRequestTo309Map.get(tagId);
    }

    public Resource<ResourceContainer> gettagIdRequestTo309MapAndDelete(String tagId) {
        return this.tagIdRequestTo309Map.remove(tagId);
    }

    public void settagIdRequestTo309Map(String tagId, Resource<ResourceContainer> jsr309Resource) {
        this.tagIdRequestTo309Map.put(tagId, jsr309Resource);
    }

    public Request getcseqIdResponseToRequestMap(Long cseqKey) {
        return this.cseqIdResponseToRequestMap.get(cseqKey.intValue());
    }

    public Request getcseqIdResponseToRequestMapAndDelete(Long cseqKey) {
        return this.cseqIdResponseToRequestMap.remove(cseqKey.intValue());
    }

    public void setcseqIdResponseToRequestMap(Long cseqKey, Request request) {
        this.cseqIdResponseToRequestMap.put(cseqKey, request);
    }

    public void sendInvite(Byte[] uaSdp) throws SipException {
        log.debug("Entering DlgcaSipSession::sendInvite: Sending Invite to XMS");
        try {
            FromHeader fromHeader = this.createFromHeader();
            String toUsername = XMS_MSML_NAME + "=" + this.msmlVal.toString();
            String toXmsSipAddr = this.dlgcMediaServer.sMediaServerIP + ":" + this.dlgcMediaServer.iMediaServerPort.toString();
            ToHeader toHeader = this.createToHeader(toUsername, toXmsSipAddr);
            SipURI requestURI = this.dlgcaSipMgr.addressFactory.createSipURI(toUsername, toXmsSipAddr);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            try {
                ViaHeader viaHeader = this.dlgcaSipMgr.headerFactory.createViaHeader(this.dlgcMediaServer.connectorIP, this.dlgcMediaServer.connectorPort.intValue(), "udp", null);
                viaHeaders.add(viaHeader);
                CallIdHeader callIdHeader = this.dlgcaSipMgr.udpSipProvider.getNewCallId();
                MaxForwardsHeader maxForwards = this.dlgcaSipMgr.headerFactory.createMaxForwardsHeader(70);
                CSeqHeader cSeqHeader = this.dlgcaSipMgr.headerFactory.createCSeqHeader(1L, "INVITE");
                ContentTypeHeader ctypeHeader = this.dlgcaSipMgr.headerFactory.createContentTypeHeader("application", "sdp");
                ContactHeader contactHeader = this.createContactHeader();
                Request inviteRequest = null;
                inviteRequest = uaSdp != null ? this.dlgcaSipMgr.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards, ctypeHeader, (Object)uaSdp) : this.dlgcaSipMgr.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
                inviteRequest.addHeader((Header)contactHeader);
                SupportedHeader supportedHeader = this.dlgcaSipMgr.headerFactory.createSupportedHeader("timer");
                inviteRequest.addHeader((Header)supportedHeader);
                Header sessionExpireteHeader = this.dlgcaSipMgr.headerFactory.createHeader("Session-Expirte", "120;refresher");
                inviteRequest.addHeader(sessionExpireteHeader);
                ClientTransaction inviteTrans = this.getProviderBaseOnTrasport(inviteRequest, "sendInvite", requestURI);
                this.sipDialog = inviteTrans.getDialog();
                log.debug("DlgcaSipSession::sendInvite: Sending Invite to XMS: Request: " + inviteRequest.toString());
                this.dlgcaSipMgr.dlgcaSipXmitMgr.setDialogXmitMap(this.sipDialog.getDialogId(), this);
                inviteTrans.setApplicationData((Object)this);
                this.setcseqIdResponseToRequestMap(cSeqHeader.getSeqNumber(), inviteRequest);
                inviteTrans.sendRequest();
            }
            catch (InvalidArgumentException e) {
                log.error(e.toString());
                throw new SipException(e.toString());
            }
        }
        catch (ParseException e) {
            log.error(e.toString());
            throw new SipException(e.toString());
        }
        log.debug("Leaving DlgcaSipSession::sendInvite: Sending Invite to XMS");
    }

    public void sendBye() throws SipException {
        log.debug("Entering DlgcaSipSession::sendBye: Sending BYE to XMS");
        Request byeRequest = this.sipDialog.createRequest("BYE");
        try {
            ContactHeader contactHeader = this.createContactHeader();
            byeRequest.setHeader((Header)contactHeader);
            ClientTransaction trans = this.getProviderBaseOnTrasport(byeRequest, "sendBye", null);
            log.debug("DlgcaSipSession::sendBye: BYE REQUEST: " + byeRequest.toString());
            trans.setApplicationData((Object)this);
            trans.setApplicationData((Object)this);
            trans.sendRequest();
        }
        catch (ParseException e) {
            log.debug(e.toString());
            throw new SipException(e.toString());
        }
        log.debug("Leaving DlgcaSipSession::sendBye: Sending BYE to XMS ");
    }

    public void sendAck(Byte[] uaSdp) throws SipException {
        log.debug("Entering DlgcaSipSession::sendAck: Sending ACK to XMS");
        Request request = this.sipDialog.createRequest("ACK");
        try {
            ContactHeader contactHeader = this.createContactHeader();
            request.setHeader((Header)contactHeader);
            if (uaSdp != null) {
                log.debug("DlgcaSipSession::sendAck: Processing ack with SDP - Early Media Style Call");
                ContentTypeHeader ctypeHeader = this.dlgcaSipMgr.headerFactory.createContentTypeHeader("application", "sdp");
                request.setContent((Object)uaSdp, ctypeHeader);
            }
            ClientTransaction trans = this.getProviderBaseOnTrasport(request, "sendAck", null);
            log.debug("DlgcaSipSession::sendAck: ACK REQUEST: " + request.toString());
            trans.setApplicationData((Object)this);
            trans.sendRequest();
        }
        catch (ParseException e) {
            log.debug(e.toString());
            throw new SipException(e.toString());
        }
        log.debug("Leaving DlgcaSipSession::sendAck: Sending ACK to XMS ");
    }

    public void sendInfo(String tagId, String msmlMsg, Resource<ResourceContainer> resource309) throws SipException {
        log.debug("Entering DlgcaSipSession::sendInfo: Sending INFO to XMS: MSML Payload: " + msmlMsg);
        Request infoRequest = this.sipDialog.createRequest("INFO");
        try {
            ContactHeader contactHeader = this.createContactHeader();
            infoRequest.setHeader((Header)contactHeader);
            ContentTypeHeader ctypeHeader = this.dlgcaSipMgr.headerFactory.createContentTypeHeader("application", "xml");
            infoRequest.setContent((Object)msmlMsg, ctypeHeader);
            ClientTransaction infoTrans = this.getProviderBaseOnTrasport(infoRequest, "sendInfo", null);
            log.debug("DlgcaSipSession::sendInfo: INFO REQUEST: " + infoRequest.toString());
            infoTrans.setApplicationData((Object)this);
            this.setcseqIdResponseToRequestMap(this.sipDialog.getLocalSeqNumber(), infoRequest);
            if (tagId != null) {
                this.settagIdRequestTo309Map(tagId, resource309);
            }
            infoTrans.sendRequest();
        }
        catch (ParseException e) {
            log.debug(e.toString());
            throw new SipException(e.toString());
        }
        log.debug("Leaving DlgcaSipSession::sendInfo: Sending INFO to XMS ");
    }

    ContactHeader createContactHeader() throws ParseException {
        String fromConnectorSipAddr = this.dlgcaSipMgr.getActiveMediaServer().connectorIP;
        SipURI contactUri = this.dlgcaSipMgr.addressFactory.createSipURI("dlgajmc", fromConnectorSipAddr);
        Address contactAddress = this.dlgcaSipMgr.addressFactory.createAddress((URI)contactUri);
        contactAddress.setDisplayName("dlgajmc");
        ContactHeader contactHeader = this.dlgcaSipMgr.headerFactory.createContactHeader(contactAddress);
        return contactHeader;
    }

    ClientTransaction getProviderBaseOnTrasport(Request request, String requestName, SipURI requestURI) throws SipException {
        ClientTransaction trans = null;
        try {
            if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.UDP) {
                log.debug("DlgcaSipSession::getProviderBaseOnTrasport: Sending " + requestName + " to XMS using UDP SIP Provider");
                if (requestURI != null) {
                    requestURI.setTransportParam("udp");
                }
                trans = this.dlgcaSipMgr.udpSipProvider.getNewClientTransaction(request);
            } else if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.TCP) {
                log.debug("DlgcaSipSession::getProviderBaseOnTrasport: Sending " + requestName + " to XMS using TCP SIP Provider");
                if (requestURI != null) {
                    requestURI.setTransportParam("tcp");
                }
                trans = this.dlgcaSipMgr.tcpSipProvider.getNewClientTransaction(request);
            } else if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.TCP_UDP) {
                log.debug("DlgcaSipSession::getProviderBaseOnTrasport: Sending " + requestName + " to XMS using UDP SIP Provider even though Transport Porperty is set to TCP_UDP");
                if (requestURI != null) {
                    requestURI.setTransportParam("udp");
                }
                trans = this.dlgcaSipMgr.udpSipProvider.getNewClientTransaction(request);
            } else {
                log.debug("DlgcaSipSession::getProviderBaseOnTrasport: DEFAULT Sending " + requestName + " to XMS using UDP SIP Provider");
                if (requestURI != null) {
                    requestURI.setTransportParam("udp");
                }
                trans = this.dlgcaSipMgr.udpSipProvider.getNewClientTransaction(request);
            }
            return trans;
        }
        catch (TransactionUnavailableException e) {
            log.error(e.toString());
            throw new SipException(e.toString());
        }
        catch (ParseException p) {
            log.error(p.toString());
            throw new SipException(p.toString());
        }
    }

    FromHeader createFromHeader() throws SipException {
        String fromConnectorSipAddr = this.dlgcMediaServer.connectorIP + ":" + this.dlgcMediaServer.connectorPort.toString();
        try {
            SipURI fromUri = this.dlgcaSipMgr.addressFactory.createSipURI("dlgajmc", fromConnectorSipAddr);
            Address fromNameAddress = this.dlgcaSipMgr.addressFactory.createAddress((URI)fromUri);
            fromNameAddress.setDisplayName("dlgajmc");
            FromHeader fromHeader = this.dlgcaSipMgr.headerFactory.createFromHeader(fromNameAddress, this.tag.toString());
            return fromHeader;
        }
        catch (ParseException e) {
            log.error(e.toString());
            throw new SipException(e.toString());
        }
    }

    ToHeader createToHeader(String toUsername, String toXmsSipAddr) throws SipException {
        ToHeader toHeader = null;
        try {
            SipURI toSipUri = this.dlgcaSipMgr.addressFactory.createSipURI(toUsername, toXmsSipAddr);
            Address toNameAddress = this.dlgcaSipMgr.addressFactory.createAddress((URI)toSipUri);
            toNameAddress.setDisplayName("MediaServer");
            toHeader = this.dlgcaSipMgr.headerFactory.createToHeader(toNameAddress, null);
            return toHeader;
        }
        catch (ParseException e) {
            log.error(e.toString());
            throw new SipException(e.toString());
        }
    }

    private void handleInfoByeRequest(DlgcaSipSession session, Request request, String tagID) {
        log.debug("Entering DlgcaSipRcvMgr::handleInfoByeRequest. ");
        Resource<ResourceContainer> jsr309Resource = session.gettagIdRequestTo309Map(tagID);
        log.debug("Exiting DlgcaSipRcvMgr::handleInfoByeRequest ");
    }

    private void handleInfoRequest(DlgcaSipSession session, Request request, String tagID) {
        log.debug("Entering DlgcaSipRcvMgr::handleInfoRequest. ");
        log.debug("Exiting DlgcaSipRcvMgr::handleInfoRequest ");
    }

    private void handleInviteKeepAliveRequest(DlgcaSipSession session, Request request, String tagID) {
        log.debug("Entering DlgcaSipRcvMgr::handleInviteKeepAliveRequest. ");
        log.debug("Exiting DlgcaSipRcvMgr::handleInviteKeepAliveRequest ");
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public Object removeAttribute(String name) {
        return this.attributeMap.remove(name);
    }

    public String getId() {
        return this.sessionID;
    }
}

