/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.asip;

import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipMgr;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipSession;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import java.io.Serializable;
import javax.media.mscontrol.resource.Resource;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcaSipRcvMgr
implements SipListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcaSipRcvMgr.class);
    private DlgcaSipMgr dlgcaSipMgr = null;
    public LISTENER_REGISTRATION_STATUS ListenerRegistrationStatus = LISTENER_REGISTRATION_STATUS.NOT_REGISTERED;

    public DlgcaSipRcvMgr(DlgcaSipMgr mgr) {
        this.dlgcaSipMgr = mgr;
    }

    public void processResponse(ResponseEvent event) {
        log.debug("Entering DlgcaSipRcvMgr::processResponse: event: " + event.toString());
        Response response = event.getResponse();
        log.debug("DlgcaSipRcvMgr::processResponse: event.Response: " + response.toString());
        Dialog dialog = event.getDialog();
        String callId = dialog.getCallId().getCallId();
        log.debug("DlgcaSipRcvMgr::processResponse: event.Response.dialog CallId: " + callId);
        DlgcaSipSession session = this.dlgcaSipMgr.dlgcaSipXmitMgr.getDialogXmitMap(callId);
        Long CSeqNumber = dialog.getLocalSeqNumber();
        Request thisResponseRequest = session.getcseqIdResponseToRequestMapAndDelete(CSeqNumber);
        if (thisResponseRequest.getMethod().compareToIgnoreCase("INVITE") == 0) {
            log.debug("DlgcaSipRcvMgr::processResponse Received and handling INVITE Response ");
            this.handleInviteResponse(session, response, thisResponseRequest);
        } else if (thisResponseRequest.getMethod().compareToIgnoreCase("INFO") == 0) {
            log.debug("DlgcaSipRcvMgr::processResponse Received and handling INFO Response ");
            this.handleInfoResponse(session, response, thisResponseRequest);
        } else if (thisResponseRequest.getMethod().compareToIgnoreCase("BYE") == 0) {
            log.debug("DlgcaSipRcvMgr::processResponse Received and handling BYE Response ");
            this.handleInfoBye(session, response, thisResponseRequest);
        }
        log.debug("Exiting DlgcaSipRcvMgr::processResponse ");
    }

    private void handleInfoBye(DlgcaSipSession session, Response response, Request thisResponseRequest) {
        int status = response.getStatusCode();
        log.debug("DlgcaSipRcvMgr::handleInfoBye: event.Response.status: " + new Integer(status).toString() + " " + response.getReasonPhrase());
    }

    private void handleInfoResponse(DlgcaSipSession session, Response response, Request thisResponseRequest) {
        int status = response.getStatusCode();
        log.debug("DlgcaSipRcvMgr::handleInfoResponse: event.Response.status: " + new Integer(status).toString() + " " + response.getReasonPhrase());
    }

    private void handleInviteResponse(DlgcaSipSession session, Response response, Request thisResponseRequest) {
        int status = response.getStatusCode();
        log.debug("DlgcaSipRcvMgr::handleInviteResponse: event.Response.status: " + new Integer(status).toString() + " " + response.getReasonPhrase());
        if (thisResponseRequest != null) {
            log.debug("handleInviteResponse:: based on previous request: " + thisResponseRequest.toString());
            DlgcXNetworkConnection nc = null;
            if (status == 200) {
                log.error("DlgcaSipRcvMgr::processResponse Received Invite Response 200 OK");
                nc = session.getDialog309Owner();
                log.debug("DlgcaSipRcvMgr::processResponse JSR309 Owner Callback: " + nc.toString());
                byte[] sdp = response.getRawContent();
                if (sdp == null) {
                    log.error("DlgcaSipRcvMgr::processResponse Received Invite 200 but  with XMS NULL SDP... not expected");
                } else {
                    log.error("DlgcaSipRcvMgr::processResponse Received with XMS SDP: " + sdp.toString());
                    nc.processSipInvite(response, session);
                }
            } else if (status == 180) {
                nc = session.getDialog309Owner();
                log.debug("DlgcaSipRcvMgr::processResponseReceive Invite Response: " + nc.toString());
                log.debug("DlgcaSipRcvMgr::processResponse JSR309 Owner Callback: " + response.getReasonPhrase());
            } else if (status >= 400) {
                log.error("DlgcaSipRcvMgr::processResponse Received Invite Response: " + response.getReasonPhrase());
            }
        } else {
            log.error("handleInviteResponse:: Can't process Invite response because its associated REQUEST IS NULL");
        }
    }

    public void processRequest(RequestEvent event) {
        log.debug("Entering DlgcaSipRcvMgr::processRequest: event: " + event.toString());
        Request request = event.getRequest();
        log.debug("DlgcaSipRcvMgr::processRequest: event.Response: " + request.toString());
        Dialog dialog = event.getDialog();
        String callId = dialog.getCallId().getCallId();
        log.debug("DlgcaSipRcvMgr::processRequest: event.Response.dialog CallId: " + callId);
        DlgcaSipSession session = this.dlgcaSipMgr.dlgcaSipXmitMgr.getDialogXmitMap(callId);
        ToHeader toHeader = (ToHeader)request.getHeader("To");
        String tagId = toHeader.getTag();
        if (request.getMethod().compareToIgnoreCase("INVITE") == 0) {
            log.debug("DlgcaSipRcvMgr::processRequest Received and handling INVITE Response ");
            this.handleInviteKeepAliveRequest(session, request, tagId);
        } else if (request.getMethod().compareToIgnoreCase("INFO") == 0) {
            log.debug("DlgcaSipRcvMgr::processRequest Received and handling INFO Response ");
            this.handleInfoRequest(session, request, tagId);
        } else if (request.getMethod().compareToIgnoreCase("BYE") == 0) {
            log.debug("DlgcaSipRcvMgr::processRequest Received and handling BYE Response ");
            this.handleInfoByeRequest(session, request, tagId);
        }
        log.debug("Exiting DlgcaSipRcvMgr::processRequest ");
    }

    private void handleInfoByeRequest(DlgcaSipSession session, Request request, String tagID) {
        log.debug("Entering DlgcaSipRcvMgr::handleInfoByeRequest. ");
        Resource<ResourceContainer> jsr309Resource = session.gettagIdRequestTo309Map(tagID);
        log.debug("Exiting DlgcaSipRcvMgr::handleInfoByeRequest ");
    }

    private void handleInfoRequest(DlgcaSipSession session, Request request, String tagID) {
        log.debug("Entering DlgcaSipRcvMgr::handleInfoRequest. ");
        log.debug("Exiting DlgcaSipRcvMgr::handleInfoRequest ");
    }

    private void handleInviteKeepAliveRequest(DlgcaSipSession session, Request request, String tagID) {
        log.debug("Entering DlgcaSipRcvMgr::handleInviteKeepAliveRequest. ");
        log.debug("Exiting DlgcaSipRcvMgr::handleInviteKeepAliveRequest ");
    }

    public void processTimeout(TimeoutEvent event) {
        log.debug("Entering DlgcaSipRcvMgr::processTimeout: event: " + event.toString());
        log.debug("Exiting DlgcaSipRcvMgr::processTimeout ");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent event) {
        log.debug("Entering DlgcaSipRcvMgr::processTransactionTerminated: event: " + event.toString());
        log.debug("Exiting DlgcaSipRcvMgr::processTransactionTerminated ");
    }

    public LISTENER_REGISTRATION_STATUS register() {
        this.ListenerRegistrationStatus = LISTENER_REGISTRATION_STATUS.REGISTERED;
        return this.ListenerRegistrationStatus;
    }

    public LISTENER_REGISTRATION_STATUS unRegister() {
        this.ListenerRegistrationStatus = LISTENER_REGISTRATION_STATUS.NOT_REGISTERED;
        return this.ListenerRegistrationStatus;
    }

    public void processDialogTerminated(DialogTerminatedEvent event) {
    }

    public void processIOException(IOExceptionEvent event) {
    }

    private void processInviteResponse() {
    }

    private void processInfoResponse() {
    }

    private void processInviteRequest() {
    }

    private void processInfoRequest() {
    }

    public static enum LISTENER_REGISTRATION_STATUS {
        REGISTERED,
        NOT_REGISTERED;

    }
}

