/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.asip;

import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipMgrFactory;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipRcvMgr;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipXmitMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcaSipMgr
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcaSipMgrFactory.class);
    Properties connectorProperties = null;
    SipStack sipStack = null;
    SipFactory sipFactory = null;
    AddressFactory addressFactory = null;
    HeaderFactory headerFactory = null;
    MessageFactory messageFactory = null;
    SipProvider udpSipProvider = null;
    SipProvider tcpSipProvider = null;
    ListeningPoint tcpListeningPoint = null;
    ListeningPoint udpListeningPoint = null;
    static final String STACKNAME = "dlgca309Connector";
    static final String STACKIMPLNAME = "gov.nist";
    public static final String DIALOGIC_SIP_USERNAME = "dlgajmc";
    Hashtable<Integer, DlgcaMediaServer> MediaServerMap = null;
    DlgcaSipXmitMgr dlgcaSipXmitMgr = null;
    DlgcaSipRcvMgr dlgcaSipRcvMgr = null;
    private A_SIP_MGR_RUN_STATUS aSipRunStatus = A_SIP_MGR_RUN_STATUS.STOPPED;

    public DlgcaSipMgr(Properties connectorProp) throws SipException {
        log.debug("Entering DlgcaSipMgr::Ctor without msURI ");
        try {
            this.MediaServerMap = new Hashtable();
            this.loadMediaServerProperties(connectorProp);
            DlgcaMediaServer ms = this.getActiveMediaServer();
            if (ms == null) {
                throw new SipException("NULL DlgcaMediaServer make sure the internal Connector Media Server Representation is loaded correctly");
            }
            this.initSipFactories();
            this.initSipStack(ms);
            this.createListeningPoints(ms);
            this.createSipProviders(ms);
        }
        catch (SipException sipEx) {
            log.error(sipEx.toString());
            throw sipEx;
        }
    }

    public DlgcaSipMgr(String msURI, Properties connectorProp) throws SipException {
        log.debug("Entering DlgcaSipMgr::Ctor Properties with msURI");
        try {
            this.MediaServerMap = new Hashtable();
            this.loadMediaServerProperties(msURI, connectorProp);
            DlgcaMediaServer ms = this.getActiveMediaServer();
            if (ms == null) {
                throw new SipException("NULL DlgcaMediaServer make sure the internal Connector Media Server Representation is loaded correctly");
            }
            this.initSipFactories();
            this.initSipStack(ms);
            this.createListeningPoints(ms);
            this.createSipProviders(ms);
        }
        catch (SipException sipEx) {
            log.error(sipEx.toString());
            throw sipEx;
        }
    }

    private void initSipFactories() throws SipException {
        log.debug("DlgcaSipMgr::initSipFactories:: Entering");
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName(STACKIMPLNAME);
        this.addressFactory = this.sipFactory.createAddressFactory();
        this.headerFactory = this.sipFactory.createHeaderFactory();
        this.messageFactory = this.sipFactory.createMessageFactory();
        log.debug("DlgcaSipMgr::initSipFactories:: Leaving");
    }

    private void initSipStack(DlgcaMediaServer ms) throws SipException {
        log.debug("initSipStack:: Entering");
        Properties prop = new Properties();
        int randomSeed = (int)System.nanoTime() & 0xFF;
        Integer radn = new Random(randomSeed).nextInt();
        String stackName = STACKNAME + radn.toString();
        prop.setProperty("javax.sip.STACK_NAME", stackName);
        log.debug("initSipStack:: STACK_NAME: " + stackName);
        log.debug("initSipStack IP ADDR: " + ms.connectorIP);
        prop.setProperty("javax.sip.IP_ADDRESS", ms.connectorIP);
        prop.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
        prop.setProperty("gov.nist.javax.sip.DEBUG_LOG", "dlg309StandaloneDebug.txt");
        prop.setProperty("gov.nist.javax.sip.SERVER_LOG", "dlg309StandaloneLog.txt");
        this.sipStack = this.sipFactory.createSipStack(prop);
        if (this.sipStack != null) {
            Integer rcvThreadQueSize = DlgcInstrumentPropertyMgr.connectorSipStandaloneRcvThreadIVal;
            log.debug("setting sipStack thread receive queue size: " + rcvThreadQueSize.toString());
            ((SIPTransactionStack)this.sipStack).setThreadPoolSize(rcvThreadQueSize.intValue());
        }
        log.debug("initSipStack:: Leaving");
    }

    private void createListeningPoints(DlgcaMediaServer ms) throws SipException {
        try {
            log.debug("createListeningPoints:: ipAddress: " + ms.connectorIP + " Port: " + ms.connectorPort.toString());
            if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.TCP_UDP) {
                log.debug("createListeningPoints:: Creating two Listening Points one for TCP and the other for UDP as directed by the connector property file");
                this.udpListeningPoint = this.sipStack.createListeningPoint(ms.connectorIP, ms.connectorPort.intValue(), "udp");
                this.tcpListeningPoint = this.sipStack.createListeningPoint(ms.connectorIP, ms.connectorPort.intValue(), "tcp");
            } else if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.UDP) {
                log.debug("createListeningPoints:: Creating one Listening Points one for UDP as directed by the connector property file");
                this.udpListeningPoint = this.sipStack.createListeningPoint(ms.connectorIP, ms.connectorPort.intValue(), "udp");
            } else {
                log.debug("createListeningPoints:: Creating one Listening Points one for TCP as directed by the connector property file");
                this.tcpListeningPoint = this.sipStack.createListeningPoint(ms.connectorIP, ms.connectorPort.intValue(), "tcp");
            }
        }
        catch (InvalidArgumentException e) {
            log.error(e.toString());
            throw new SipException("Invalid LIsteningPoint IP-PORT-TRANSPORT passed to sipStack.createListeningPoint method");
        }
    }

    private void createSipProviders(DlgcaMediaServer ms) throws SipException {
        log.debug("createSipProviders:: ipAddress: " + ms.connectorIP + " Port: " + ms.connectorPort.toString());
        if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.UDP) {
            log.debug("createSipProviders:: creatingProvider for transport : UDP Only");
            this.udpSipProvider = this.sipStack.createSipProvider(this.udpListeningPoint);
        } else if (DlgcInstrumentPropertyMgr.connectorSipStandloneTransportEVal == DlgcInstrumentPropertyMgr.ECONNECTOR_SIP_STANDALONE_TRANSPORT.UDP) {
            log.debug("createSipProviders:: creatingProvider for transport : UDP Only");
            this.tcpSipProvider = this.sipStack.createSipProvider(this.tcpListeningPoint);
        } else {
            log.debug("createSipProviders:: creatingProvider for transport : UDP Only");
            this.udpSipProvider = this.sipStack.createSipProvider(this.udpListeningPoint);
            log.debug("createSipProviders:: creatingProvider for transport : UDP Only");
            this.tcpSipProvider = this.sipStack.createSipProvider(this.tcpListeningPoint);
        }
    }

    public DlgcaSipXmitMgr getDlgcaSipXmitMgr() {
        if (this.dlgcaSipXmitMgr == null) {
            this.dlgcaSipXmitMgr = new DlgcaSipXmitMgr(this);
            return this.dlgcaSipXmitMgr;
        }
        return this.dlgcaSipXmitMgr;
    }

    public DlgcaSipRcvMgr getDlgcaSipRcvMgr() {
        if (this.dlgcaSipRcvMgr == null) {
            this.dlgcaSipRcvMgr = new DlgcaSipRcvMgr(this);
            return this.dlgcaSipRcvMgr;
        }
        return this.dlgcaSipRcvMgr;
    }

    DlgcaMediaServer getActiveMediaServer() {
        return this.MediaServerMap.get(1);
    }

    public A_SIP_MGR_RUN_STATUS getaSipRunStatus() {
        return this.aSipRunStatus;
    }

    public void start() {
        this.aSipRunStatus = A_SIP_MGR_RUN_STATUS.RUNNING;
    }

    public void stop() {
        this.aSipRunStatus = A_SIP_MGR_RUN_STATUS.STOPPED;
    }

    private void loadMediaServerProperties(Properties properties) {
        log.debug("Entering loadMediaServerProperties");
        String connectorIP = DlgcInstrumentPropertyMgr.connectorSipIPSVal;
        Integer connectorPort = DlgcInstrumentPropertyMgr.connectorSipPortIVal;
        int mediaServerCount = 1;
        for (int i = 1; i <= mediaServerCount; ++i) {
            String msIpString = "mediaserver." + i + ".sip.address";
            String msPortString = "mediaserver." + i + ".sip.port";
            String msIp = properties.getProperty(msIpString);
            if (msIp != null) {
                String toIP = msIp;
                Integer msPort = 5060;
                String msPortValue = properties.getProperty(msPortString);
                if (msPortValue != null) {
                    msPort = (int)Integer.valueOf(msPortValue);
                } else {
                    log.debug("Media Server Port not defined in property file...SIP port is defaulted to 5060");
                }
                DlgcaMediaServer ms = new DlgcaMediaServer(1, msIp, msPort, connectorIP, connectorPort, true, true);
                log.debug(">>>>>>>>>> DlgcMediaServer - Monitoring Media Server: " + msIp.toString() + " :" + msPort.toString());
                this.MediaServerMap.put(1, ms);
                continue;
            }
            log.error("Cant create mediaServer object since the Media Server IP Address found in Property file IS NULL");
        }
    }

    private void loadMediaServerProperties(String msURI, Properties properties) {
        log.debug("Entering loadMediaServerProperties");
        String connectorIP = DlgcInstrumentPropertyMgr.connectorSipIPSVal;
        Integer connectorPort = DlgcInstrumentPropertyMgr.connectorSipPortIVal;
        DlgcaMediaServer ms = new DlgcaMediaServer(msURI, connectorIP, connectorPort, true, true);
        this.MediaServerMap.put(1, ms);
    }

    public static enum A_SIP_MGR_RUN_STATUS {
        STOPPED,
        RUNNING;

    }
}

