/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.asip;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DlgcaMediaServer
implements Serializable {
    String userName;
    String connectorIP = null;
    Integer iMediaServerPort = null;
    String sMediaServerIP = null;
    boolean msStatus = false;
    Integer connectorPort = null;
    String mediaServerLookupName = null;
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcaMediaServer.class);
    private int groupLenFound;
    protected boolean validUserNamePattern = false;
    private static final String IP_ADDR_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String URI_PATTERN = "sip:([\\w=]+)\\@(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,7})";
    protected String msmlValUsername = null;

    public boolean isValidUserNamePattern() {
        return this.validUserNamePattern;
    }

    public DlgcaMediaServer(int index, String msIP, Integer msPort, String connectorIP, Integer connectorPort, boolean alive, boolean active) {
        log.debug("DlgcaMediaServer CTOR for STANDALONE MODE without msURI");
        int serverIndex = index;
        this.msStatus = true;
        this.mediaServerLookupName = new String("DlgcaMediaServer-") + new Integer(serverIndex);
        this.sMediaServerIP = msIP;
        this.iMediaServerPort = msPort;
        this.connectorIP = connectorIP;
        this.connectorPort = connectorPort;
        this.userName = null;
    }

    public DlgcaMediaServer(String msURI, String connectorIP, Integer connectorPort, boolean alive, boolean active) {
        log.debug("DlgcaMediaServer CTOR for STANDALONE MODE WITH msURI");
        int serverIndex = 1;
        this.msStatus = true;
        this.mediaServerLookupName = new String("DlgcaMediaServer-") + new Integer(serverIndex);
        this.processMediaServerUri(msURI);
        this.connectorIP = connectorIP;
        this.connectorPort = connectorPort;
        this.userName = null;
    }

    public void processMediaServerUri(String mediaServerUri) {
        log.debug("processMediaServerUri CTOR supporting MEDIA_SERVE_URI: " + mediaServerUri);
        Pattern testPattern = Pattern.compile(URI_PATTERN);
        Matcher testMatcher = testPattern.matcher(mediaServerUri);
        boolean USERNAME_GROUP = true;
        int IP_GROUP = 2;
        int PORT_GROUP = 3;
        int i = 0;
        block0: while (testMatcher.find()) {
            this.groupLenFound = testMatcher.groupCount();
            if (this.groupLenFound != 0) {
                log.debug("processMediaServerUri::regex group: " + testMatcher.group().trim());
                log.debug("processMediaServerUri::regex groupLenFound " + new Integer(this.groupLenFound).toString());
            }
            for (i = 1; i <= this.groupLenFound; ++i) {
                String groupValue = testMatcher.group(i);
                if (groupValue != null) {
                    log.debug("processMediaServerUri::regex group(" + new Integer(i).toString() + ") = " + groupValue);
                    if (i == 1) {
                        this.userName = groupValue;
                        if (this.userName.contains("msml=")) {
                            log.debug("processMediaServerUri Valid Username contains msml= as username");
                            this.validUserNamePattern = true;
                            continue;
                        }
                        log.error("processMediaServerUri Invalid Username does not contain msml= as username");
                        this.validUserNamePattern = false;
                        continue;
                    }
                    if (i == 2) {
                        this.sMediaServerIP = groupValue;
                        continue;
                    }
                    if (i != 3) continue;
                    this.iMediaServerPort = (int)new Integer(groupValue);
                    continue;
                }
                log.debug("processMediaServerUri::regex group(" + new Integer(i).toString() + ") = NULL");
                continue block0;
            }
        }
        if (this.groupLenFound != 3) {
            log.debug("processMediaServerUri::regex Invalid MEDIA_SERVER_URI: Major error..aborting");
        } else {
            this.msmlValUsername = this.userName;
            log.debug("processMediaServerUri:: Setting msmlVal= " + this.msmlValUsername);
        }
    }

    public String getmsmlValUsername() {
        return this.msmlValUsername;
    }

    public void setmsmlValUsername(String msmlVal) {
        this.msmlValUsername = msmlVal;
    }

    public boolean is_MS_URI_DEFINED() {
        return this.groupLenFound == 3;
    }
}

