/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSessionProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.asip.DlgcaSipMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import commonj.work.Work;
import commonj.work.WorkItem;
import commonj.work.WorkManager;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.enterprise.concurrent.ContextService;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaConfigException;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.naming.InitialContext;
import javax.servlet.sip.SipApplicationSession;
import org.mobicents.javax.servlet.sip.SipFactoryExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXMsControlFactory
extends DlgcMsControlFactory {
    private static final long serialVersionUID = 1L;
    DlgcaSipMgr dlgcaSipMgr = null;
    private static Logger log = LoggerFactory.getLogger(DlgcXMsControlFactory.class);

    public DlgcXMsControlFactory(Properties inProperties) {
        super(inProperties);
    }

    public DlgcXMsControlFactory(Properties inProperties, String mediaServerUri) {
        super(inProperties, mediaServerUri);
    }

    public DlgcXMsControlFactory(Properties inProperties, boolean useDynamicConfig) {
        super(inProperties, useDynamicConfig);
    }

    @Override
    public MediaSession createMediaSession() throws MsControlException {
        DlgcMediaSessionProxy mediaSessionProxy = null;
        DlgcXMediaSession mediaSession = new DlgcXMediaSession(this);
        mediaSessionProxy = this.createMediaSessionUsingServletMode(mediaSession);
        return mediaSessionProxy;
    }

    public DlgcMediaSessionProxy createMediaSessionUsingServletMode(DlgcXMediaSession mediaSession) throws MsControlException {
        try {
            CreateMediaSessionAction cms = new CreateMediaSessionAction(mediaSession);
            cms.run();
            if (mediaSession.getProxyId() == null) {
                log.debug("Major Issue: XMS MSControlFactory createMediaSessionUsingServletMode - returned sasId is null ... Bummer...");
            } else {
                log.debug("XMS MSControlFactory - returned successful sasId is " + mediaSession.getProxyId());
            }
            log.debug("Enter XMS MSControlFactory::createMediaSessionUsingServletMode thread finished creating appSession");
        }
        catch (Exception e) {
            log.error("createMediaSessionUsingServletMode XMS Failed to schedule work", (Throwable)e);
            throw new MsControlException("XMS Failed to schedule work", (Throwable)e);
        }
        if (mediaSession.proxyId == null) {
            log.debug("Enter XMS MSControlFactory::createMediaSessionUsingServletMode the mediaSession sasId is null ... bummer");
        } else {
            log.debug("Enter XMS MSControlFactory::createMediaSessionUsingServletMode the mediaSession sasId = " + mediaSession.proxyId);
        }
        DlgcMediaSessionProxy msProxy = mediaSession.getProxy();
        log.debug("XMSControlFactory::createMediaSessionUsingServletMode the MSTYPE is XMS");
        if (!this.isTCKEnabled()) {
            msProxy.setAttribute("MSTYPE", "XMS");
        }
        return msProxy;
    }

    public DlgcMediaSessionProxy createMediaSessionUsingStandaloneMode(DlgcXMediaSession mediaSession) throws MsControlException {
        DlgcMediaSessionProxy msProxy = mediaSession.getProxy();
        msProxy.setStandaloneObject(mediaSession);
        log.debug("XMSControlFactory::createMediaSessionUsingStandaloneMode the MSTYPE is XMS");
        mediaSession.setProxyId("msStandalone");
        if (!this.isTCKEnabled()) {
            msProxy.setAttribute("MSTYPE", "XMS");
        }
        return msProxy;
    }

    protected boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }

    @Override
    public MediaConfig getMediaConfig(Configuration<?> cfg) throws MediaConfigException {
        return DlgcXMediaConfig.getContainerSupportedConfiguration(cfg);
    }

    class CreateMediaSessionAction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DlgcMediaSession mMediaSession;

        public CreateMediaSessionAction(DlgcMediaSession mediaSession) {
            this.mMediaSession = mediaSession;
        }

        public void run() {
            String platform = DlgcSipServlet.getASPlatform();
            log.debug("DlgcMediaSession::createSASForListenerSyncApi():  platform: " + platform);
            if (platform.equalsIgnoreCase("TELESTAX") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("DlgcXMsControlFactory::createMediaSession::run():: calling createMediaSessionMobicents - creating MOBICENTS MEDIA SESSION...Managing SAS OUTSIDE the container managed scope.");
                this.createMediaSessionTelScaleSyncApi();
            } else if (platform.equalsIgnoreCase("OCCAS5") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("DlgcXMsControlFactory::createMediaSession::run():: calling createMediaSessionForOccas - creating OCCAS MEDIA SESSION...Managing SAS OUTSIDE the container managed scope.");
                this.createMediaSessionForOccas();
            } else if (platform.equalsIgnoreCase("OCCAS7") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("DlgcXMsControlFactory::createMediaSession::run():: calling createMediaSessionForOccas - creating OCCAS MEDIA SESSION...Managing SAS OUTSIDE the container managed scope.");
                this.createMediaSessionForOccas7();
            } else if (platform.equalsIgnoreCase("IBM") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("DlgcXMsControlFactory::createMediaSession::run():: calling createMediaSessionForLibertyIBM - creating IBM MEDIA SESSION...Managing SAS OUTSIDE the container managed scope.");
                this.createMediaSessionForLibertyIBM();
            } else {
                log.debug("DlgcXMsControlFactory::createMediaSession::run() - creating MEDIA SESSION - THE REGULAR WAY...");
                this.createMediaSessionGeneral();
            }
        }

        protected void createMediaSessionTelScaleSyncApi() {
            try {
                log.debug("***XMsControlFactory::createMediaSessionTelScaleSyncApi***");
                SipFactoryExt f = (SipFactoryExt)DlgcSipServlet.getSipFactory();
                SipApplicationSession appSession = f.createApplicationSession(false);
                String sasId = appSession.getId();
                log.debug("DlgcMsControlFactory:createMediaSessionTelScaleSyncApi::CreateMediaSessionAction(response): SASID: " + sasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
                log.debug("XMsControlFactory::createMediaSessionTelScaleSyncApi run thread created sasId = " + sasId);
                this.mMediaSession.setProxyId(sasId);
                appSession.setAttribute(this.mMediaSession.getMediaObject(), (Object)this.mMediaSession);
            }
            catch (Exception e) {
                log.error("Failed to create Media Session", (Throwable)e);
            }
        }

        protected void createMediaSessionGeneral() {
            try {
                log.debug("***XMsControlFactory::createMediaSessionGeneral***");
                SipApplicationSession appSession = DlgcSipServlet.getSipFactory().createApplicationSession();
                String sasId = appSession.getId();
                log.debug("DlgcMsControlFactory:createMediaSessionGeneral::CreateMediaSessionAction(response): SASID: " + sasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
                log.debug("XMsControlFactory::createMediaSessionGeneral run thread created sasId = " + sasId);
                this.mMediaSession.setProxyId(sasId);
                appSession.setAttribute(this.mMediaSession.getMediaObject(), (Object)this.mMediaSession);
            }
            catch (Exception e) {
                log.error("Failed to create Media Session", (Throwable)e);
            }
        }

        protected void createMediaSessionForOccas() {
            try {
                log.debug("Entering DlgcXMsControlFactory::createMediaSessionForOccas");
                WorkManager aWorkMgr = DlgcSipServlet.wManager;
                WorkItem wItem = aWorkMgr.schedule((Work)new OccasMediaSessionWork());
                if (wItem == null) {
                    log.error("DlgcXMsControlFactory::createMediaSessionForOccas: error creating SAS using Work Manager.. Work Item is Null");
                }
                log.debug("DlgcXMsControlFactory::createMediaSessionForOccas: waiting for thread to finish creating the SAS");
                aWorkMgr.waitForAll(Arrays.asList(wItem), 5000L);
                log.debug("DlgcXMsControlFactory::createMediaSessionForOccas: Returning from waiting for thread to finish creating the SAS");
            }
            catch (Exception e) {
                log.error("Failed to create Media Session", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void createMediaSessionForOccas7() {
            try {
                Future f;
                log.debug("Entering DlgcXMsControlFactory::createMediaSessionForOccas7");
                InitialContext context = new InitialContext();
                class Occas7MediaSessionTask
                implements Callable,
                Serializable {
                    private static final long serialVersionUID = 1L;

                    Occas7MediaSessionTask() {
                    }

                    public Object call() throws Exception {
                        log.debug("Entering createMediaSessionForOccas7::occas7MediaSessionTask in work thread creating SAS");
                        CreateMediaSessionAction.this.createMediaSessionGeneral();
                        log.debug("Leaving createMediaSessionForOccas7::occas7MediaSessionTask in work thread creating SAS");
                        return null;
                    }
                }
                Occas7MediaSessionTask createOccas7Task = new Occas7MediaSessionTask();
                ContextService cs = (ContextService)context.lookup("java:comp/SipContextService");
                HashMap<String, String> contextProperties = new HashMap<String, String>();
                contextProperties.put("javax.servlet.sip.ApplicationSession.create", "");
                if (cs == null) {
                    log.error("cs is null");
                }
                Callable cbTask = (Callable)cs.createContextualProxy((Object)createOccas7Task, contextProperties, Callable.class);
                ManagedExecutorService executor = (ManagedExecutorService)context.lookup("java:comp/ManagedSipExecutorService");
                if (executor == null) {
                    log.error("executor is null");
                }
                log.debug("Starting MediaSession Create SAS Thread");
                Future future = f = executor.submit(cbTask);
                synchronized (future) {
                    f.wait();
                }
                log.debug("Returned from MediaSession Create SAS Thread");
                context.close();
            }
            catch (Exception e) {
                log.error("createMediaSessionForOccas7 - Failed to create Media Session", (Throwable)e);
            }
        }

        protected void createMediaSessionForLibertyIBM() {
            try {
                log.debug("Entering DlgcXMsControlFactory::createMediaSessionForLibertyIBM");
                this.createMediaSessionGeneral();
            }
            catch (Exception e) {
                log.error("createMediaSessionForLibertyIBM - Failed to create Media Session", (Throwable)e);
            }
        }

        private class OccasMediaSessionWork
        implements Work {
            private OccasMediaSessionWork() {
            }

            public boolean isDaemon() {
                return false;
            }

            public void release() {
            }

            public void run() {
                log.debug("Entering DlgcXMsControlFactory::OccasMediaSessionWork in work thread creating SAS");
                CreateMediaSessionAction.this.createMediaSessionGeneral();
                log.debug("Leaving DlgcXMsControlFactory::OccasMediaSessionWork in work thread creating SAS");
            }
        }
    }
}

