/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.WrongStateException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXMediaSession
extends DlgcMediaSession {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcXMediaSession.class);
    final String CPA_VALUE_ATTR = "CPA_DATA";

    public DlgcXMediaSession() {
    }

    protected DlgcXMediaSession(MsControlFactory factory) {
        super(factory);
    }

    @Override
    public MediaGroup createMediaGroup(Configuration<MediaGroup> preConfig, Parameters params) throws MsControlException {
        MediaConfig predefConf = this.msFactory.getMediaConfig(preConfig);
        return this.createMediaGroup(predefConf, params);
    }

    @Override
    public MediaGroup createMediaGroup(MediaConfig config, Parameters params) throws MsControlException {
        DlgcXMediaGroup mg = null;
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        if (null != params && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            if (!this.mediaObjectIdMap.isEmpty() && this.mediaObjectIdMap.containsKey(params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A mediagroup exist with the same mediaobject id");
            }
            if (this.checkInvalidMediaobjectIdSyntax((String)params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A mediagroup mediaobject id can not start with special character");
            }
        }
        if (config == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        mg = new DlgcXMediaGroup(config, this, params);
        this.addMediaObject(mg);
        this.mediaObjectByProxyIdMap.put(mg.getProxyId(), mg);
        if (null != params && !params.isEmpty() && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            this.mediaObjectIdMap.put((String)params.get((Object)MediaObject.MEDIAOBJECT_ID), "MediaGroup");
        }
        return mg;
    }

    @Override
    public MediaMixer createMediaMixer(MediaConfig config, Parameters params) throws MsControlException {
        DlgcXMediaMixer mx = null;
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        if (null != params && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            if (!this.mediaObjectIdMap.isEmpty() && this.mediaObjectIdMap.containsKey(params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A midea mixer exist with the same mediaobject id");
            }
            if (this.checkInvalidMediaobjectIdSyntax((String)params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A midea mixer mediaobject id can not start with special character");
            }
        }
        if (config == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        mx = new DlgcXMediaMixer(config, (MediaSession)this, params);
        this.addMediaObject(mx);
        this.mediaObjectByProxyIdMap.put(mx.getProxyId(), mx);
        if (null != params && !params.isEmpty() && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            this.mediaObjectIdMap.put((String)params.get((Object)MediaObject.MEDIAOBJECT_ID), "MediaMixer");
        }
        return mx;
    }

    @Override
    public NetworkConnection createNetworkConnection(MediaConfig config, Parameters params) throws MsControlException {
        DlgcXNetworkConnection nc = null;
        if (!DlgcInstrumentPropertyMgr.bMultipleNetworkConnection) {
            Iterator<MediaObject> it = this.getMediaObjects();
            while (it.hasNext()) {
                MediaObject mobj = it.next();
                if (!(mobj instanceof NetworkConnection)) continue;
                String exMsg = "Error: The Dialogic 309 Connector only allows one Network Connection per Media Session...A Network Connection was previously allocated.";
                log.error("DlgcXMediaSession::createNetworkConnection: Exception: " + exMsg);
                throw new MsControlException(exMsg);
            }
        }
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released msFactory.SetMediaSessionURI(this.getURI());");
        }
        if (null != params && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            if (!this.mediaObjectIdMap.isEmpty() && this.mediaObjectIdMap.containsKey(params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A network connection exist with the same mediaobject id");
            }
            if (this.checkInvalidMediaobjectIdSyntax((String)params.get((Object)MediaObject.MEDIAOBJECT_ID))) {
                throw new MsControlException("A network connection mediaobject id can not start with special character");
            }
        }
        if (config == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        nc = new DlgcXNetworkConnection(config, this, params);
        this.addMediaObject(nc);
        this.mediaObjectByProxyIdMap.put(nc.getProxyId(), nc);
        if (null != params && !params.isEmpty() && null != params.get((Object)MediaObject.MEDIAOBJECT_ID)) {
            this.mediaObjectIdMap.put((String)params.get((Object)MediaObject.MEDIAOBJECT_ID), "NetworkConnection");
        }
        return nc;
    }

    @Override
    public void release() {
        String mID = this.mediaObjectID;
        log.info("JSR309 API REQUEST:MediaSession release(): MediaSession MEDIA OBJID: " + mID);
        this.released = true;
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() using synchronous approach for ID : " + mID);
            Vector<Integer> networkConnectionIndexList = new Vector<Integer>();
            Vector<Integer> mixerIndexList = new Vector<Integer>();
            Vector<Integer> mediaGroupIndexList = new Vector<Integer>();
            int listTotalSize = this.mediaObjectList.size();
            log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() number of object contained by this Object: " + mID + " = " + new Integer(listTotalSize).toString());
            DlgcJoinableContainer container = null;
            for (int i = 0; i < listTotalSize; ++i) {
                container = (DlgcJoinableContainer)this.mediaObjectList.get(i);
                if (container instanceof NetworkConnection) {
                    networkConnectionIndexList.add(i);
                    log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() found network Object with MOID: " + container.getMediaObject());
                    continue;
                }
                if (container instanceof MediaMixer) {
                    mixerIndexList.add(i);
                    DlgcXMediaMixer mx = (DlgcXMediaMixer)container;
                    log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() found Media Mixer Object with MOID: " + container.getMediaObject());
                    mx.release();
                    continue;
                }
                if (container instanceof MediaGroup) {
                    log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() found Media Group Object with MOID: " + container.getMediaObject());
                    mediaGroupIndexList.add(i);
                    continue;
                }
                log.debug("DlgcXMediaSession::release() not sure what type of container is this");
            }
            int ncListSize = networkConnectionIndexList.size();
            if (ncListSize == 0) {
                this.getMonitor().setNetworkConnectorCount(1);
                this.getMonitor().notifyRequestCompleted(true, "Media Session released");
            } else {
                this.getMonitor().setNetworkConnectorCount(ncListSize);
                for (int i = 0; i < ncListSize; ++i) {
                    int index = (Integer)networkConnectionIndexList.get(i);
                    DlgcXNetworkConnection nc = (DlgcXNetworkConnection)this.mediaObjectList.get(index);
                    log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() calling release method on network connection with  MOID " + nc.getMediaObject());
                    nc.release();
                }
            }
        } else {
            log.debug("SYNC_2_ASYNC DlgcXMediaSession::release() using asynchronous approach for ID : " + mID);
            super.release();
        }
        log.debug("Leaving DlgcXMediaSession::release() for ID : " + mID);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        log.debug("<====== SERIALIZATION  DlgcXMediaSession::MediaSession: writeObject()");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        log.debug("=====> DE-SERIALIZATION DlgcXMediaSession::MediaSession: readObj() ");
    }

    private boolean checkInvalidMediaobjectIdSyntax(String mediaobjectId) {
        String s = mediaobjectId.substring(0, 1);
        if (Character.isWhitespace(s.charAt(0))) {
            return true;
        }
        return s == null ? false : s.matches("[^A-Za-z0-9]");
    }

    public void setCPAValue(String cpaValue) {
        log.debug("DlgcXMediaSession setCPAValue: " + cpaValue);
        this.setAttribute("CPA_DATA", cpaValue);
    }

    protected String getCPAValue() {
        String cpaVal = (String)this.getAttribute("CPA_DATA");
        return cpaVal;
    }
}

