/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSync2AsyncMonitor
implements Serializable {
    private TYPE_OF_EXCEPTIONS exType = TYPE_OF_EXCEPTIONS.MSCONTROL_EXCEPTION;
    private int WAIT_TIMEOUT = 5;
    private static final long serialVersionUID = 1L;
    private boolean operationCompleted = false;
    private String sStatus = null;
    private boolean bStatus = false;
    private final transient Lock lock = new ReentrantLock();
    private transient Condition operationCompletedCondition = this.lock.newCondition();
    private String whyAndWhat;
    private int ncCount = 1;
    private E_CONTROL_LEG_LOCK_REASONS controlConfLockReason = E_CONTROL_LEG_LOCK_REASONS.NONE;
    private static Logger log = LoggerFactory.getLogger(DlgcSync2AsyncMonitor.class);

    public DlgcSync2AsyncMonitor(String whyWhat) {
        this.exType = TYPE_OF_EXCEPTIONS.MSCONTROL_EXCEPTION;
        this.WAIT_TIMEOUT = DlgcInstrumentPropertyMgr.MonitorlockWaitTimeOut;
        log.debug("DlgcSync2AsyncMonitor CTOR: wait timeout set to: (sec): " + this.WAIT_TIMEOUT);
        this.whyAndWhat = whyWhat == null ? "Not set by caller... unknow" : whyWhat;
        this.controlConfLockReason = E_CONTROL_LEG_LOCK_REASONS.NONE;
    }

    public E_CONTROL_LEG_LOCK_REASONS getLockReason() {
        return this.controlConfLockReason;
    }

    public void doLock(E_CONTROL_LEG_LOCK_REASONS reason) {
        log.debug("doLock: lockReason: " + reason.toString());
        this.lock.lock();
        this.controlConfLockReason = reason;
    }

    public void doUnlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRequestCompletion() {
        log.debug("SYNC_2_ASYNC DlgcSync2AsyncMonitor::waitForRequestCompletion:: Entering");
        this.lock.lock();
        try {
            while (!this.operationCompleted) {
                this.operationCompletedCondition.await(this.WAIT_TIMEOUT, TimeUnit.SECONDS);
                if (this.operationCompleted) continue;
                this.sStatus = "Error Timeout Error";
                log.error("SYNC_2_ASYNC DlgcSync2AsyncMonitor::waitForRequestCompletion():: test - out of wait with status: " + this.sStatus + " Executing What: " + this.whyAndWhat);
                break;
            }
        }
        catch (InterruptedException e) {
            log.error("SYNC_2_ASYNC DlgcSync2AsyncMonitor::waitForRequestCompletion Exception: " + e.toString() + " Executing What: " + this.whyAndWhat);
            this.sStatus = e.toString();
            this.bStatus = false;
        }
        finally {
            this.lock.unlock();
        }
        return this.bStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRequestCompletionNoLock() {
        log.debug("Entering DlgcSync2AsyncMonitor::waitForRequestCompletionNoLock::  The lockReason: " + this.controlConfLockReason.toString());
        try {
            while (!this.operationCompleted) {
                this.operationCompletedCondition.await(this.WAIT_TIMEOUT, TimeUnit.SECONDS);
                if (this.operationCompleted) continue;
                this.sStatus = "Error Timeout Error";
                log.error("SYNC_2_ASYNC DlgcSync2AsyncMonitor::waitForRequestCompletionNoLock():: test - out of wait with status: " + this.sStatus + " Executing What: " + this.whyAndWhat);
                break;
            }
        }
        catch (InterruptedException e) {
            log.error("SYNC_2_ASYNC DlgcSync2AsyncMonitor::waitForRequestCompletionNoLock Exception: " + e.toString() + " Executing What: " + this.whyAndWhat);
            this.sStatus = e.toString();
            this.bStatus = false;
        }
        finally {
            this.lock.unlock();
        }
        return this.bStatus;
    }

    public void setExceptionType(TYPE_OF_EXCEPTIONS tex) {
        this.exType = tex;
    }

    public TYPE_OF_EXCEPTIONS getExceptionType() {
        return this.exType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRequestCompleted(boolean bs, String ss) {
        log.debug("SYNC_2_ASYNC DlgcSync2AsyncMonitor::notifyRequestCompleted Entering");
        this.lock.lock();
        log.debug("SYNC_2_ASYNC DlgcSync2AsyncMonitor::notifyRequestCompleted ncCount: " + this.ncCount);
        if (this.ncCount > 1) {
            --this.ncCount;
            this.lock.unlock();
        } else {
            try {
                this.bStatus = bs;
                this.sStatus = ss;
                this.operationCompleted = true;
                log.debug("SYNC_2_ASYNC DlgcSync2AsyncMonitor::notifyRequestCompleted:: " + this.whyAndWhat);
                this.operationCompletedCondition.signal();
                log.debug("SYNC_2_ASYNC DlgcSync2AsyncMonitor::notifyRequestCompleted:: completed notify() with status: " + this.sStatus);
            }
            finally {
                this.lock.unlock();
            }
        }
        log.debug("SYNC_2_ASYNC DlgcSync2AsyncMonitor::notifyRequestCompleted Exiting");
    }

    public boolean getStatus() {
        return this.bStatus;
    }

    public String getStatusString() {
        return this.sStatus;
    }

    public void setNetworkConnectorCount(int ncListSize) {
        this.ncCount = ncListSize;
    }

    public static enum E_CONTROL_LEG_LOCK_REASONS {
        NONE,
        DESTROY_CONF,
        LAYOUT_CONF,
        RECORD_CONF,
        PLAY_CONF;

    }

    public static enum TYPE_OF_EXCEPTIONS {
        MSCONTROL_EXCEPTION,
        UNSUPPORTED_EXCEPTION,
        JOIN_EXCEPTION;

    }
}

