/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameter;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSupportedFeatures;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroupConfig;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapter;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerAdapterConfig;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMixerConfig;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnectionConfig;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.SupportedFeatures;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSFMgr {
    private static final Map<Class<?>, DlgcParameters> supportedParameters = new Hashtable();
    private static final Map<Class<?>, DlgcParameters> cachedDefaultParameters = new Hashtable();
    private static final Map<Class<?>, DlgcSupportedFeatures> supportedFeatures = new Hashtable();
    private static Logger log = LoggerFactory.getLogger(DlgcSFMgr.class);

    private DlgcSFMgr() {
    }

    public static SupportedFeatures getConnectorSupportedFeatures() throws MsControlException {
        DlgcSupportedFeatures sf = new DlgcSupportedFeatures();
        DlgcSFMgr.getSupportedFeatureParameters(sf);
        DlgcSFMgr.getSupportedFeatureActions(sf);
        DlgcSFMgr.getSupportedFeatureEventTypes(sf);
        DlgcSFMgr.getSupportedFeatureQualifier(sf);
        DlgcSFMgr.getSupportedFeatureTrigger(sf);
        DlgcSFMgr.getSupportedFeatureValue(sf);
        return sf;
    }

    public static void getSupportedFeatureParameters(DlgcSupportedFeatures sf) throws MsControlException {
        sf.setSfParameters(new HashSet<Parameter>(DlgcSFMgr.getSupportedFeatureParameters(DlgcMediaGroupConfig.class)));
        sf.setSfParameters(new HashSet<Parameter>(DlgcSFMgr.getSupportedFeatureParameters(DlgcNetworkConnectionConfig.class)));
        sf.setSfParameters(new HashSet<Parameter>(DlgcSFMgr.getSupportedFeatureParameters(DlgcMixerConfig.class)));
        sf.setSfParameters(new HashSet<Parameter>(DlgcSFMgr.getSupportedFeatureParameters(DlgcMixerAdapterConfig.class)));
    }

    public static Set<Parameter> getSupportedFeatureParameters(Class<?> aClass) throws MsControlException {
        return supportedFeatures.get(aClass).getSupportedParameters();
    }

    public static void getSupportedFeatureActions(DlgcSupportedFeatures sf) throws MsControlException {
        sf.setSfActions(new HashSet<Action>(DlgcSFMgr.getSupportedFeatureActions(DlgcMediaGroupConfig.class)));
        sf.setSfActions(new HashSet<Action>(DlgcSFMgr.getSupportedFeatureActions(DlgcNetworkConnectionConfig.class)));
        sf.setSfActions(new HashSet<Action>(DlgcSFMgr.getSupportedFeatureActions(DlgcMixerConfig.class)));
        sf.setSfActions(new HashSet<Action>(DlgcSFMgr.getSupportedFeatureActions(DlgcMixerAdapterConfig.class)));
    }

    public static Set<Action> getSupportedFeatureActions(Class<?> aClass) throws MsControlException {
        return supportedFeatures.get(aClass).getSupportedActions();
    }

    public static void getSupportedFeatureEventTypes(DlgcSupportedFeatures sf) throws MsControlException {
        sf.setSfEventTypes(new HashSet<EventType>(DlgcSFMgr.getSupportedFeatureEventTypes(DlgcMediaGroupConfig.class)));
        sf.setSfEventTypes(new HashSet<EventType>(DlgcSFMgr.getSupportedFeatureEventTypes(DlgcNetworkConnectionConfig.class)));
        sf.setSfEventTypes(new HashSet<EventType>(DlgcSFMgr.getSupportedFeatureEventTypes(DlgcMixerConfig.class)));
        sf.setSfEventTypes(new HashSet<EventType>(DlgcSFMgr.getSupportedFeatureEventTypes(DlgcMixerAdapterConfig.class)));
    }

    public static Set<EventType> getSupportedFeatureEventTypes(Class<?> aClass) throws MsControlException {
        return supportedFeatures.get(aClass).getSupportedEventTypes();
    }

    public static void getSupportedFeatureQualifier(DlgcSupportedFeatures sf) throws MsControlException {
        sf.setSfQualifiers(new HashSet<Qualifier>(DlgcSFMgr.getSupportedFeatureQualifier(DlgcMediaGroupConfig.class)));
        sf.setSfQualifiers(new HashSet<Qualifier>(DlgcSFMgr.getSupportedFeatureQualifier(DlgcNetworkConnectionConfig.class)));
        sf.setSfQualifiers(new HashSet<Qualifier>(DlgcSFMgr.getSupportedFeatureQualifier(DlgcMixerConfig.class)));
        sf.setSfQualifiers(new HashSet<Qualifier>(DlgcSFMgr.getSupportedFeatureQualifier(DlgcMixerAdapterConfig.class)));
    }

    public static Set<Qualifier> getSupportedFeatureQualifier(Class<?> aClass) throws MsControlException {
        return supportedFeatures.get(aClass).getSupportedQualifiers();
    }

    public static void getSupportedFeatureTrigger(DlgcSupportedFeatures sf) throws MsControlException {
        sf.setSfTriggers(new HashSet<Trigger>(DlgcSFMgr.getSupportedFeatureTrigger(DlgcMediaGroupConfig.class)));
        sf.setSfTriggers(new HashSet<Trigger>(DlgcSFMgr.getSupportedFeatureTrigger(DlgcNetworkConnectionConfig.class)));
        sf.setSfTriggers(new HashSet<Trigger>(DlgcSFMgr.getSupportedFeatureTrigger(DlgcMixerConfig.class)));
        sf.setSfTriggers(new HashSet<Trigger>(DlgcSFMgr.getSupportedFeatureTrigger(DlgcMixerAdapterConfig.class)));
    }

    public static Set<Trigger> getSupportedFeatureTrigger(Class<?> aClass) throws MsControlException {
        return supportedFeatures.get(aClass).getSupportedTriggers();
    }

    public static void getSupportedFeatureValue(DlgcSupportedFeatures sf) throws MsControlException {
        sf.setSfValues(new HashSet<Value>(DlgcSFMgr.getSupportedFeatureValue(DlgcMediaGroupConfig.class)));
        sf.setSfValues(new HashSet<Value>(DlgcSFMgr.getSupportedFeatureValue(DlgcNetworkConnectionConfig.class)));
        sf.setSfValues(new HashSet<Value>(DlgcSFMgr.getSupportedFeatureValue(DlgcMixerConfig.class)));
        sf.setSfValues(new HashSet<Value>(DlgcSFMgr.getSupportedFeatureValue(DlgcMixerAdapterConfig.class)));
    }

    public static Set<Value> getSupportedFeatureValue(Class<?> aClass) throws MsControlException {
        return supportedFeatures.get(aClass).getSupportedValues();
    }

    public static DlgcParameters getSupportedParameters(Class<?> aClass) throws MsControlException {
        if (!supportedParameters.containsKey(aClass)) {
            log.warn("Throwing Exception: This class type has no support for Supported Parameters (Map)");
            throw new MsControlException("There is no support for Supported Parameters for this class " + aClass.getName());
        }
        return supportedParameters.get(aClass);
    }

    public static DlgcParameters getDefaultParameters(Class<?> aClass) throws MsControlException {
        if (supportedParameters.get(aClass) != null) {
            if (cachedDefaultParameters.get(aClass) == null) {
                DlgcParameters defaultParameters = new DlgcParameters();
                Set sme = supportedParameters.get(aClass).entrySet();
                Iterator mapEntryIt = sme.iterator();
                if (mapEntryIt != null) {
                    while (mapEntryIt.hasNext()) {
                        Map.Entry pe = mapEntryIt.next();
                        if (pe == null) continue;
                        DlgcParameter defaultPar = (DlgcParameter)pe.getValue();
                        defaultParameters.put((Parameter)pe.getKey(), defaultPar.getDefaultValue());
                    }
                }
                cachedDefaultParameters.put(aClass, defaultParameters);
            }
            DlgcParameters result = new DlgcParameters();
            result.putAll(cachedDefaultParameters.get(aClass));
            return result;
        }
        log.debug("Throwing Exception: No supported parameters referenced for this class");
        throw new MsControlException("No supported parameters referenced for " + aClass.getName());
    }

    static {
        supportedParameters.put(DlgcPlayer.class, DlgcPlayer.loadSupportedParameters());
        supportedParameters.put(DlgcRecorder.class, DlgcRecorder.loadSupportedParameters());
        supportedParameters.put(DlgcSignalDetector.class, DlgcSignalDetector.loadSupportedParameters());
        supportedParameters.put(DlgcSignalGenerator.class, DlgcSignalGenerator.loadSupportedParameters());
        supportedParameters.put(DlgcSdpPortManager.class, DlgcSdpPortManager.loadSupportedParameters());
        supportedParameters.put(DlgcMediaGroup.class, DlgcMediaGroup.loadSupportedParameters());
        supportedParameters.put(DlgcMediaMixer.class, DlgcMediaMixer.loadSupportedParameters());
        supportedParameters.put(DlgcNetworkConnection.class, DlgcNetworkConnection.loadSupportedParameters());
        supportedParameters.put(DlgcSdpPortManager.class, DlgcSdpPortManager.loadSupportedParameters());
        supportedParameters.put(DlgcMixerAdapter.class, DlgcMixerAdapter.loadSupportedParameters());
        supportedParameters.put(DlgcMediaSession.class, DlgcMediaSession.loadSupportedParameters());
        supportedFeatures.put(DlgcMediaGroupConfig.class, DlgcMediaGroupConfig.loadSupportedFeatures());
        supportedFeatures.put(DlgcMixerConfig.class, DlgcMixerConfig.loadSupportedFeatures());
        supportedFeatures.put(DlgcNetworkConnectionConfig.class, DlgcNetworkConnectionConfig.loadSupportedFeatures());
        supportedFeatures.put(DlgcMixerAdapterConfig.class, DlgcMixerAdapterConfig.loadSupportedFeatures());
    }
}

