/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoRenderer;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MixerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.media.mscontrol.resource.video.VideoRendererEvent;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcProxyHelper {
    private static Logger log = LoggerFactory.getLogger(DlgcProxyHelper.class);

    public static JoinableStream getJoinableStream(DlgcProxy proxy, JoinableStream.StreamType strType) throws MsControlException {
        JoinableStream jStream = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(proxy.getMsObjectId());
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            jStream = jc.getJoinableStream(strType);
        }
        catch (Exception e) {
            log.error("Failed to  GetProxyMixerGroupResource", (Throwable)e);
            throw new MsControlException("Failed to  GetProxyMixerGroupResource", (Throwable)e);
        }
        return jStream;
    }

    public static JoinableStream[] getJoinableStreams(DlgcProxy proxy) throws MsControlException {
        JoinableStream[] jStream = null;
        JoinableStream[] jStreamProxy = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(proxy.getMsObjectId());
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            jStream = jc.getJoinableStreams();
            int numSize = jStream.length;
            jStreamProxy = new JoinableStream[numSize];
            for (int i = 0; i < numSize; ++i) {
                DlgcJoinableContainer j = (DlgcJoinableContainer)jStream[i];
                jStreamProxy[i] = (JoinableStream)j.getProxy();
            }
        }
        catch (Exception e) {
            log.error("Failed to  getJoinableStreams", (Throwable)e);
            throw new MsControlException("Failed to getJoinableStreams", (Throwable)e);
        }
        return jStreamProxy;
    }

    public static Joinable[] getJoinees(DlgcProxy proxy) throws MsControlException {
        Joinable[] joinable = null;
        Joinable[] proxyJoinables = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(proxy.getMsObjectId());
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            joinable = jc.getJoinees();
            int numSize = joinable.length;
            proxyJoinables = new Joinable[numSize];
            for (int i = 0; i < numSize; ++i) {
                DlgcJoinableContainer j = (DlgcJoinableContainer)joinable[i];
                proxyJoinables[i] = (Joinable)j.getProxy();
            }
        }
        catch (Exception e) {
            log.error("Failed to  getJoinees", (Throwable)e);
            throw new MsControlException("Failed to getJoinees", (Throwable)e);
        }
        return proxyJoinables;
    }

    public static Joinable[] getJoinees(DlgcProxy proxy, Joinable.Direction dir) throws MsControlException {
        Joinable[] joinable = null;
        Joinable[] proxyJoinables = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(proxy.getMsObjectId());
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            joinable = jc.getJoinees(dir);
            int numSize = joinable.length;
            proxyJoinables = new Joinable[numSize];
            for (int i = 0; i < numSize; ++i) {
                DlgcJoinableContainer j = (DlgcJoinableContainer)joinable[i];
                proxyJoinables[i] = (Joinable)j.getProxy();
            }
        }
        catch (Exception e) {
            log.error("Failed to  getJoinees with input varaible", (Throwable)e);
            throw new MsControlException("Failed to getJoinees", (Throwable)e);
        }
        return proxyJoinables;
    }

    public static void join(DlgcProxy proxy, Joinable.Direction dir, Joinable component) throws MsControlException {
        log.debug("Entering DlgcProxyHelper::join");
        if (component == null) {
            log.debug("Entering DlgcProxyHelper::join component value is null");
        } else {
            log.debug("Entering DlgcProxyHelper::join component value is:" + component.toString());
        }
        log.debug("DlgcProxyHelper::join  using joinAsync");
        DlgcProxyHelper.joinAsync(proxy, dir, component);
    }

    public static void joinAsync(final DlgcProxy proxy, final Joinable.Direction dir, final Joinable component) throws MsControlException {
        try {
            final SipApplicationSession compAppSession = ((DlgcProxy)component).getProxySAS();
            String sasId = proxy.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("DlgcProxyHelper:join Request");
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcJoinableContainer leftSideComponent = (DlgcJoinableContainer)session.getMediaObjectByProxyId(proxy.getContainerProxyId());
            final boolean isMediaGroup = component instanceof MediaGroup || leftSideComponent instanceof MediaGroup;
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::joinAsync Task run() => Media Server");
                    String joinableProxyId = ((DlgcProxy)component).getContainerProxyId();
                    String joinableContainerProxId = ((DlgcProxy)component).getContainerProxyId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(proxy.getMsObjectId());
                    session.setRequestTypeToProxy();
                    DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(proxy.getContainerProxyId());
                    log.debug("ELTORO: proxyNC ID: jc: " + jc.mediaObjectID);
                    DlgcJoinableContainer componentImpl = (DlgcJoinableContainer)session.getMediaObjectByProxyId(joinableContainerProxId);
                    DlgcMediaSession joinableSession = null;
                    if (componentImpl == null) {
                        joinableSession = (DlgcMediaSession)compAppSession.getAttribute(((DlgcProxy)component).getMsObjectId());
                        componentImpl = (DlgcJoinableContainer)joinableSession.getMediaObjectByProxyId(joinableProxyId);
                        log.debug("ELTORO: proxyNC ID: componentImpl: " + componentImpl.mediaObjectID);
                    }
                    try {
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && !isMediaGroup) {
                            log.debug("SYNC_2_ASYNC DlgcProxyHelper joinAsync:: setting monitor object in resource container");
                            componentImpl.setMonitor(monitor);
                            jc.setMonitor(monitor);
                        }
                        log.debug("SYNC_2_ASYNC DlgcProxyHelper joinAsync:: calling join() method");
                        jc.join(dir, (Joinable)componentImpl);
                        log.debug("SYNC_2_ASYNC DlgcProxyHelper joinAsync:: returning from join() method");
                    }
                    catch (MsControlException e) {
                        log.debug("DlgcProxyHelper::joinAsync: " + e.toString());
                    }
                    proxy.saveMediaSession(appSession, session);
                    log.debug("Exiting ProxyHelper::joinAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && !isMediaGroup) {
                log.debug("SYNC_2_ASYNC DlgcProxyHelper joinAsync:: OUTSIDE Waiting synchronously for join request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC DlgcProxyHelper joinAsync: OUTSIDE join Monitor returned with the following status: " + monitor.getStatusString());
                DlgcProxyHelper.clearMonitor(proxy, component);
            }
        }
        catch (Exception e) {
            log.error("Failed to join", (Throwable)e);
            throw new MsControlException("Failed to join", (Throwable)e);
        }
    }

    public static void clearMonitor(DlgcProxy proxy, Joinable component) {
        DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
        SipApplicationSession compAppSession = ((DlgcProxy)component).getProxySAS();
        String joinableProxyId = ((DlgcProxy)component).getContainerProxyId();
        DlgcMediaSession joinableSession = (DlgcMediaSession)compAppSession.getAttribute(((DlgcProxy)component).getMsObjectId());
        DlgcJoinableContainer componentImpl = (DlgcJoinableContainer)joinableSession.getMediaObjectByProxyId(joinableProxyId);
        componentImpl.setMonitor(null);
        DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(proxy.getContainerProxyId());
        jc.setMonitor(null);
    }

    public static void joinInitiate(DlgcProxy proxy, Joinable.Direction dir, Joinable component, Serializable serial) throws MsControlException {
        log.debug("DlgcProxyHelper::joinInitiate  using joinInitiateAsync");
        DlgcProxyHelper.joinInitiateAsync(proxy, dir, component, serial);
    }

    protected static void joinInitiateAsync(final DlgcProxy proxy, final Joinable.Direction dir, final Joinable component, final Serializable serial) throws MsControlException {
        try {
            final String containerProxId = proxy.getContainerProxyId();
            final SipApplicationSession compAppSession = ((DlgcProxy)component).getProxySAS();
            String sasId = proxy.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::joinInitiateAsync Task run() => Media Server");
                    String objId = proxy.getMsObjectId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
                    session.setRequestTypeToProxy();
                    DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
                    String cproxyId = ((DlgcProxy)component).getContainerProxyId();
                    DlgcJoinableContainer componentImpl = (DlgcJoinableContainer)session.getMediaObjectByProxyId(cproxyId);
                    DlgcMediaSession joinableSession = null;
                    if (componentImpl == null) {
                        joinableSession = (DlgcMediaSession)compAppSession.getAttribute(((DlgcProxy)component).getMsObjectId());
                        componentImpl = (DlgcJoinableContainer)joinableSession.getMediaObjectByProxyId(cproxyId);
                    }
                    try {
                        jc.joinInitiate(dir, (Joinable)componentImpl, serial);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    proxy.saveMediaSession(appSession, session);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to joinInitiate", (Throwable)e);
            throw new MsControlException("Failed to joinInitiate", (Throwable)e);
        }
    }

    public static void unjoin(DlgcProxy proxy, Joinable component) throws MsControlException {
        log.debug("DlgcProxyHelper::unjoin  using unjoinAsync");
        DlgcProxyHelper.unjoinAsync(proxy, component);
    }

    protected static void unjoinAsync(final DlgcProxy proxy, final Joinable component) throws MsControlException {
        try {
            final String containerProxId = proxy.getContainerProxyId();
            final SipApplicationSession compAppSession = ((DlgcProxy)component).getProxySAS();
            String sasId = proxy.getProxyId();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("DlgcProxyHelper:unjoin Request");
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::unjoinAsync Task run() => Media Server");
                    String objId = proxy.getMsObjectId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
                    session.setRequestTypeToProxy();
                    DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
                    String cproxyId = ((DlgcProxy)component).getContainerProxyId();
                    DlgcJoinableContainer componentImpl = (DlgcJoinableContainer)session.getMediaObjectByProxyId(cproxyId);
                    DlgcMediaSession joinableSession = null;
                    if (componentImpl == null) {
                        joinableSession = (DlgcMediaSession)compAppSession.getAttribute(((DlgcProxy)component).getMsObjectId());
                        componentImpl = (DlgcJoinableContainer)joinableSession.getMediaObjectByProxyId(cproxyId);
                        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                            componentImpl.setMonitor(monitor);
                            jc.setMonitor(monitor);
                        }
                    }
                    try {
                        jc.unjoin((Joinable)componentImpl);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    proxy.saveMediaSession(appSession, session);
                    log.debug("Exiting ProxyHelper::unjoinAsync Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("DlgcProxyHelper unjoinAsync:: OUTSIDE Waiting synchronously for unjoin request to return");
                monitor.waitForRequestCompletion();
                log.debug("DlgcProxyHelper unjoinAsync: OUTSIDE unjoin Monitor returned with the following status: " + monitor.getStatusString());
                DlgcProxyHelper.clearMonitor(proxy, component);
            }
        }
        catch (Exception e) {
            log.error("Failed to  unjoin", (Throwable)e);
            throw new MsControlException("Failed to unjoin", (Throwable)e);
        }
    }

    public static void unjoinInitiate(DlgcProxy proxy, Joinable component, Serializable serial) throws MsControlException {
        log.debug("DlgcProxyHelper::unjoinInitiate  using unjoinInitiateAsync");
        DlgcProxyHelper.unjoinInitiateAsync(proxy, component, serial);
    }

    protected static void unjoinInitiateAsync(final DlgcProxy proxy, final Joinable component, final Serializable serial) throws MsControlException {
        try {
            final String containerProxId = proxy.getContainerProxyId();
            final SipApplicationSession compAppSession = ((DlgcProxy)component).getProxySAS();
            String sasId = proxy.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::unjoinInitiateAsync Task run() => Media Server");
                    String objId = proxy.getMsObjectId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
                    session.setRequestTypeToProxy();
                    DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
                    String cproxyId = ((DlgcProxy)component).getContainerProxyId();
                    DlgcJoinableContainer componentImpl = (DlgcJoinableContainer)session.getMediaObjectByProxyId(cproxyId);
                    DlgcMediaSession joinableSession = null;
                    if (componentImpl == null) {
                        joinableSession = (DlgcMediaSession)compAppSession.getAttribute(((DlgcProxy)component).getMsObjectId());
                        componentImpl = (DlgcJoinableContainer)joinableSession.getMediaObjectByProxyId(cproxyId);
                    }
                    try {
                        jc.unjoinInitiate((Joinable)componentImpl, serial);
                    }
                    catch (MsControlException e) {
                        log.debug(e.toString());
                    }
                    proxy.saveMediaSession(appSession, session);
                    log.debug("Exiting ProxyHelper::unjoinInitiateAsync Task run() => Media Server");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to  unjoinInitiate", (Throwable)e);
            throw new MsControlException("Failed to unjoinInitiate", (Throwable)e);
        }
    }

    public static void addListener(DlgcProxy proxy, JoinEventListener evLIstener) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            jc.addListener(evLIstener);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  addListener", (Throwable)e);
        }
    }

    public static MediaSession getMediaSession(DlgcProxy proxy) {
        DlgcMediaSession ms = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            ms = (DlgcMediaSession)jc.getMediaSession();
        }
        catch (Exception e) {
            log.error("Failed to  getMediaSession", (Throwable)e);
        }
        return ms.getProxy();
    }

    public static void removeListener(DlgcProxy proxy, JoinEventListener jeListener) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            jc.removeListener(jeListener);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  removeListener", (Throwable)e);
        }
    }

    public static void confirm(DlgcProxy proxy) throws MsControlException {
        log.debug("DlgcProxyHelper::confirmAsync  using confirmAsync");
        DlgcProxyHelper.confirmAsync(proxy);
    }

    public static void confirmAsync(final DlgcProxy proxy) throws MsControlException {
        log.debug("DLgcProxyHelper::confirmAsync()");
        try {
            final String containerProxId = proxy.getContainerProxyId();
            String sasId = proxy.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::confirmAsync Task run() => Media Server");
                    String objId = proxy.getMsObjectId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
                    session.setRequestTypeToProxy();
                    DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
                    try {
                        jc.confirm();
                    }
                    catch (MsControlException e) {
                        appSession.setAttribute("confirmAsyncException", (Object)e);
                        log.debug(e.toString());
                    }
                    proxy.saveMediaSession(appSession, session);
                    log.debug("Exiting ProxyHelper::confirmAsync Task run() => Media Server");
                }
            });
            SipApplicationSession sasx = DlgcSipServlet.getSSU().getApplicationSessionById(sasId);
            MsControlException msc = (MsControlException)((Object)sasx.getAttribute("confirmAsyncException"));
            if (msc != null) {
                sasx.removeAttribute("confirmAsyncException");
                throw msc;
            }
        }
        catch (Exception e) {
            log.error("Failed to  confirm", (Throwable)e);
            throw new MsControlException(e.getMessage());
        }
    }

    public static MediaConfig getConfig(DlgcProxy proxy) {
        MediaConfig conf = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            conf = jc.getConfig();
        }
        catch (Exception e) {
            log.error("Failed to  confirm", (Throwable)e);
        }
        return conf;
    }

    public static <R> R getResource(DlgcProxy proxy, Class<R> resourteType) throws MsControlException {
        R resource = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            resource = jc.getResource(resourteType);
        }
        catch (Exception e) {
            log.error("Failed to  getResource", (Throwable)e);
            throw new MsControlException("Failed to getResource", (Throwable)e);
        }
        return resource;
    }

    public static void triggerAction(DlgcProxy proxy, Action anAction) {
        log.debug("DlgcProxyHelper::triggerActionAsync  using triggerActionAsync");
        DlgcProxyHelper.triggerActionAsync(proxy, anAction);
    }

    protected static void triggerActionAsync(final DlgcProxy proxy, final Action anAction) {
        try {
            final String containerProxId = proxy.getContainerProxyId();
            String sasId = proxy.getProxyId();
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::triggerActionAsync Task run() => Media Server");
                    String objId = proxy.getMsObjectId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
                    session.setRequestTypeToProxy();
                    DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
                    jc.triggerAction(anAction);
                    proxy.saveMediaSession(appSession, session);
                    log.debug("Exiting ProxyHelper::triggerActionAsync Task run() => Media Server");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to  triggerAction", (Throwable)e);
        }
    }

    public static Parameters createParameters(DlgcProxy proxy) {
        Parameters params = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            params = jc.createParameters();
            return params;
        }
        catch (Exception e) {
            log.error("Failed to  createParameters", (Throwable)e);
            return params;
        }
    }

    public static Iterator<MediaObject> getMediaObjects(DlgcProxy proxy) {
        Iterator<MediaObject> it = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            it = jc.getMediaObjects();
        }
        catch (Exception e) {
            log.error("Failed to  getMediaObjects", (Throwable)e);
        }
        return it;
    }

    public static <T extends MediaObject> Iterator<T> getMediaObjects(DlgcProxy proxy, Class<T> objType) {
        Iterator<T> it = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            it = jc.getMediaObjects(objType);
        }
        catch (Exception e) {
            log.error("Failed to  getMediaObjects", (Throwable)e);
        }
        return it;
    }

    public static Parameters getParameters(DlgcProxy proxy, Parameter[] arg0) {
        Parameters params = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            params = jc.getParameters(arg0);
        }
        catch (Exception e) {
            log.error("Failed to  getParameters", (Throwable)e);
        }
        return params;
    }

    public static URI getURI(DlgcProxy proxy) {
        URI uri = null;
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            uri = jc.getURI();
        }
        catch (Exception e) {
            log.error("Failed to  getURI", (Throwable)e);
        }
        return uri;
    }

    public static void release(DlgcProxy proxy) {
        log.debug("DlgcProxyHelper::release  using releaseAsync");
        DlgcProxyHelper.releaseAsync(proxy);
    }

    protected static void releaseAsync(final DlgcProxy proxy) {
        try {
            SipApplicationSession appSession = proxy.getProxySAS();
            final String containerProxId = proxy.getContainerProxyId();
            String sasId = proxy.getProxyId();
            if (appSession == null) {
                log.warn("<<<<<<< DlgcProxyHelper::release  SAS is null  >>>>>>>>>>>>>>>>");
            }
            DlgcMediaSession session = (DlgcMediaSession)proxy.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering ProxyHelper::releaseAsync Task run() => Media Server");
                    String objId = proxy.getMsObjectId();
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
                    session.setRequestTypeToProxy();
                    DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
                    jc.release();
                    log.debug("Exiting ProxyHelper::releaseAsync Task run() => Media Server");
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to  release", (Throwable)e);
        }
    }

    public static void setParameters(DlgcProxy proxy, Parameters arg0) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            jc.setParameters(arg0);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  setParameters", (Throwable)e);
        }
    }

    public static void addListener(DlgcProxy proxy, AllocationEventListener arg0) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcResourceContainer jc = (DlgcResourceContainer)session.getMediaObjectByProxyId(containerProxId);
            jc.addListener(arg0);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  addListener", (Throwable)e);
        }
    }

    public static void addListener(DlgcProxy proxy, MediaEventListener<MixerEvent> arg0) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcMediaMixer mx = (DlgcMediaMixer)session.getMediaObjectByProxyId(containerProxId);
            mx.addListener(arg0);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  addListener", (Throwable)e);
        }
    }

    public static void removeListener(DlgcProxy proxy, MediaEventListener<MixerEvent> arg0) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcMediaMixer mx = (DlgcMediaMixer)session.getMediaObjectByProxyId(containerProxId);
            mx.removeListener(arg0);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  removeListener", (Throwable)e);
        }
    }

    public static void addListenerVideoRenderer(DlgcProxy proxy, MediaEventListener<VideoRendererEvent> vrListener) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcXMediaMixer mx = (DlgcXMediaMixer)session.getMediaObjectByProxyId(containerProxId);
            DlgcVideoRenderer vr = mx.getVideoRenderer();
            vr.addListener(vrListener);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  addListener", (Throwable)e);
        }
    }

    public static void removeListenerVideoRenderer(DlgcProxy proxy, MediaEventListener<VideoRendererEvent> vrListener) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcXMediaMixer mx = (DlgcXMediaMixer)session.getMediaObjectByProxyId(containerProxId);
            DlgcVideoRenderer vr = mx.getVideoRenderer();
            vr.removeListener(vrListener);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  removeListener", (Throwable)e);
        }
    }

    public static void removeListener(DlgcProxy proxy, AllocationEventListener arg0) {
        try {
            String containerProxId = proxy.getContainerProxyId();
            SipApplicationSession appSession = proxy.getProxySAS();
            String objId = proxy.getMsObjectId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(objId);
            DlgcJoinableContainer jc = (DlgcJoinableContainer)session.getMediaObjectByProxyId(containerProxId);
            jc.removeListener(arg0);
            proxy.saveMediaSession(appSession, session);
        }
        catch (Exception e) {
            log.error("Failed to  removeListener", (Throwable)e);
        }
    }
}

