/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.Serializable;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.servlet.sip.SipApplicationSession;
import org.mobicents.javax.servlet.sip.SipSessionsUtilExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient MediaObject standAloneObject;
    protected String sasId = null;
    protected String msContainerProxyId = null;
    protected String msObjId = null;
    private static Logger log = LoggerFactory.getLogger(DlgcProxy.class);

    public DlgcProxy(String theSasId, String containerMsId, String mediaSessionObjId) {
        this.sasId = theSasId;
        this.standAloneObject = null;
        if (this.sasId == null) {
            log.debug("DlgcProxy sasId = null");
        }
        this.msObjId = mediaSessionObjId;
        this.msContainerProxyId = containerMsId;
    }

    public SipApplicationSession getProxySAS() {
        SipApplicationSession sas = null;
        if (this.sasId == null) {
            log.debug("DlgcProxy: getProxySAS proxyId is null");
        }
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("TELESTAX")) {
            SipSessionsUtilExt ssuE = (SipSessionsUtilExt)DlgcSipServlet.getSSU();
            sas = ssuE.getApplicationSessionById(this.sasId, false);
        } else {
            sas = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasId);
        }
        return sas;
    }

    public SipApplicationSession getProxySAS(String proxId) {
        SipApplicationSession sas = null;
        if (proxId == null) {
            log.debug("DlgcProxy: getProxySAS proxyId is null");
        }
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("TELESTAX")) {
            SipSessionsUtilExt ssuE = (SipSessionsUtilExt)DlgcSipServlet.getSSU();
            sas = ssuE.getApplicationSessionById(proxId, false);
        } else {
            sas = DlgcSipServlet.getSSU().getApplicationSessionById(proxId);
        }
        return sas;
    }

    public String getProxyId() {
        return this.sasId;
    }

    public void saveMediaSession(SipApplicationSession appSession, DlgcMediaSession session) {
        if (DlgcInstrumentPropertyMgr.bSaveMediaSessionProxy) {
            if (appSession != null) {
                log.debug("DlgcProxy::saveMediaSession: setAttribute on Media Session.");
                appSession.setAttribute(this.getMsObjectId(), (Object)session);
            } else {
                log.debug("DlgcProxy::saveMediaSession: cant save Media Session since appSession is null");
            }
        }
    }

    public MediaSession getMediaSessionX() {
        MediaSession ms = null;
        SipApplicationSession appSession = this.getProxySAS();
        if (appSession != null) {
            log.debug("DlgcProxy::getMediaSessionX: via getAttribute on Media Session.");
            ms = (MediaSession)appSession.getAttribute(this.getMsObjectId());
        } else {
            log.debug("DlgcProxy::getMediaSessionX: cant save Media Session since appSession is null");
        }
        return ms;
    }

    public String getMsObjectId() {
        return this.msObjId;
    }

    public void setStandaloneObject(MediaObject mo) {
        this.standAloneObject = mo;
    }

    public MediaObject getStandaloneObject() {
        return this.standAloneObject;
    }

    public String getContainerProxyId() {
        return this.msContainerProxyId;
    }
}

