/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcParameter<T>
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(DlgcParameter.class);
    private Class<T> type;
    private T defaultValue;
    private T value;
    private List<T> validValueList = new ArrayList<T>();

    protected DlgcParameter(Class<T> type, T defaultValue) {
        this.type = type;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Class<T> getType() {
        return this.type;
    }

    public final List<T> getValidValues() {
        return this.validValueList;
    }

    public T getValue() {
        return this.value;
    }

    public abstract boolean isValueValid(T var1);

    public boolean setValue(T value) {
        boolean rc = this.isValueValid(value);
        if (rc) {
            this.value = value;
        }
        return rc;
    }

    protected boolean validateValue(T value) {
        return this.validValueList.contains(value);
    }
}

