/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSessionProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.DlgcsmilDocument;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.video.DlgcVideoLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaConfigException;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.resource.video.VideoLayout;
import javax.servlet.sip.SipApplicationSession;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.mobicents.javax.servlet.sip.SipSessionsUtilExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMsControlFactory
implements MsControlFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    public static DlgcAsynDispatcher asynDispatcher = null;
    protected DlgcMediaServer mediaServer = null;
    public static CONNECTOR_SIP_MODE ConnectorSipMode = CONNECTOR_SIP_MODE.SERVLET;
    protected Properties properties;
    private static Logger log = LoggerFactory.getLogger(DlgcMsControlFactory.class);
    public static final Map<String, String> VideoLayoutRegionTable = new HashMap<String, String>();

    public DlgcMsControlFactory(Properties properties) {
        this.properties = properties;
        asynDispatcher = new DlgcAsynDispatcher(properties);
    }

    public DlgcMsControlFactory(Properties properties, String msu) {
        this.properties = properties;
        if (msu != null) {
            this.mediaServer = new DlgcMediaServer(msu);
        } else {
            log.error("DlgcMsControlFactory::CTOR passed in Media Server URI is NULL...major error");
        }
    }

    public DlgcMsControlFactory(Properties properties, boolean isDynamicConfig) {
        log.debug("DlgcMsControlFactory:: CTOR using Dynamic Factory Configuration");
        this.properties = properties;
        this.mediaServer = new DlgcMediaServer(properties);
        asynDispatcher = new DlgcAsynDispatcher(properties);
    }

    public MediaSession createMediaSession() throws MsControlException {
        DlgcMediaSession mediaSession = new DlgcMediaSession(this);
        try {
            CreateMediaSessionAction cms = new CreateMediaSessionAction(mediaSession);
            cms.run();
            if (mediaSession.getProxyId() == null) {
                log.debug("Major Issue: MSControlFactory - returned sasId is null ... Bummer...");
            } else {
                log.debug("MSControlFactory - returned successful sasId is " + mediaSession.getProxyId());
            }
            log.debug("Enter MSControlFactory::createMediaSession thread finished creating appSession");
        }
        catch (Exception e) {
            log.error("Failed to schedule work", (Throwable)e);
            throw new MsControlException("Failed to schedule work", (Throwable)e);
        }
        if (mediaSession.proxyId == null) {
            log.debug("Enter MSControlFactory::createMediaSession the mediaSession sasId is null ... bummer");
        } else {
            log.debug("Enter MSControlFactory::createMediaSession the mediaSession sasId = " + mediaSession.proxyId);
        }
        DlgcMediaSessionProxy msProxy = mediaSession.getProxy();
        log.debug("MSControlFactory::createMediaSession the MSTYPE is IPMS");
        msProxy.setAttribute("MSTYPE", "IPMS");
        return msProxy;
    }

    public Parameters createParameters() {
        return new DlgcParameters();
    }

    public VideoLayout createVideoLayout(String mimeType, Reader xmlLayoutReader) throws MediaConfigException {
        if (mimeType != "application/dlgcsmil+xml") {
            throw new MediaConfigException("Unsupported mime type");
        }
        StringBuilder builder = new StringBuilder();
        BufferedReader bReader = new BufferedReader(xmlLayoutReader);
        String line = null;
        try {
            while ((line = bReader.readLine()) != null) {
                log.debug("User Layout Line Read: " + line);
                builder.append(line);
            }
        }
        catch (IOException e1) {
            throw new MediaConfigException(e1.toString());
        }
        String stringReadFromReader = builder.toString();
        DlgcsmilDocument dlgcsmilDoc = null;
        ArrayList validationErrors = new ArrayList();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(validationErrors);
        try {
            dlgcsmilDoc = DlgcsmilDocument.Factory.parse((String)stringReadFromReader);
            if (!dlgcsmilDoc.validate(validationOptions)) {
                Iterator iter = validationErrors.iterator();
                while (iter.hasNext()) {
                    log.error("doc validation error:  " + iter.next());
                }
                throw new MediaConfigException("Invalid video layout xml doc");
            }
        }
        catch (XmlException e) {
            log.error("Invalid video layout xml doc", (Throwable)e);
            throw new MediaConfigException(e.toString());
        }
        DlgcVideoLayout newVideoLayout = new DlgcVideoLayout(mimeType, stringReadFromReader);
        return newVideoLayout;
    }

    public MediaConfig getMediaConfig(Configuration<?> cfg) throws MediaConfigException {
        return DlgcMediaConfig.getContainerSupportedConfiguration(cfg);
    }

    public MediaConfig getMediaConfig(Reader arg0) throws MediaConfigException {
        throw new MediaConfigException("Not Implemented at this time");
    }

    public MediaObject getMediaObject(URI uriToSearch) {
        MediaSession foundMo = null;
        String sasId = this.getSasID(uriToSearch);
        SipApplicationSession sas = null;
        if (sasId != null) {
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("TELESTAX")) {
                SipSessionsUtilExt ssuE = (SipSessionsUtilExt)DlgcSipServlet.getSSU();
                sas = ssuE.getApplicationSessionById(sasId, false);
            } else {
                sas = DlgcSipServlet.getSSU().getApplicationSessionById(sasId);
            }
            if (sas != null) {
                String moId = this.getMediaObjectFromUri(uriToSearch);
                try {
                    foundMo = (MediaSession)sas.getAttribute(moId);
                }
                catch (Exception ex) {
                    log.debug("Error can't retrieve MediaObject invalid URI media Object ID");
                    ex.printStackTrace();
                }
            }
        } else {
            log.debug("Error can't retrieve MediaObject invalid URI SASID");
        }
        return foundMo;
    }

    public VideoLayout getPresetLayout(String arg0) throws MediaConfigException {
        String layout = null;
        layout = VideoLayoutRegionTable.get(arg0.toLowerCase());
        if (layout == null) {
            throw new MediaConfigException("Unsupported layout type");
        }
        return new DlgcVideoLayout("application/dlgcsmil-xml", layout, arg0.toLowerCase());
    }

    public VideoLayout[] getPresetLayouts(int arg0) throws MediaConfigException {
        VideoLayout[] arrayVideoLayout;
        if (arg0 > 0 && arg0 < 2) {
            arrayVideoLayout = new VideoLayout[1];
            String layout = VideoLayoutRegionTable.get("xcon:single-view");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:single-view");
        } else if (arg0 == 2) {
            arrayVideoLayout = new VideoLayout[2];
            String layout = VideoLayoutRegionTable.get("xcon:dual-view");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:dual-view");
            layout = VideoLayoutRegionTable.get("xcon:dual-view-2x1");
            arrayVideoLayout[1] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:dual-view-2x1");
        } else if (arg0 < 5) {
            arrayVideoLayout = new VideoLayout[1];
            String layout = VideoLayoutRegionTable.get("xcon:quad-view");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:quad-view");
        } else if (arg0 < 7) {
            arrayVideoLayout = new VideoLayout[1];
            String layout = VideoLayoutRegionTable.get("xcon:multiple-5x1");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:multiple-5x1");
        } else if (arg0 < 9) {
            arrayVideoLayout = new VideoLayout[1];
            String layout = VideoLayoutRegionTable.get("xcon:multiple-7x1");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:multiple-7x1");
        } else if (arg0 == 9) {
            arrayVideoLayout = new VideoLayout[1];
            String layout = VideoLayoutRegionTable.get("xcon:multiple-3x3");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:multiple-3x3");
        } else if (arg0 > 9) {
            arrayVideoLayout = new VideoLayout[1];
            String layout = VideoLayoutRegionTable.get("xcon:multiple-8x2");
            arrayVideoLayout[0] = new DlgcVideoLayout("application/dlgcsmil-xml", layout, "xcon:multiple-8x2");
        } else {
            throw new MediaConfigException("Unsupported number of regions");
        }
        return arrayVideoLayout;
    }

    public Properties getProperties() {
        Properties rdOnlyProp = new Properties();
        rdOnlyProp.putAll((Map<?, ?>)this.properties);
        return rdOnlyProp;
    }

    public boolean isMediaServerBasedOnMS_URI() {
        if (this.mediaServer == null) {
            return false;
        }
        return this.mediaServer.is_MS_URI_DEFINED();
    }

    public boolean isDynamicConfiguration() {
        if (this.mediaServer == null) {
            return false;
        }
        return this.mediaServer.isDynamicConfigured();
    }

    public DlgcMediaServer getMediaServer() {
        return this.mediaServer;
    }

    protected String getSasID(URI uri) {
        String path = uri.getPath().substring(1);
        int endSasInt = path.indexOf(".MS");
        String sasId = null;
        sasId = DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("TROPO") == 0 || DlgcSipServlet.APP_SERVER_PLATFORM.compareToIgnoreCase("IBM") == 0 ? path.substring(0, endSasInt) : path.substring(0, endSasInt).replace('_', '|');
        return sasId;
    }

    protected String getMediaObjectFromUri(URI uri) {
        String path = uri.getPath().substring(1);
        int msIdIndex = path.indexOf(".MS") + 1;
        String mediaObj = path.substring(msIdIndex);
        return mediaObj;
    }

    static {
        VideoLayoutRegionTable.put("xcon:single-view", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"0\" relativesize=\"1\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:dual-view", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"25\" relativesize=\"1/2\"/>\n<region id=\"2\" left=\"50\" top=\"25\" relativesize=\"1/2\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:dual-view-2x1", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"25\" top=\"0\" relativesize=\"1/2\"/>\n<region id=\"2\" left=\"25\" top=\"50\" relativesize=\"1/2\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:quad-view", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"0\" relativesize=\"1/2\"/>\n<region id=\"2\" left=\"50\" top=\"0\" relativesize=\"1/2\"/>\n<region id=\"3\" left=\"0\" top=\"50\" relativesize=\"1/2\"/>\n<region id=\"4\" left=\"50\" top=\"50\" relativesize=\"1/2\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"3\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"4\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:multiple-5x1", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"0\" relativesize=\"2/3\"/>\n<region id=\"2\" left=\"67\" top=\"0\" relativesize=\"1/3\"/>\n<region id=\"3\" left=\"67\" top=\"33\" relativesize=\"1/3\"/>\n<region id=\"4\" left=\"67\" top=\"67\" relativesize=\"1/3\"/>\n<region id=\"5\" left=\"33\" top=\"67\" relativesize=\"1/3\"/>\n<region id=\"6\" left=\"0\" top=\"67\" relativesize=\"1/3\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"3\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"4\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"5\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"6\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:multiple-7x1", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"0\" relativesize=\"3/4\"/>\n<region id=\"2\" left=\"0\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"3\" left=\"25\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"4\" left=\"50\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"5\" left=\"75\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"6\" left=\"75\" top=\"50\" relativesize=\"1/4\"/>\n<region id=\"7\" left=\"75\" top=\"25\" relativesize=\"1/4\"/>\n<region id=\"8\" left=\"75\" top=\"0\" relativesize=\"1/4\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"3\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"4\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"5\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"6\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"7\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"8\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:multiple-3x3", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"0\" relativesize=\"1/3\"/>\n<region id=\"2\" left=\"0\" top=\"33\" relativesize=\"1/3\"/>\n<region id=\"3\" left=\"0\" top=\"67\" relativesize=\"1/3\"/>\n<region id=\"4\" left=\"33\" top=\"0\" relativesize=\"1/3\"/>\n<region id=\"5\" left=\"33\" top=\"33\" relativesize=\"1/3\"/>\n<region id=\"6\" left=\"33\" top=\"67\" relativesize=\"1/3\"/>\n<region id=\"7\" left=\"67\" top=\"0\" relativesize=\"1/3\"/>\n<region id=\"8\" left=\"67\" top=\"33\" relativesize=\"1/3\"/>\n<region id=\"9\" left=\"67\" top=\"67\" relativesize=\"1/3\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"3\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"4\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"5\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"6\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"7\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"8\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"9\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
        VideoLayoutRegionTable.put("xcon:multiple-8x2", "<dlgcsmil>\n<head>\n<layout size=\"CIF\">\n<region id=\"1\" left=\"0\" top=\"0\" relativesize=\"1/2\"/>\n<region id=\"2\" left=\"50\" top=\"0\" relativesize=\"1/2\"/>\n<region id=\"3\" left=\"0\" top=\"50\" relativesize=\"1/4\"/>\n<region id=\"4\" left=\"25\" top=\"50\" relativesize=\"1/4\"/>\n<region id=\"5\" left=\"50\" top=\"50\" relativesize=\"1/4\"/>\n<region id=\"6\" left=\"75\" top=\"50\" relativesize=\"1/4\"/>\n<region id=\"7\" left=\"0\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"8\" left=\"25\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"9\" left=\"50\" top=\"75\" relativesize=\"1/4\"/>\n<region id=\"10\" left=\"75\" top=\"75\" relativesize=\"1/4\"/>\n</layout>\n</head>\n<body>\n<par>\n<ref region=\"1\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"2\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"3\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"4\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"5\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"6\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"7\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"8\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"9\" src=\"" + VideoLayout.anyStream + "\" />\n" + "<ref region=\"10\" src=\"" + VideoLayout.anyStream + "\" />\n" + "</par>\n" + "</body>\n" + "</dlgcsmil>");
    }

    class CreateMediaSessionAction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DlgcMediaSession mMediaSession;

        public CreateMediaSessionAction(DlgcMediaSession mediaSession) {
            this.mMediaSession = mediaSession;
        }

        public void run() {
            try {
                log.debug("***MsControlFactory::CreateMediaSessionAction in work thread***");
                SipApplicationSession appSession = DlgcSipServlet.getSipFactory().createApplicationSession();
                String sasId = appSession.getId();
                log.debug("APRIL 2013 - DlgcMsControlFactory:CreateMediaSessionAction(response): SASID: " + sasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
                log.debug("MsControlFactory run thread created sasId = " + sasId);
                this.mMediaSession.setProxyId(sasId);
                this.mMediaSession.setAsyncDispatcher(asynDispatcher);
                appSession.setAttribute(this.mMediaSession.getMediaObject(), (Object)this.mMediaSession);
            }
            catch (Exception e) {
                log.error("Failed to create Media Session", (Throwable)e);
            }
        }
    }

    public static enum CONNECTOR_SIP_MODE {
        SERVLET,
        STANDALONE;

    }
}

