/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMediaConfig;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroupProxy;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixerProxy;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnectionProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.vxml.VxmlDialog;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaSessionProxy
extends DlgcProxy
implements MediaSession,
Serializable {
    private static final long serialVersionUID = 93800273847L;
    private static Logger log = LoggerFactory.getLogger(DlgcMediaSessionProxy.class);

    public DlgcMediaSessionProxy(String sid, String objId) {
        super(sid, null, objId);
        if (sid == null) {
            log.debug("DlgcMediaSessionProxy: CTOR sasID = null");
        }
    }

    public DlgcMediaSessionProxy(URI uri, String objId) {
        super(null, null, objId);
        String path = uri.getPath();
        this.sasId = path.substring(1);
        this.sasId = this.sasId.replace('_', '|');
    }

    public MediaGroup createMediaGroup(Configuration<MediaGroup> predefinedConfig) throws MsControlException {
        Object predefConf = null;
        String msType = (String)this.getAttribute("MSTYPE");
        if (null != msType && msType.equalsIgnoreCase("IPMS")) {
            predefConf = DlgcMediaConfig.getContainerSupportedConfiguration(predefinedConfig);
        } else {
            if (predefinedConfig == null) {
                throw new MsControlException("Cannot create mediaobject MediaConfig parameter are null");
            }
            predefConf = DlgcXMediaConfig.getContainerSupportedConfiguration(predefinedConfig);
        }
        return this.createMediaGroup((MediaConfig)predefConf, Parameters.NO_PARAMETER);
    }

    public MediaGroup createMediaGroup(Configuration<MediaGroup> preConfig, Parameters params) throws MsControlException {
        if (preConfig == null) {
            throw new MsControlException("Cannot create createMediaGroup MediaConfig parameter are null");
        }
        return this.createMediaGroup(DlgcXMediaConfig.getContainerSupportedConfiguration(preConfig), params);
    }

    public MediaGroup createMediaGroup(MediaConfig predefinedConfig, Parameters params) throws MsControlException {
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(this.getMsObjectId());
            DlgcMediaGroup mg = (DlgcMediaGroup)session.createMediaGroup(predefinedConfig, params);
            appSession.setAttribute(session.getMediaObject(), (Object)session);
            DlgcMediaGroupProxy mgProxy = (DlgcMediaGroupProxy)mg.getProxy();
            return mgProxy;
        }
        catch (Exception e) {
            log.error("Failed to create MediaGroup", (Throwable)e);
            throw new MsControlException("Failed to create MediaGroup", (Throwable)e);
        }
    }

    public MediaMixer createMediaMixer(Configuration<MediaMixer> predefinedConfig) throws MsControlException {
        Object predefConf = null;
        String msType = (String)this.getAttribute("MSTYPE");
        log.debug("DlgcMediaSessionProxy::createMediaMixer predefinedConfig: " + predefinedConfig.toString());
        if (null != msType && msType.equalsIgnoreCase("IPMS")) {
            predefConf = DlgcMediaConfig.getContainerSupportedConfiguration(predefinedConfig);
            log.debug("DlgcMediaSessionProxy::createMediaMixer IPMS configuration");
        } else {
            predefConf = DlgcXMediaConfig.getContainerSupportedConfiguration(predefinedConfig);
            log.debug("DlgcMediaSessionProxy::createMediaMixer XMS configuration");
        }
        if (predefConf != null) {
            log.debug("DlgcMediaSessionProxy::createMediaMixer predefConf is :" + predefConf.toString());
        } else {
            log.debug("DlgcMediaSessionProxy::createMediaMixer predefConf is NULL");
        }
        return this.createMediaMixer((MediaConfig)predefConf, Parameters.NO_PARAMETER);
    }

    public MediaMixer createMediaMixer(Configuration<MediaMixer> conf, Parameters params) throws MsControlException {
        Object predefConf = null;
        String msType = (String)this.getAttribute("MSTYPE");
        log.debug("DlgcMediaSessionProxy::createMediaMixer with Params conf: " + conf.toString());
        if (null != msType && msType.equalsIgnoreCase("IPMS")) {
            predefConf = DlgcMediaConfig.getContainerSupportedConfiguration(conf);
            log.debug("DlgcMediaSessionProxy::createMediaMixer with Params IPMS configuration");
        } else {
            predefConf = DlgcXMediaConfig.getContainerSupportedConfiguration(conf);
            log.debug("DlgcMediaSessionProxy::createMediaMixer with Params XMS configuration");
        }
        if (predefConf != null) {
            log.debug("DlgcMediaSessionProxy::createMediaMixer with Params predefConf is :" + predefConf.toString());
        } else {
            log.debug("DlgcMediaSessionProxy::createMediaMixer with Params predefConf is NULL");
        }
        return this.createMediaMixer((MediaConfig)predefConf, params);
    }

    public MediaMixer createMediaMixer(MediaConfig mConfig, Parameters params) throws MsControlException {
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        String mediaId = this.getMsObjectId();
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcMediaMixer mx = (DlgcMediaMixer)session.createMediaMixer(mConfig, params);
            appSession.setAttribute(session.getMediaObject(), (Object)session);
            DlgcMediaMixerProxy mxProxy = mx.getProxy();
            return mxProxy;
        }
        catch (Exception e) {
            log.error("Failed to create MediaMixer", (Throwable)e);
            throw new MsControlException("Failed to create MediaMixer", (Throwable)e);
        }
    }

    public NetworkConnection createNetworkConnection(Configuration<NetworkConnection> conf) throws MsControlException {
        Object predefConf = null;
        String msType = (String)this.getAttribute("MSTYPE");
        if (null != msType && msType.equalsIgnoreCase("IPMS")) {
            predefConf = DlgcMediaConfig.getContainerSupportedConfiguration(conf);
        } else {
            if (conf == null) {
                throw new MsControlException("Cannot create createNetworkConnection MediaConfig parameter are null");
            }
            predefConf = DlgcXMediaConfig.getContainerSupportedConfiguration(conf);
        }
        return this.createNetworkConnection((MediaConfig)predefConf, Parameters.NO_PARAMETER);
    }

    public NetworkConnection createNetworkConnection(Configuration<NetworkConnection> conf, Parameters params) throws MsControlException {
        return this.createNetworkConnection(DlgcXMediaConfig.getContainerSupportedConfiguration(conf), params);
    }

    public NetworkConnection createNetworkConnection(MediaConfig conf, Parameters params) throws MsControlException {
        NetworkConnection nc = null;
        if (this.sasId != null) {
            log.debug("DlgcMediaSessionProxy createNetworkConnection sasID = " + this.sasId);
        } else {
            log.debug("DlgcMediaSessionProxy createNetworkConnection sasID = null");
        }
        if (DlgcMsControlFactory.ConnectorSipMode == DlgcMsControlFactory.CONNECTOR_SIP_MODE.SERVLET) {
            log.debug("DlgcMediaSessionProxy createNetworkConnection using SERVLET MODE");
            nc = this.createNetworkConnectionUsingServlet(conf, params);
        } else {
            log.debug("DlgcMediaSessionProxy createNetworkConnection using STANDALONE MODE");
            nc = this.createNetworkConnectionUsingStandalone(conf, params);
        }
        return nc;
    }

    public NetworkConnection createNetworkConnectionUsingServlet(MediaConfig conf, Parameters params) throws MsControlException {
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        String mediaId = this.getMsObjectId();
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            DlgcNetworkConnection nc = (DlgcNetworkConnection)session.createNetworkConnection(conf, params);
            appSession.setAttribute(session.getMediaObject(), (Object)session);
            DlgcNetworkConnectionProxy ncProxy = (DlgcNetworkConnectionProxy)nc.getProxy();
            log.debug("DlgcMediaSessionProxy createNetworkConnection: NetworkConnection OBJID: " + nc.toString());
            log.debug("DlgcMediaSessionProxy createNetworkConnection: PROXY NetworkConnection OBJID: " + ncProxy.toString());
            return ncProxy;
        }
        catch (Exception e) {
            log.error("Failed to create Network Connection", (Throwable)e);
            throw new MsControlException("Failed to create Network Connection", (Throwable)e);
        }
    }

    public NetworkConnection createNetworkConnectionUsingStandalone(MediaConfig conf, Parameters params) throws MsControlException {
        DlgcMediaSession session = (DlgcMediaSession)this.getStandaloneObject();
        DlgcNetworkConnection nc = (DlgcNetworkConnection)session.createNetworkConnection(conf, params);
        DlgcNetworkConnectionProxy ncProxy = (DlgcNetworkConnectionProxy)nc.getProxy();
        ncProxy.setStandaloneObject(nc);
        log.debug("DlgcMediaSessionProxy createNetworkConnection: NetworkConnection OBJID: " + nc.toString());
        log.debug("DlgcMediaSessionProxy createNetworkConnection: PROXY NetworkConnection OBJID: " + ncProxy.toString());
        return ncProxy;
    }

    public VxmlDialog createVxmlDialog(Parameters params) throws MsControlException {
        throw new MsControlException("Vxml Dialog Creation not supported with this release");
    }

    public Object getAttribute(String attrName) {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        Object obj = null;
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            obj = session.getAttribute(attrName);
        }
        catch (Exception e) {
            log.error("Failed to getAttribute", (Throwable)e);
        }
        return obj;
    }

    public Iterator<String> getAttributeNames() {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        Iterator<String> it = null;
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            it = session.getAttributeNames();
        }
        catch (Exception e) {
            log.error("Failed to getAttributeNames", (Throwable)e);
        }
        return it;
    }

    public void removeAttribute(String attrName) {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            session.removeAttribute(attrName);
            appSession.setAttribute(mediaId, (Object)session);
        }
        catch (Exception e) {
            log.error("Failed to removeAttribute", (Throwable)e);
        }
    }

    public void setAttribute(String attrName, Object attrVal) {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            session.setAttribute(attrName, attrVal);
            appSession.setAttribute(mediaId, (Object)session);
        }
        catch (Exception e) {
            log.error("Failed to setAttribute", (Throwable)e);
        }
    }

    public Parameters createParameters() {
        return new DlgcParameters();
    }

    public Iterator<MediaObject> getMediaObjects() {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        Iterator<MediaObject> it = null;
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            it = session.getMediaObjects();
        }
        catch (Exception e) {
            log.error("Failed to getMediaObjects", (Throwable)e);
        }
        return it;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> arg) {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        Iterator<T> it = null;
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            it = session.getMediaObjects(arg);
        }
        catch (Exception e) {
            log.error("Failed to getMediaObjects With Argument", (Throwable)e);
        }
        return it;
    }

    public Parameters getParameters(Parameter[] params) {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        Parameters p = null;
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            p = session.getParameters(params);
        }
        catch (Exception e) {
            log.error("Failed to getParameters", (Throwable)e);
        }
        return p;
    }

    public URI getURI() {
        String mediaId = this.getMsObjectId();
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        URI uri = null;
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            uri = session.getURI();
        }
        catch (Exception e) {
            log.error("Failed to getURI", (Throwable)e);
        }
        return uri;
    }

    public void release() {
        log.debug("Entering SYNC_2_ASYNC DlgcMediaSessionProxy::release.");
        this.releaseAsync();
        log.debug("Leaving SYNC_2_ASYNC DlgcMediaSessionProxy::release.");
    }

    protected void releaseAsync() {
        final String mediaId = this.getMsObjectId();
        String sasId = this.getProxyId();
        DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
        final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("Media Session:Release Request");
        try {
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                        session.setMonitor(monitor);
                    }
                    session.setRequestTypeToProxy();
                    session.release();
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to release", (Throwable)e);
        }
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("SYNC_2_ASYNC DlgcMediaSessionProxy::release calling monitor.waitForRequestCompletion() ");
            monitor.waitForRequestCompletion();
            this.invalidateEachNCs(session);
            log.debug("SYNC_2_ASYNC DlgcMediaSessionProxy::release returned from monitor.waitForRequestCompletion():  " + monitor.getStatusString());
        }
    }

    private void invalidateEachNCs(DlgcMediaSession session) {
        int listTotalSize = session.mediaObjectList.size();
        log.debug("SYNC_2_ASYNC DlgcXMediaSessionProxy::invalidateEachNCs() number of object: " + new Integer(listTotalSize).toString());
        SipApplicationSession sas = session.getSAS();
        if (sas != null && sas.isValid()) {
            sas.setExpires(1);
            log.debug("SYNC_2_ASYNC DlgcMediaSessionProxy::invalidateEachNCs: SAS Set Expiration to 1 minute: " + sas.toString());
        }
        session.mediaObjectList.clear();
        SipApplicationSession myAppSAS = session.getAppSAS();
        if (myAppSAS != null && myAppSAS != null && myAppSAS.isValid()) {
            log.debug("SYNC_2_ASYNC DlgcMediaSessionProxy::invalidateEachNCs: Application Side SAS Set Expiration to 1 minute: " + myAppSAS.toString());
            myAppSAS.setExpires(1);
        }
        log.debug("SYNC_2_ASYNC Leaving DlgcXMediaSessionProxy::invalidateEachNCs()");
    }

    public void setParameters(Parameters params) {
        SipApplicationSession appSession = this.getProxySAS(this.sasId);
        String mediaId = this.getMsObjectId();
        try {
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            session.setParameters(params);
            appSession.setAttribute(mediaId, (Object)session);
        }
        catch (Exception e) {
            log.error("Failed to setParameters", (Throwable)e);
        }
    }
}

