/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaObject;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSessionProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import commonj.work.Work;
import commonj.work.WorkItem;
import commonj.work.WorkManager;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.WrongStateException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.vxml.VxmlDialog;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import org.mobicents.javax.servlet.sip.SipFactoryExt;
import org.mobicents.javax.servlet.sip.SipSessionsUtilExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaSession
extends DlgcMediaObject
implements MediaSession,
Serializable {
    public static final String APP_LOG_CALL_ID_NAME = "APP_CALL_ID";
    public static final String APP_LOG_CALL_ID_DEF_VAL = "APP-ID-0";
    private static final String APP_SASID = "APP_SASID";
    private static final long serialVersionUID = 139393L;
    private static final int DEFAULT_MS_TIMEOUT = 10000;
    private DlgcAsynDispatcher asyncDispatcher = null;
    public boolean test = false;
    protected Integer msTimeout;
    protected String proxyId;
    protected transient SipApplicationSession mySipAppSession = null;
    private static DlgcParameters supportedParameters;
    private static Logger log;
    protected DlgcMsControlFactory msFactory;
    protected Map<String, Object> msAttributes;
    DlgcMediaServer myMediaServer;
    protected Map<String, MediaObject> mediaObjectByProxyIdMap;
    protected Map<String, String> mediaObjectIdMap;
    DlgcSync2AsyncMonitor monitor = null;
    private String appSasId;
    private String DLG_PLAY_DIRECTION_ATTR_ID = "DLG_PLAY_DIRECTION";
    private String PLAY_DIRECTION_CALL_LEG_VAL_ID = "CALL_LEG_DIR";
    private String PLAY_DIRECTION_CONFERENCE_VAL_ID = "CONFERENCE_DIR";
    private PLAY_DIRECTION_ENUM playDirectionAttributeEnumVal;

    public DlgcAsynDispatcher getAsyncDispatcher() {
        return this.asyncDispatcher;
    }

    public void setAsyncDispatcher(DlgcAsynDispatcher asyncDispatcher) {
        this.asyncDispatcher = asyncDispatcher;
    }

    public AsyncRequestType getRequestType() {
        AsyncRequestType requestType = (AsyncRequestType)((Object)this.getAttribute("ASYNC_REQUEST_TYPE"));
        return requestType;
    }

    public void setRequestType(AsyncRequestType rt) {
        this.setAttribute("ASYNC_REQUEST_TYPE", (Object)rt);
    }

    public void setRequestTypeToProxy() {
        this.setAttribute("ASYNC_REQUEST_TYPE", (Object)AsyncRequestType.CONNECTOR_PROXY_SOURCE);
    }

    public void setRequestTypeToServlet() {
        this.setAttribute("ASYNC_REQUEST_TYPE", (Object)AsyncRequestType.CONNECTOR_SERVLET_SOURCE);
    }

    public DlgcMediaSession() {
        this.msAttributes.put("BRIDGE_MODE", "AUDIO");
        this.msAttributes.put("CONFERENCE_MODE", "AUDIO_VIDEO");
        this.setAttribute("ASYNC_REQUEST_TYPE", (Object)AsyncRequestType.CONNECTOR_SERVLET_SOURCE);
        this.playDirectionAttributeEnumVal = PLAY_DIRECTION_ENUM.CALL_LEG_DIR;
    }

    protected DlgcMediaSession(MsControlFactory factory) {
        super("MS-");
        this.msFactory = (DlgcMsControlFactory)factory;
        this.buildUri(this.getClass().getName());
        this.parameters.put(TIMEOUT, 10000);
        this.msTimeout = new Integer(10000);
        this.msAttributes = new HashMap<String, Object>();
        this.mediaObjectByProxyIdMap = new HashMap<String, MediaObject>();
        this.mediaObjectIdMap = new HashMap<String, String>();
        this.proxyId = null;
        this.asyncDispatcher = DlgcMsControlFactory.asynDispatcher;
        if (DlgcMsControlFactory.ConnectorSipMode == DlgcMsControlFactory.CONNECTOR_SIP_MODE.SERVLET) {
            log.debug("DlgcMediaSession::CTOR  creating SAS for Async API since we are in SERVLET MODE");
            this.createSASForListenerSyncApi();
        } else {
            this.appSasId = null;
            log.debug("DlgcMediaSession::CTOR not creating SAS for Async API since we are in STANDALONE MODE");
        }
        this.playDirectionAttributeEnumVal = PLAY_DIRECTION_ENUM.CALL_LEG_DIR;
    }

    public Integer getTimeout() {
        return this.msTimeout;
    }

    public String getAppCallLogId() {
        String appCallId = (String)this.getAttribute(APP_LOG_CALL_ID_NAME);
        if (appCallId == null) {
            appCallId = APP_LOG_CALL_ID_DEF_VAL;
        }
        return appCallId;
    }

    public MediaGroup createMediaGroup(Configuration<MediaGroup> preConfig) throws MsControlException {
        return this.createMediaGroup(preConfig, Parameters.NO_PARAMETER);
    }

    public MediaGroup createMediaGroup(Configuration<MediaGroup> preConfig, Parameters params) throws MsControlException {
        MediaConfig predefConf = this.msFactory.getMediaConfig(preConfig);
        return this.createMediaGroup(predefConf, params);
    }

    public MediaGroup createMediaGroup(MediaConfig config, Parameters params) throws MsControlException {
        DlgcMediaGroup mg = null;
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        if (config == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        mg = new DlgcMediaGroup(config, this, params);
        this.addMediaObject(mg);
        this.mediaObjectByProxyIdMap.put(mg.getProxyId(), mg);
        return mg;
    }

    public MediaMixer createMediaMixer(Configuration<MediaMixer> preConfig) throws MsControlException {
        return this.createMediaMixer(preConfig, Parameters.NO_PARAMETER);
    }

    public MediaMixer createMediaMixer(Configuration<MediaMixer> preConfig, Parameters params) throws MsControlException {
        MediaConfig predefConf = this.msFactory.getMediaConfig(preConfig);
        return this.createMediaMixer(predefConf, params);
    }

    public MediaMixer createMediaMixer(MediaConfig config, Parameters params) throws MsControlException {
        DlgcMediaMixer mx = null;
        if (this.released) {
            throw new WrongStateException("This MediaSession has been released");
        }
        if (config == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        mx = new DlgcMediaMixer(config, (MediaSession)this, params);
        this.addMediaObject(mx);
        this.mediaObjectByProxyIdMap.put(mx.getProxyId(), mx);
        return mx;
    }

    public NetworkConnection createNetworkConnection(Configuration<NetworkConnection> config) throws MsControlException {
        return this.createNetworkConnection(config, Parameters.NO_PARAMETER);
    }

    public NetworkConnection createNetworkConnection(Configuration<NetworkConnection> preConfig, Parameters params) throws MsControlException {
        MediaConfig predefConf = this.msFactory.getMediaConfig(preConfig);
        return this.createNetworkConnection(predefConf, params);
    }

    public NetworkConnection createNetworkConnection(MediaConfig config, Parameters params) throws MsControlException {
        DlgcNetworkConnection nc = null;
        if (this.released) {
            throw new WrongStateException("This MediaSession has been rele msFactory.SetMediaSessionURI(this.getURI());ased");
        }
        if (config == null) {
            throw new MsControlException("MediaConfig parameter cannot be null");
        }
        nc = new DlgcNetworkConnection(config, this, params);
        this.addMediaObject(nc);
        this.mediaObjectByProxyIdMap.put(nc.getProxyId(), nc);
        return nc;
    }

    @Override
    public void release() {
        if (!this.released) {
            log.warn(this.getAppCallLogId() + "- DlgcMediaSession:release() Releasing resources");
            DlgcMediaSessionProxy proxy = this.getProxy();
            SipApplicationSession sas = proxy.getProxySAS();
            if (sas != null) {
                if (sas.isValid()) {
                    super.release();
                    log.warn(this.getAppCallLogId() + " - DlgcMediaSession:release() Releasing resources DONE");
                } else {
                    log.warn(this.getAppCallLogId() + " - Cant Invalidate SipApplicationSession during MediaSession release because is already invalid.");
                }
            } else {
                log.warn(this.getAppCallLogId() + " - Cant Invalidate SipApplicationSession during MediaSession release because SAS is null ie not found.");
            }
        }
    }

    public void setMonitor(DlgcSync2AsyncMonitor mon) {
        this.monitor = mon;
    }

    public DlgcSync2AsyncMonitor getMonitor() {
        return this.monitor;
    }

    public VxmlDialog createVxmlDialog(Parameters arg0) throws MsControlException {
        throw new MsControlException(this.getAppCallLogId() + " - Vxml Dialog Creation not supported with this release");
    }

    public Object getAttribute(String attrName) {
        return this.msAttributes.get(attrName);
    }

    public Iterator<String> getAttributeNames() {
        Set<String> s = this.msAttributes.keySet();
        Iterator<String> its = s.iterator();
        return its;
    }

    public void removeAttribute(String attrName) {
        this.msAttributes.remove(attrName);
    }

    public void setAttribute(String attrName, Object attrValue) {
        if (attrName.equalsIgnoreCase(this.DLG_PLAY_DIRECTION_ATTR_ID) && attrValue instanceof String) {
            String val = (String)attrValue;
            log.debug("DlgcMediaSession::setAttribute User has set attributeName: " + this.DLG_PLAY_DIRECTION_ATTR_ID + " Value: " + val);
            if (val.equalsIgnoreCase(this.PLAY_DIRECTION_CALL_LEG_VAL_ID)) {
                log.debug("DlgcMediaSession::setAttribute setting attribute: " + attrName + " to valid value: " + val);
                this.playDirectionAttributeEnumVal = PLAY_DIRECTION_ENUM.CALL_LEG_DIR;
            } else if (val.equalsIgnoreCase(this.PLAY_DIRECTION_CONFERENCE_VAL_ID)) {
                log.debug("DlgcMediaSession::setAttribute setting attribute: " + attrName + " to valid value: " + val);
                this.playDirectionAttributeEnumVal = PLAY_DIRECTION_ENUM.CONFERENCE_DIR;
            } else {
                log.warn("DlgcMediaSession::setAttribute setting attribute: " + attrName + " to invalid value: " + val);
            }
        }
        this.msAttributes.put(attrName, attrValue);
    }

    public String getAppSasId() {
        return this.appSasId;
    }

    protected void createSASForListenerSyncApiForOccas() {
        try {
            log.debug("Entering DlgcXMsControlFactory::createSASForListenerSyncApiForOccas");
            WorkManager aWorkMgr = DlgcSipServlet.wManager;
            WorkItem wItem = aWorkMgr.schedule((Work)new OccasMediaSessionWork());
            if (wItem == null) {
                log.error("DlgcXMsControlFactory::createSASForListenerSyncApiForOccas: error creating SAS using Work Manager.. Work Item is Null");
            }
            log.debug("DlgcXMsControlFactory::createSASForListenerSyncApiForOccas: waiting for thread to finish creating the SAS");
            aWorkMgr.waitForAll(Arrays.asList(wItem), 5000L);
            log.debug("DlgcXMsControlFactory::createSASForListenerSyncApiForOccas: Returning from waiting for thread to finish creating the SAS");
        }
        catch (Exception e) {
            log.error("Failed to create Media Session", (Throwable)e);
        }
    }

    protected void createSASForListenerSyncApiForOccas7() {
        try {
            log.debug("Entering DlgcXMsControlFactory::createSASForListenerSyncApiForOccas");
            WorkManager aWorkMgr = DlgcSipServlet.wManager;
            WorkItem wItem = aWorkMgr.schedule((Work)new OccasMediaSessionWork());
            if (wItem == null) {
                log.error("DlgcXMsControlFactory::createSASForListenerSyncApiForOccas: error creating SAS using Work Manager.. Work Item is Null");
            }
            log.debug("DlgcXMsControlFactory::createSASForListenerSyncApiForOccas: waiting for thread to finish creating the SAS");
            aWorkMgr.waitForAll(Arrays.asList(wItem), 5000L);
            log.debug("DlgcXMsControlFactory::createSASForListenerSyncApiForOccas: Returning from waiting for thread to finish creating the SAS");
        }
        catch (Exception e) {
            log.error("Failed to create Media Session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSASForListenerSyncApi() {
        SipApplicationSession appSession;
        SipFactoryExt f;
        String platform = DlgcSipServlet.getASPlatform();
        log.debug("DlgcMediaSession::createSASForListenerSyncApi():  platform: " + platform);
        if (platform.equalsIgnoreCase("TELESTAX") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            try {
                log.debug("SYNC_2_ASYNC DlgcMediaSession::createSASForListenerSyncApi for TELESTAX_PLATFORM");
                f = (SipFactoryExt)DlgcSipServlet.getSipFactory();
                appSession = f.createApplicationSession(false);
                this.appSasId = appSession.getId();
                log.debug("SYNC_2_ASYNC DlgcMediaSession:createSASForListenerSyncApi:: SASID: " + this.appSasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
            }
            catch (Exception e) {
                log.error("SYNC_2_ASYNC Failed to create Media Session", (Throwable)e);
            }
        }
        if (platform.equalsIgnoreCase("TELESTAX") && !DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("SYNC_2_ASYNC DlgcMediaSession::createSASForListenerSyncApi (Asynchronous Mode) for TELESTAX_PLATFORM");
            f = DlgcSipServlet.getSipFactory();
            appSession = f.createApplicationSession();
            this.appSasId = appSession.getId();
            log.debug("SYNC_2_ASYNC DlgcMediaSession:createSASForListenerSyncApi (Asynchronous):: SASID: " + this.appSasId);
            appSession.setExpires(0);
            appSession.setInvalidateWhenReady(false);
        } else if (platform.equalsIgnoreCase("IBM") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            try {
                log.debug("SYNC_2_ASYNC DlgcMediaSession::createSASForListenerSyncApi for IBM LIBERTRY PLATFORM");
                f = DlgcSipServlet.getSipFactory();
                appSession = f.createApplicationSession();
                this.appSasId = appSession.getId();
                log.debug("SYNC_2_ASYNC DlgcMediaSession:createSASForListenerSyncApi:: SASID: " + this.appSasId);
                appSession.setExpires(0);
                appSession.setInvalidateWhenReady(false);
            }
            catch (Exception e) {
                log.error("SYNC_2_ASYNC Failed to create Media Session", (Throwable)e);
            }
        } else if (platform.equalsIgnoreCase("OCCAS5") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("SYNC_2_ASYNC DlgcMediaSession::createSASForListenerSyncApi for ORACLE5_PLATFORM");
            this.createSASForListenerSyncApiForOccas();
        } else if (platform.equalsIgnoreCase("OCCAS7") && DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
            log.debug("SYNC_2_ASYNC DlgcMediaSession::createSASForListenerSyncApi for ORACLE7_PLATFORM");
            try {
                InitialContext context = new InitialContext();
                occas7SASTask createSASTask = new occas7SASTask();
                ManagedExecutorService executor = (ManagedExecutorService)context.lookup("java:comp/ManagedSipExecutorService");
                Future f2 = executor.submit((Runnable)createSASTask);
                try {
                    f2.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
                finally {
                    context.close();
                }
            }
            catch (NamingException ex) {
                log.error(ex.toString());
            }
        }
    }

    @Override
    protected void buildUri(String container) {
        try {
            String uriString = "mscontrol://" + InetAddress.getLocalHost().getHostAddress() + "/" + container + "." + this.mediaObjectID;
            this.uri = new URI(uriString);
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
    }

    @Override
    public void setParameters(Parameters params) {
        for (Parameter param : params.keySet()) {
            if (!this.parameters.containsKey(param)) continue;
            this.parameters.put(param, params.get((Object)param));
            if (param != MediaSession.TIMEOUT) continue;
            this.msTimeout = (Integer)params.get((Object)param);
        }
    }

    protected void buildUriWIthSasID(String sasId) {
        try {
            int index = sasId.indexOf(64);
            String newsasId = sasId.replace('|', '_');
            String uriString = null;
            uriString = "mscontrol://" + InetAddress.getLocalHost().getHostAddress() + "/" + newsasId + "." + this.mediaObjectID;
            this.uri = new URI(uriString);
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
    }

    public MsControlFactory getFactory() {
        return this.msFactory;
    }

    public static DlgcParameters loadSupportedParameters() {
        return supportedParameters;
    }

    public SipSession getUserAgentSession() {
        SipSession session = null;
        session = (SipSession)this.msAttributes.get("SIP_SESSION");
        return session;
    }

    public void setMediaServer(DlgcMediaServer mediaServer) {
        this.myMediaServer = mediaServer;
    }

    public DlgcMediaServer getMediaServer() {
        return this.myMediaServer;
    }

    public DlgcMediaSessionProxy getProxy() {
        String sid = this.getProxyId();
        log.debug(this.getAppCallLogId() + " - MediaSession getProxy sasId = " + sid);
        return new DlgcMediaSessionProxy(this.getProxyId(), this.getMediaObject());
    }

    public MediaObject getMediaObjectByProxyId(String proxId) {
        return this.mediaObjectByProxyIdMap.get(proxId);
    }

    public void removeMediaObjectByProxyId(String proxId) {
        this.mediaObjectByProxyIdMap.remove(proxId);
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(String id) {
        this.proxyId = id;
        if (this.proxyId != null) {
            log.debug(this.getAppCallLogId() + " - DlgcMediaSession:: setPRoxyID sasID = " + this.proxyId);
        } else {
            log.debug(this.getAppCallLogId() + " - DlgcMediaSession:: setPRoxyID sasID = null ");
        }
        this.buildUriWIthSasID(id);
    }

    public SipApplicationSession getSAS() {
        SipApplicationSession mySipAppSession = null;
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("TELESTAX")) {
            SipSessionsUtilExt ssuE = (SipSessionsUtilExt)DlgcSipServlet.getSSU();
            mySipAppSession = ssuE.getApplicationSessionById(this.proxyId, false);
        } else {
            mySipAppSession = DlgcSipServlet.getSSU().getApplicationSessionById(this.proxyId);
            if (mySipAppSession != null) {
                log.debug("DlgcMediaSession::getSAS():: sas= " + mySipAppSession.toString());
            } else {
                log.debug("DlgcMediaSession::getSAS():: sas= NULL");
            }
        }
        return mySipAppSession;
    }

    public SipApplicationSession getAppSAS() {
        SipApplicationSession mySipAppSession = null;
        if (DlgcInstrumentPropertyMgr.bSync309ApiSupport && DlgcSipServlet.APP_SERVER_PLATFORM.equalsIgnoreCase("TELESTAX")) {
            SipSessionsUtilExt ssuE = (SipSessionsUtilExt)DlgcSipServlet.getSSU();
            mySipAppSession = ssuE.getApplicationSessionById(this.appSasId, false);
        } else if (this.appSasId != null) {
            mySipAppSession = DlgcSipServlet.getSSU().getApplicationSessionById(this.appSasId);
            if (mySipAppSession != null) {
                log.debug("DlgcMediaSession::getAppSAS():: sas= " + mySipAppSession.toString());
            } else {
                log.debug("DlgcMediaSession::getAppSAS():: sas= NULL");
            }
        }
        return mySipAppSession;
    }

    public Map<String, MediaObject> getProxyIdMap() {
        return this.mediaObjectByProxyIdMap;
    }

    public PLAY_DIRECTION_ENUM getPlayDirectionAttribute() {
        return this.playDirectionAttributeEnumVal;
    }

    static {
        log = LoggerFactory.getLogger(DlgcMediaSession.class);
        supportedParameters = new DlgcParameters();
    }

    public static enum PLAY_DIRECTION_ENUM {
        CALL_LEG_DIR,
        CONFERENCE_DIR;

    }

    private class OccasMediaSessionWork
    implements Work {
        private OccasMediaSessionWork() {
        }

        public boolean isDaemon() {
            return false;
        }

        public void release() {
        }

        public void run() {
            log.debug("Entering DlgcXMsControlFactory::run");
            log.debug("SYNC_2_ASYNC DlgcMediaSession::createSASForListenerSyncApi for OCCAS_PLATFORM");
            SipApplicationSession appSession = DlgcSipServlet.getSipFactory().createApplicationSession();
            DlgcMediaSession.this.appSasId = appSession.getId();
            log.debug("DlgcMsControlFactory:createMediaSessionGeneral::CreateMediaSessionAction(response): SASID: " + DlgcMediaSession.this.appSasId);
            appSession.setExpires(0);
            appSession.setInvalidateWhenReady(false);
            log.debug("XMsControlFactory::DlgcXMsControlFactory run thread created sasId = " + DlgcMediaSession.this.appSasId);
            log.debug("Leaving DlgcXMsControlFactory::run");
        }
    }

    class occas7SASTask
    implements Runnable,
    ManagedTask,
    Serializable {
        private static final long serialVersionUID = 1L;

        occas7SASTask() {
        }

        public Map<String, String> getExecutionProperties() {
            return null;
        }

        public ManagedTaskListener getManagedTaskListener() {
            return null;
        }

        @Override
        public void run() {
            log.debug("Entering occas7SASTask::run create new internal SAS");
            log.debug("SYNC_2_ASYNC occas7SASTask for OCCAS7_PLATFORM");
            SipApplicationSession appSession = DlgcSipServlet.getSipFactory().createApplicationSession();
            DlgcMediaSession.this.appSasId = appSession.getId();
            appSession.setExpires(0);
            appSession.setInvalidateWhenReady(false);
            log.debug("occas7SASTask run thread created sasId = " + DlgcMediaSession.this.appSasId);
            log.debug("Leaving occas7SASTask in work thread creating SAS");
        }
    }

    public static enum AsyncRequestType {
        CONNECTOR_PROXY_SOURCE,
        CONNECTOR_SERVLET_SOURCE;

    }
}

