/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcParameters;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcMediaObject
implements MediaObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcMediaObject.class);
    protected String mediaObjectID;
    protected URI uri;
    protected List<MediaObject> mediaObjectList = new ArrayList<MediaObject>();
    protected DlgcParameters parameters = new DlgcParameters();
    protected boolean released = false;

    public DlgcMediaObject() {
    }

    public DlgcMediaObject(String prefix) {
        this.mediaObjectID = prefix + Long.toHexString(System.nanoTime());
        this.parameters.put(MEDIAOBJECT_ID, this.mediaObjectID);
    }

    public String getMediaObject() {
        return this.mediaObjectID;
    }

    public Parameters createParameters() {
        return new DlgcParameters();
    }

    public Iterator<MediaObject> getMediaObjects() {
        return this.getMediaObjects(MediaObject.class);
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> classType) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (DlgcMediaObject dlgcMediaObject : this.mediaObjectList) {
            if (!classType.isInstance(dlgcMediaObject) || dlgcMediaObject.released) continue;
            filteredList.add(classType.cast(dlgcMediaObject));
        }
        return Collections.unmodifiableList(filteredList).iterator();
    }

    public Parameters getParameters(Parameter[] paramArray) {
        DlgcParameters params = new DlgcParameters();
        if (paramArray == null) {
            params.putAll(this.parameters);
        } else {
            for (Parameter p : paramArray) {
                if (!this.parameters.containsKey(p)) continue;
                params.put(p, this.parameters.get(p));
            }
        }
        return params;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isReleased() {
        return this.released;
    }

    private void releaseYourChildren() {
        log.debug("Entering DlgcMediaObject::releaseYourChildren() for ID: " + this.getMediaObject());
        Iterator<MediaObject> iter = this.mediaObjectList.iterator();
        DlgcMediaObject mo = null;
        while (iter.hasNext()) {
            mo = (DlgcMediaObject)iter.next();
            log.debug(" DlgcMediaObject::releaseYourChildren - calling mo.release() for MOID: " + mo.getMediaObject());
            mo.release();
            try {
                iter.remove();
            }
            catch (Exception exception) {}
        }
        log.debug("Leaving DlgcMediaObject::releaseYourChildren() for ID: " + this.getMediaObject());
    }

    public void release() {
        Iterator<MediaObject> myListOfObjectIT = this.mediaObjectList.iterator();
        Object mixer = null;
        String mID = this.mediaObjectID;
        log.debug("Entering DlgcMediaObject::release() for ID : " + mID);
        this.releaseYourChildren();
        this.released = true;
        log.debug("Leaving DlgcMediaObject::release() for ID : " + mID);
    }

    public void setDefaultParameters(Parameters params) {
        this.parameters.putAll(params);
    }

    public void setParameters(Parameters params) {
        for (Parameter param : params.keySet()) {
            if (!this.parameters.containsKey(param)) continue;
            this.parameters.put(param, params.get((Object)param));
        }
    }

    protected void addMediaObject(MediaObject object) {
        this.mediaObjectList.add(object);
    }

    public void removeMediaObject(MediaObject object) {
        this.mediaObjectList.remove(object);
    }

    protected abstract void buildUri(String var1);
}

