/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol;

import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.msmlProtocol.DlgcMsmlProtocolMessageMappingAssistance;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import java.io.Serializable;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcMediaEvent<S>
implements MediaEvent<S>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcMediaEvent.class);
    protected final S source;
    protected EventType eventType;
    protected MediaErr error;
    protected String errorText = "NO ERROR";
    protected String reason;

    public DlgcMediaEvent(EventType eventType, S source) {
        if (eventType == null) {
            // empty if block
        }
        this.source = source;
        this.eventType = eventType;
        this.error = NO_ERROR;
        this.errorText = "NO ERROR";
        this.reason = "Not_found";
    }

    public DlgcMediaEvent(MsmlDocument.Msml message, S source) {
        this.error = NO_ERROR;
        this.errorText = "NO ERROR";
        this.reason = "Not_found";
        this.source = source;
        if (message == null) {
            return;
        }
        MsmlDocument.Msml.Event msmlEvent = message.getEvent();
        String eventName = new String("INFO_ERROR");
        if (msmlEvent != null) {
            eventName = msmlEvent.getName2();
        }
        this.eventType = DlgcMsmlProtocolMessageMappingAssistance.translateEventType(source.getClass(), eventName);
        if (this.eventType == null) {
            // empty if block
        }
    }

    public DlgcMediaEvent(S source) {
        this.source = source;
    }

    public MediaErr getError() {
        return this.error;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public S getSource() {
        DlgcProxy prox = null;
        if (this.source instanceof DlgcResource) {
            DlgcResource res = (DlgcResource)this.source;
            prox = res.getProxy();
        } else if (this.source instanceof DlgcResourceContainer) {
            prox = ((DlgcResourceContainer)this.source).getProxy();
        }
        return (S)prox;
    }

    public boolean isSuccessful() {
        return this.error == NO_ERROR;
    }

    public void setEventType(EventType type) {
        this.eventType = type;
    }

    public void setError(MediaErr mErr) {
        this.error = mErr;
    }

    public void setErrorText(String s) {
        this.errorText = s;
    }
}

