/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class XMLParserActivator
implements BundleActivator,
ServiceFactory {
    private volatile BundleContext context;
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String PARSERCLASSFILEPATH = "/META-INF/services/";
    public static final String SAXCLASSFILE = "/META-INF/services/javax.xml.parsers.SAXParserFactory";
    public static final String DOMCLASSFILE = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAXFACTORYDESCRIPTION = "A JAXP Compliant SAX Parser";
    private static final String DOMFACTORYDESCRIPTION = "A JAXP Compliant DOM Parser";
    public static final String PARSER_VALIDATING = "parser.validating";
    public static final String PARSER_NAMESPACEAWARE = "parser.namespaceAware";
    private static final String FACTORYNAMEKEY = "parser.factoryname";

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Bundle parserBundle = context.getBundle();
        this.registerSAXParsers(this.getParserFactoryClassNames(this.getResourceURL(parserBundle, SAXCLASSFILE)));
        this.registerDOMParsers(this.getParserFactoryClassNames(this.getResourceURL(parserBundle, DOMCLASSFILE)));
    }

    protected URL getResourceURL(Bundle parserBundle, String resname) {
        return parserBundle.getResource(resname);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private List getParserFactoryClassNames(URL parserUrl) throws IOException {
        if (parserUrl == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> v = new ArrayList<String>(1);
        String parserFactoryClassName = null;
        InputStream is = parserUrl.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((parserFactoryClassName = br.readLine()) != null) {
            int commentIdx;
            String pfcName = parserFactoryClassName.trim();
            if (pfcName.length() == 0 || (commentIdx = pfcName.indexOf("#")) == 0) continue;
            if (commentIdx < 0) {
                v.add(pfcName);
                continue;
            }
            v.add(pfcName.substring(0, commentIdx).trim());
        }
        return v;
    }

    private void registerSAXParsers(List parserFactoryClassNames) throws FactoryConfigurationError {
        Iterator e = parserFactoryClassNames.iterator();
        int index = 0;
        while (e.hasNext()) {
            String parserFactoryClassName = (String)e.next();
            SAXParserFactory factory = (SAXParserFactory)this.getFactory(parserFactoryClassName);
            Hashtable<String, String> properties = new Hashtable<String, String>(7);
            this.setDefaultSAXProperties(factory, properties, index);
            properties.put(FACTORYNAMEKEY, parserFactoryClassName);
            this.context.registerService(SAXFACTORYNAME, (Object)this, properties);
            ++index;
        }
    }

    private void setDefaultSAXProperties(SAXParserFactory factory, Hashtable props, int index) {
        props.put("service.description", SAXFACTORYDESCRIPTION);
        props.put("service.pid", "javax.xml.parsers.SAXParserFactory." + this.context.getBundle().getBundleId() + "." + index);
        this.setSAXProperties(factory, props);
    }

    public void setSAXProperties(SAXParserFactory factory, Hashtable properties) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        properties.put(PARSER_NAMESPACEAWARE, new Boolean(namespaceaware));
        properties.put(PARSER_VALIDATING, new Boolean(validating));
    }

    private void registerDOMParsers(List parserFactoryClassNames) throws FactoryConfigurationError {
        Iterator e = parserFactoryClassNames.iterator();
        int index = 0;
        while (e.hasNext()) {
            String parserFactoryClassName = (String)e.next();
            DocumentBuilderFactory factory = (DocumentBuilderFactory)this.getFactory(parserFactoryClassName);
            Hashtable<String, String> properties = new Hashtable<String, String>(7);
            this.setDefaultDOMProperties(factory, properties, index);
            properties.put(FACTORYNAMEKEY, parserFactoryClassName);
            this.context.registerService(DOMFACTORYNAME, (Object)this, properties);
            ++index;
        }
    }

    private void setDefaultDOMProperties(DocumentBuilderFactory factory, Hashtable props, int index) {
        props.put("service.description", DOMFACTORYDESCRIPTION);
        props.put("service.pid", "javax.xml.parsers.DocumentBuilderFactory." + this.context.getBundle().getBundleId() + "." + index);
        this.setDOMProperties(factory, props);
    }

    public void setDOMProperties(DocumentBuilderFactory factory, Hashtable props) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        props.put(PARSER_VALIDATING, new Boolean(validating));
        props.put(PARSER_NAMESPACEAWARE, new Boolean(namespaceaware));
    }

    private Object getFactory(String parserFactoryClassName) throws FactoryConfigurationError {
        try {
            return this.context.getBundle().loadClass(parserFactoryClassName).newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FactoryConfigurationError(e);
        }
    }

    public Object getService(Bundle bundle2, ServiceRegistration registration) {
        ServiceReference sref = registration.getReference();
        String parserFactoryClassName = (String)sref.getProperty(FACTORYNAMEKEY);
        Object factory = this.getFactory(parserFactoryClassName);
        if (factory instanceof SAXParserFactory) {
            ((SAXParserFactory)factory).setValidating((Boolean)sref.getProperty(PARSER_VALIDATING));
            ((SAXParserFactory)factory).setNamespaceAware((Boolean)sref.getProperty(PARSER_NAMESPACEAWARE));
        } else if (factory instanceof DocumentBuilderFactory) {
            ((DocumentBuilderFactory)factory).setValidating((Boolean)sref.getProperty(PARSER_VALIDATING));
            ((DocumentBuilderFactory)factory).setNamespaceAware((Boolean)sref.getProperty(PARSER_NAMESPACEAWARE));
        }
        return factory;
    }

    public void ungetService(Bundle bundle2, ServiceRegistration registration, Object service) {
    }
}

