/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;

@ThreadSafe
public final class WavUtils {
    private WavUtils() {
    }

    public static double getAudioDuration(URI wavFile) throws UnsupportedAudioFileException, IOException {
        return WavUtils.getAudioDuration(new File(wavFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getAudioDuration(File wavFile) throws UnsupportedAudioFileException, IOException {
        try (AudioInputStream audio = null;){
            if (wavFile != null && wavFile.exists()) {
                audio = AudioSystem.getAudioInputStream(wavFile);
                AudioFormat format = audio.getFormat();
                double d = (double)((float)wavFile.length() / format.getSampleRate()) / ((double)format.getSampleSizeInBits() / 8.0) / (double)format.getChannels();
                return d;
            }
            double format = 0.0;
            return format;
        }
    }
}

