/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;

@ThreadSafe
public final class UriUtils {
    private UriUtils() {
    }

    public static URI resolve(URI base, URI uri) {
        if (base.equals(uri)) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return base.resolve(uri);
        }
        return uri;
    }

    public static URI resolve(String address, int port, URI uri) {
        String base = "http://" + address + ":" + port;
        try {
            return UriUtils.resolve(new URI(base), uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Badly formed URI: " + base, e);
        }
    }
}

