/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;

@ThreadSafe
public final class StringUtils {
    private static final Pattern numberPattern = Pattern.compile("\\d+");

    private StringUtils() {
    }

    public static String addSuffixIfNotPresent(String text, String suffix) {
        if (text.endsWith(suffix)) {
            return text;
        }
        return text + suffix;
    }

    public static boolean isPositiveInteger(String text) {
        return numberPattern.matcher(text).matches();
    }

    public static String toString(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        StringWriter writer = new StringWriter();
        char[] data = new char[512];
        int bytesRead = -1;
        do {
            if ((bytesRead = reader.read(data)) <= 0) continue;
            writer.write(data, 0, bytesRead);
        } while (bytesRead != -1);
        return writer.getBuffer().toString();
    }
}

