/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.sdp.Connection;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.util.IPUtils;

@ThreadSafe
public class SdpUtils {
    public static String endWithNewLine(String sdpDescription) {
        if (sdpDescription == null || sdpDescription.isEmpty()) {
            throw new IllegalArgumentException("The SDP description cannot be null or empty");
        }
        return sdpDescription.trim().concat("\n");
    }

    public static String patch(String contentType, byte[] data, String externalIp) throws UnknownHostException, SdpException {
        String text = new String(data);
        String patchedSdp = null;
        if (contentType.equalsIgnoreCase("application/sdp")) {
            SessionDescription sdp = SdpFactory.getInstance().createSessionDescription(text);
            SdpUtils.fix(sdp.getConnection(), externalIp);
            SdpUtils.fix(sdp.getOrigin(), externalIp);
            Vector descriptions = sdp.getMediaDescriptions(false);
            for (MediaDescription description : descriptions) {
                SdpUtils.fix(description.getConnection(), externalIp);
            }
            patchedSdp = sdp.toString();
        } else {
            String boundary = contentType.split(";")[1].split("=")[1];
            String[] parts = text.split(boundary);
            String sdpText = null;
            for (String part : parts) {
                if (!part.contains("application/sdp")) continue;
                sdpText = part.replaceAll("Content.*", "").replaceAll("--", "").trim();
            }
            SessionDescription sdp = SdpFactory.getInstance().createSessionDescription(sdpText);
            SdpUtils.fix(sdp.getConnection(), externalIp);
            SdpUtils.fix(sdp.getOrigin(), externalIp);
            Vector descriptions = sdp.getMediaDescriptions(false);
            for (MediaDescription description : descriptions) {
                SdpUtils.fix(description.getConnection(), externalIp);
            }
            patchedSdp = sdp.toString();
        }
        return patchedSdp;
    }

    private static void fix(Origin origin, String externalIp) throws UnknownHostException, SdpException {
        InetAddress address;
        String ip;
        if (origin != null && "IN".equals(origin.getNetworkType()) && "IP4".equals(origin.getAddressType()) && !IPUtils.isRoutableAddress(ip = (address = InetAddress.getByName(origin.getAddress())).getHostAddress())) {
            origin.setAddress(externalIp);
        }
    }

    private static void fix(Connection connection, String externalIp) throws UnknownHostException, SdpException {
        InetAddress address;
        String ip;
        if (connection != null && "IN".equals(connection.getNetworkType()) && "IP4".equals(connection.getAddressType()) && !IPUtils.isRoutableAddress(ip = (address = InetAddress.getByName(connection.getAddress())).getHostAddress())) {
            connection.setAddress(externalIp);
        }
    }
}

