/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;

@ThreadSafe
public final class RevolvingCounter {
    private final long start;
    private final long limit;
    private final AtomicLong count;
    private final Lock lock;

    public RevolvingCounter(long limit) {
        this(0L, limit);
    }

    public RevolvingCounter(long start, long limit) {
        this.start = start;
        this.limit = limit;
        this.count = new AtomicLong();
        this.count.set(start);
        this.lock = new ReentrantLock();
    }

    public long get() {
        long result = this.count.getAndIncrement();
        if (result >= this.limit) {
            while (!this.lock.tryLock()) {
            }
            if (this.count.get() >= this.limit) {
                result = this.start;
                this.count.set(this.start + 1L);
                this.lock.unlock();
            } else {
                this.lock.unlock();
                result = this.get();
            }
        }
        return result;
    }
}

