/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;

@ThreadSafe
public final class HttpUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";

    private HttpUtils() {
    }

    public static Map<String, String> toMap(HttpEntity entity) throws IllegalStateException, IOException {
        String contentType = null;
        String charset = null;
        contentType = EntityUtils.getContentMimeType((HttpEntity)entity);
        charset = EntityUtils.getContentCharSet((HttpEntity)entity);
        ArrayList parameters = null;
        if (contentType != null && contentType.equalsIgnoreCase(CONTENT_TYPE)) {
            parameters = URLEncodedUtils.parse((HttpEntity)entity);
        } else {
            String content = EntityUtils.toString((HttpEntity)entity, (String)"ASCII");
            if (content != null && content.length() > 0) {
                parameters = new ArrayList();
                URLEncodedUtils.parse(parameters, (Scanner)new Scanner(content), (String)charset);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair parameter : parameters) {
            map.put(parameter.getName(), parameter.getValue());
        }
        return map;
    }

    public static String toString(Header[] headers) {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Header header : headers) {
            parameters.add(new BasicNameValuePair(header.getName(), header.getValue()));
        }
        return URLEncodedUtils.format(parameters, (String)"UTF-8");
    }
}

