/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mobicents.servlet.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.restcomm.util.HexadecimalUtils;

@ThreadSafe
public final class DigestAuthentication {
    private DigestAuthentication() {
    }

    private static String A1(String algorithm, String user, String realm, String password, String nonce, String cnonce) {
        if (algorithm == null || algorithm.trim().length() == 0 || algorithm.trim().equalsIgnoreCase("MD5")) {
            return user + ":" + realm + ":" + password;
        }
        if (cnonce == null || cnonce.length() == 0) {
            throw new NullPointerException("The cnonce parameter may not be null.");
        }
        return DigestAuthentication.H(user + ":" + realm + ":" + password) + ":" + nonce + ":" + cnonce;
    }

    private static String A2(String method, String uri, String body, String qop) {
        if (qop == null || qop.trim().length() == 0 || qop.trim().equalsIgnoreCase("auth")) {
            return method + ":" + uri;
        }
        if (body == null) {
            body = "";
        }
        return method + ":" + uri + ":" + DigestAuthentication.H(body);
    }

    public static String response(String algorithm, String user, String realm, String password, String nonce, String nc, String cnonce, String method, String uri, String body, String qop) {
        DigestAuthentication.validate(user, realm, password, nonce, method, uri);
        String a1 = DigestAuthentication.A1(algorithm, user, realm, password, nonce, cnonce);
        String a2 = DigestAuthentication.A2(method, uri, body, qop);
        if (cnonce != null && qop != null && nc != null && (qop.equalsIgnoreCase("auth") || qop.equalsIgnoreCase("auth-int"))) {
            return DigestAuthentication.KD(DigestAuthentication.H(a1), nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + DigestAuthentication.H(a2));
        }
        return DigestAuthentication.KD(DigestAuthentication.H(a1), nonce + ":" + DigestAuthentication.H(a2));
    }

    private static String H(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] result = digest.digest(data.getBytes());
            char[] characters = HexadecimalUtils.toHex(result);
            return new String(characters);
        }
        catch (NoSuchAlgorithmException exception) {
            return null;
        }
    }

    private static String KD(String secret, String data) {
        return DigestAuthentication.H(secret + ":" + data);
    }

    private static void validate(String user, String realm, String password, String nonce, String method, String uri) {
        if (user == null) {
            throw new NullPointerException("The user parameter may not be null.");
        }
        if (realm == null) {
            throw new NullPointerException("The realm parameter may not be null.");
        }
        if (password == null) {
            throw new NullPointerException("The password parameter may not be null.");
        }
        if (method == null) {
            throw new NullPointerException("The method parameter may not be null.");
        }
        if (uri == null) {
            throw new NullPointerException("The uri parameter may not be null.");
        }
        if (nonce == null) {
            throw new NullPointerException("The nonce parameter may not be null.");
        }
    }
}

