/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.fsm;

import com.google.common.base.Preconditions;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.fsm.Guard;
import org.mobicents.servlet.restcomm.fsm.State;

@Immutable
public final class Transition {
    private final Guard guard;
    private final State stateOnEnter;
    private final State stateOnExit;

    public Transition(State stateOnEnter, State stateOnExit, Guard guard) {
        Preconditions.checkNotNull((Object)stateOnEnter, (Object)"A transition can not have a null value for the state on enter.");
        Preconditions.checkNotNull((Object)stateOnExit, (Object)"A transition can not have a null value for the state on exit.");
        this.guard = guard;
        this.stateOnEnter = stateOnEnter;
        this.stateOnExit = stateOnExit;
    }

    public Transition(State stateOnEnter, State stateOnExit) {
        this(stateOnEnter, stateOnExit, null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Transition transition = (Transition)object;
        if (!this.stateOnEnter.equals(transition.getStateOnEnter())) {
            return false;
        }
        return this.stateOnExit.equals(transition.getStateOnExit());
    }

    public Guard getGuard() {
        return this.guard;
    }

    public State getStateOnEnter() {
        return this.stateOnEnter;
    }

    public State getStateOnExit() {
        return this.stateOnExit;
    }

    public int hashCode() {
        int prime = 5;
        int result = 1;
        result = 5 * result + this.stateOnEnter.hashCode();
        result = 5 * result + this.stateOnExit.hashCode();
        return result;
    }
}

