/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.fsm;

import com.google.common.base.Preconditions;
import org.mobicents.servlet.restcomm.annotations.concurrency.Immutable;
import org.mobicents.servlet.restcomm.fsm.Action;

@Immutable
public class State {
    private final Action actionOnEnter;
    private final Action actionOnState;
    private final Action actionOnExit;
    private final String id;

    public State(String id, Action actionOnEnter, Action actionOnState, Action actionOnExit) {
        Preconditions.checkNotNull((Object)id, (Object)"A state can not have a null value for id.");
        this.actionOnEnter = actionOnEnter;
        this.actionOnState = actionOnState;
        this.actionOnExit = actionOnExit;
        this.id = id;
    }

    public State(String id, Action actionOnEnter, Action actionOnExit) {
        this(id, actionOnEnter, null, actionOnExit);
    }

    public State(String id, Action actionOnState) {
        this(id, null, actionOnState, null);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        State state = (State)object;
        return this.id.equals(state.getId());
    }

    public Action getActionOnEnter() {
        return this.actionOnEnter;
    }

    public Action getActionOnState() {
        return this.actionOnState;
    }

    public Action getActionOnExit() {
        return this.actionOnExit;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 5;
        int result = 1;
        result = 5 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return this.id;
    }
}

