/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.fsm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mobicents.servlet.restcomm.annotations.concurrency.NotThreadSafe;
import org.mobicents.servlet.restcomm.fsm.Action;
import org.mobicents.servlet.restcomm.fsm.Guard;
import org.mobicents.servlet.restcomm.fsm.State;
import org.mobicents.servlet.restcomm.fsm.Transition;
import org.mobicents.servlet.restcomm.fsm.TransitionFailedException;
import org.mobicents.servlet.restcomm.fsm.TransitionNotFoundException;
import org.mobicents.servlet.restcomm.fsm.TransitionRollbackException;

@NotThreadSafe
public class FiniteStateMachine {
    private final ImmutableMap<State, Map<State, Transition>> transitions;
    private State state;

    public FiniteStateMachine(State initial, Set<Transition> transitions) {
        Preconditions.checkNotNull((Object)initial, (Object)"The initial state for a finite state machine can not be null.");
        Preconditions.checkNotNull(transitions, (Object)"A finite state machine can not be created with transitions set to null.");
        this.state = initial;
        this.transitions = this.toImmutableMap(transitions);
    }

    public State state() {
        return this.state;
    }

    public void transition(Object event, State target) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        Preconditions.checkNotNull((Object)event, (Object)"The message passed can not be null.");
        Preconditions.checkNotNull((Object)target, (Object)"The target state can not be null");
        if (this.transitions.get((Object)this.state) == null || !((Map)this.transitions.get((Object)this.state)).containsKey(target)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("No transition could be found from a(n) ").append(this.state.getId()).append(" state to a(n) ").append(target.getId()).append(" state.");
            throw new TransitionNotFoundException(buffer.toString(), event, this.state, target);
        }
        Transition transition = (Transition)((Map)this.transitions.get((Object)this.state)).get(target);
        Guard guard = transition.getGuard();
        boolean accept = true;
        if (guard != null) {
            try {
                accept = guard.accept(event, transition);
            }
            catch (Exception exception) {
                throw new TransitionFailedException(exception, event, transition);
            }
        }
        if (accept) {
            Action actionOnEnter;
            Action actionOnExit = this.state.getActionOnExit();
            if (actionOnExit != null) {
                try {
                    actionOnExit.execute(event);
                }
                catch (Exception exception) {
                    throw new TransitionFailedException(exception, event, transition);
                }
            }
            if ((actionOnEnter = target.getActionOnEnter()) != null) {
                try {
                    actionOnEnter.execute(event);
                }
                catch (Exception exception) {
                    throw new TransitionFailedException(exception, event, transition);
                }
            }
            this.state = target;
            Action actionOnState = target.getActionOnState();
            if (actionOnState != null) {
                try {
                    actionOnState.execute(event);
                }
                catch (Exception exception) {
                    throw new TransitionFailedException(exception, event, transition);
                }
            }
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append("The condition guarding a transition from a(n) ").append(transition.getStateOnEnter().getId()).append(" state to a(n) ").append(transition.getStateOnExit().getId()).append(" state has failed.");
            throw new TransitionRollbackException(buffer.toString(), event, transition);
        }
    }

    private ImmutableMap<State, Map<State, Transition>> toImmutableMap(Set<Transition> transitions) {
        HashMap map = new HashMap();
        for (Transition transition : transitions) {
            State stateOnEnter = transition.getStateOnEnter();
            if (!map.containsKey(stateOnEnter)) {
                map.put(stateOnEnter, new HashMap());
            }
            State stateOnExit = transition.getStateOnExit();
            ((Map)map.get(stateOnEnter)).put(stateOnExit, transition);
        }
        return ImmutableMap.copyOf(map);
    }
}

