/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.email;

import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.restcomm.email.Mail;

public final class MailMan
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final Session session;

    public MailMan(Configuration configuration) {
        String host = configuration.getString("host");
        String user = configuration.getString("user");
        String password = configuration.getString("password");
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", host);
        if (user != null && !user.isEmpty()) {
            properties.setProperty("mail.user", user);
        }
        if (password != null && !password.isEmpty()) {
            properties.setProperty("mail.password", password);
        }
        this.session = Session.getDefaultInstance((Properties)properties);
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        if (Mail.class.equals(klass)) {
            this.send(message);
        }
    }

    private void send(Object message) {
        Mail mail = (Mail)message;
        try {
            InternetAddress from = new InternetAddress(mail.from());
            InternetAddress to = new InternetAddress(mail.to());
            MimeMessage email = new MimeMessage(this.session);
            email.setFrom((Address)from);
            email.addRecipient(Message.RecipientType.TO, (Address)to);
            email.setSubject(mail.subject());
            email.setText(mail.body());
            Transport.send((Message)email);
        }
        catch (MessagingException exception) {
            this.logger.error(exception.getMessage(), (Object)exception);
        }
    }
}

