/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.cache;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.mobicents.servlet.restcomm.cache.DiskCacheRequest;
import org.mobicents.servlet.restcomm.cache.DiskCacheResponse;

public final class DiskCache
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final String location;
    private final String uri;

    public DiskCache(String location, String uri, boolean create) {
        File path;
        String temp = location;
        if (!temp.endsWith("/")) {
            temp = temp + "/";
        }
        if (!(path = new File(temp)).exists() || !path.isDirectory()) {
            path.mkdirs();
        }
        this.location = temp;
        temp = uri;
        if (!temp.endsWith("/")) {
            temp = temp + "/";
        }
        this.uri = temp;
    }

    public DiskCache(String location, String uri) {
        this(location, uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI cache(Object message) throws IOException {
        DiskCacheRequest request = (DiskCacheRequest)message;
        if (request.hash() == null) {
            if (request.uri().getScheme().equalsIgnoreCase("file")) {
                File origFile = new File(request.uri());
                File destFile = new File(this.location + origFile.getName());
                if (!destFile.exists()) {
                    FileUtils.moveFile((File)origFile, (File)destFile);
                }
                return URI.create(this.uri + destFile.getName());
            }
            String hash = null;
            URI uri = null;
            if (request.uri().toString().contains("hash")) {
                String fragment = request.uri().getFragment();
                hash = fragment.replace("hash=", "");
                String uriStr = request.uri().toString().replace(fragment, "").replace("#", "");
                uri = URI.create(uriStr);
            } else {
                uri = request.uri();
                hash = new Sha256Hash((Object)uri.toString()).toHex();
            }
            String extension = this.extension(uri).toLowerCase();
            File path = new File(this.location + hash + "." + extension);
            if (!path.exists()) {
                File tmp = new File(path + "." + "tmp");
                InputStream input = null;
                OutputStream output = null;
                try {
                    input = uri.toURL().openStream();
                    output = new FileOutputStream(tmp);
                    byte[] buffer = new byte[4096];
                    int read = 0;
                    do {
                        if ((read = input.read(buffer, 0, 4096)) <= 0) continue;
                        output.write(buffer, 0, read);
                    } while (read != -1);
                    tmp.renameTo(path);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
            }
            return URI.create(this.uri + hash + "." + extension);
        }
        String extension = "wav";
        String hash = request.hash();
        final String filename = hash + "." + "wav";
        File matchedFile = new File(this.location).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(filename);
            }
        })[0];
        if (matchedFile.exists()) {
            return URI.create(this.uri + filename);
        }
        throw new FileNotFoundException(filename);
    }

    private String extension(URI uri) {
        String path = uri.getPath();
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (DiskCacheRequest.class.equals(klass)) {
            DiskCacheResponse response = null;
            try {
                response = new DiskCacheResponse(this.cache(message));
            }
            catch (Exception exception) {
                this.logger.error("Error while chaching", (Object)exception);
                response = new DiskCacheResponse(exception);
            }
            sender.tell((Object)response, self);
        }
    }
}

