/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.amazonS3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.activation.MimetypesFileTypeMap;
import org.apache.log4j.Logger;

public class S3AccessTool {
    private static Logger logger = Logger.getLogger(S3AccessTool.class);
    private String accessKey;
    private String securityKey;
    private String bucketName;
    private String folder;
    private boolean reducedRedundancy;
    private int daysToRetainPublicUrl;
    private boolean removeOriginalFile;

    public S3AccessTool(String accessKey, String securityKey, String bucketName, String folder, boolean reducedRedundancy, int daysToRetainPublicUrl, boolean removeOriginalFile) {
        this.accessKey = accessKey;
        this.securityKey = securityKey;
        this.bucketName = bucketName;
        this.folder = folder;
        this.reducedRedundancy = reducedRedundancy;
        this.daysToRetainPublicUrl = daysToRetainPublicUrl;
        this.removeOriginalFile = removeOriginalFile;
    }

    public URI uploadFile(String fileToUpload) {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.securityKey);
        AmazonS3Client s3client = new AmazonS3Client((AWSCredentials)credentials);
        try {
            StringBuffer bucket = new StringBuffer();
            bucket.append(this.bucketName);
            if (this.folder != null && !this.folder.isEmpty()) {
                bucket.append("/").append(this.folder);
            }
            URI fileUri = URI.create(fileToUpload);
            logger.info((Object)("File to upload to S3: " + fileUri.toString()));
            File file = new File(fileUri);
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (this.daysToRetainPublicUrl > 0) {
                cal.add(5, this.daysToRetainPublicUrl);
            } else {
                cal.add(5, 180);
            }
            date = cal.getTime();
            GeneratePresignedUrlRequest generatePresignedUrlRequestGET = new GeneratePresignedUrlRequest(bucket.toString(), file.getName());
            generatePresignedUrlRequestGET.setMethod(HttpMethod.GET);
            generatePresignedUrlRequestGET.setExpiration(date);
            URL downloadUrl = s3client.generatePresignedUrl(generatePresignedUrlRequestGET);
            while (!file.exists()) {
            }
            PutObjectRequest putRequest = new PutObjectRequest(bucket.toString(), file.getName(), file);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType(new MimetypesFileTypeMap().getContentType(file));
            putRequest.setMetadata(metadata);
            if (this.reducedRedundancy) {
                putRequest.setStorageClass(StorageClass.ReducedRedundancy);
            }
            s3client.putObject(putRequest);
            if (this.removeOriginalFile) {
                this.removeLocalFile(file);
            }
            return downloadUrl.toURI();
        }
        catch (AmazonServiceException ase) {
            logger.error((Object)"Caught an AmazonServiceException");
            logger.error((Object)("Error Message:    " + ase.getMessage()));
            logger.error((Object)("HTTP Status Code: " + ase.getStatusCode()));
            logger.error((Object)("AWS Error Code:   " + ase.getErrorCode()));
            logger.error((Object)("Error Type:       " + ase.getErrorType()));
            logger.error((Object)("Request ID:       " + ase.getRequestId()));
            return null;
        }
        catch (AmazonClientException ace) {
            logger.error((Object)"Caught an AmazonClientException, which ");
            logger.error((Object)("Error Message: " + ace.getMessage()));
            return null;
        }
        catch (URISyntaxException e) {
            logger.error((Object)("URISyntaxException: " + e.getMessage()));
            return null;
        }
    }

    private void removeLocalFile(File file) {
        if (!file.delete()) {
            logger.info((Object)("Error while trying to delete the file: " + file.toString()));
        }
    }
}

