/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Arrays;
import org.jboss.as.security.vault.VaultInteraction;
import org.jboss.as.security.vault.VaultSession;

public class VaultInteractiveSession {
    private String salt;
    private String keystoreURL;
    private String encDir;
    private String keystoreAlias;
    private int iterationCount = 0;
    private VaultSession vaultNISession = null;

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        while (this.encDir == null || this.encDir.length() == 0) {
            this.encDir = console.readLine("Enter directory to store encrypted files:", new Object[0]);
        }
        while (this.keystoreURL == null || this.keystoreURL.length() == 0) {
            this.keystoreURL = console.readLine("Enter Keystore URL:", new Object[0]);
        }
        char[] keystorePasswd = VaultInteractiveSession.getSensitiveValue("Enter Keystore password");
        try {
            while (this.salt == null || this.salt.length() != 8) {
                this.salt = console.readLine("Enter 8 character salt:", new Object[0]);
            }
            String ic = console.readLine("Enter iteration count as a number (Eg: 44):", new Object[0]);
            this.iterationCount = Integer.parseInt(ic);
            this.vaultNISession = new VaultSession(this.keystoreURL, new String(keystorePasswd), this.encDir, this.salt, this.iterationCount);
            while (this.keystoreAlias == null || this.keystoreAlias.length() == 0) {
                this.keystoreAlias = console.readLine("Enter Keystore Alias:", new Object[0]);
            }
            System.out.println("Initializing Vault");
            this.vaultNISession.startVaultSession(this.keystoreAlias);
            this.vaultNISession.vaultConfigurationDisplay();
            System.out.println("Vault is initialized and ready for use");
            System.out.println("Handshake with Vault complete");
            VaultInteraction vaultInteraction = new VaultInteraction(this.vaultNISession);
            vaultInteraction.start();
        }
        catch (Exception e) {
            System.out.println("Exception encountered:" + e.getLocalizedMessage());
        }
    }

    public static char[] getSensitiveValue(String passwordPrompt) {
        char[] passwd;
        while (true) {
            char[] passwd1;
            Console console;
            boolean noMatch;
            if (passwordPrompt == null) {
                passwordPrompt = "Enter your password";
            }
            boolean bl = noMatch = !Arrays.equals(passwd = (console = System.console()).readPassword(passwordPrompt + ": ", new Object[0]), passwd1 = console.readPassword(passwordPrompt + " again: ", new Object[0]));
            if (!noMatch) break;
            System.out.println("Values entered don't match");
        }
        System.out.println("Values match");
        return passwd;
    }
}

