/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientTransactionContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.XidTransactionID;

public final class EJBClientManagedTransactionContext
extends EJBClientTransactionContext {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry synchronizationRegistry;
    private static final AtomicReferenceFieldUpdater<ResourceImpl, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ResourceImpl.class, State.class, "state");

    EJBClientManagedTransactionContext(TransactionManager transactionManager, TransactionSynchronizationRegistry synchronizationRegistry) {
        this.transactionManager = transactionManager;
        this.synchronizationRegistry = synchronizationRegistry;
    }

    @Override
    protected TransactionID getAssociatedTransactionID(EJBClientInvocationContext invocationContext) throws Exception {
        Transaction transaction = this.transactionManager.getTransaction();
        if (transaction == null) {
            return null;
        }
        int txStatus = transaction.getStatus();
        switch (txStatus) {
            case 0: {
                break;
            }
            default: {
                return null;
            }
        }
        Object transactionKey = this.synchronizationRegistry.getTransactionKey();
        EJBReceiver receiver = invocationContext.getReceiver();
        String nodeName = receiver.getNodeName();
        ResourceImpl resource = new ResourceImpl(invocationContext, transactionKey);
        if (transaction.enlistResource(resource)) {
            XidTransactionID transactionID = resource.getTransactionID();
            if (transactionID != null) {
                return transactionID;
            }
            throw Logs.MAIN.txEnlistmentDidNotYieldTxId();
        }
        XidTransactionID transactionID = (XidTransactionID)this.synchronizationRegistry.getResource(new NodeKey(nodeName));
        if (transactionID == null) {
            throw Logs.MAIN.cannotEnlistTx();
        }
        this.synchronizationRegistry.registerInterposedSynchronization(new SynchronizationImpl(invocationContext, transactionID));
        return transactionID;
    }

    @Override
    protected String getTransactionNode() {
        return null;
    }

    final class ResourceImpl
    implements XAResource {
        private final Object transactionKey;
        private final EJBClientContext ejbClientContext;
        private final String nodeName;
        volatile State state;

        ResourceImpl(EJBClientInvocationContext ejbClientInvocationContext, Object transactionKey) {
            this.ejbClientContext = ejbClientInvocationContext.getClientContext();
            this.transactionKey = transactionKey;
            this.nodeName = ejbClientInvocationContext.getReceiver().getNodeName();
        }

        XidTransactionID getTransactionID() {
            State state = this.state;
            return state == null ? null : state.transactionID;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            if (flags == 0 || flags == 0x200000) {
                XidTransactionID transactionID = new XidTransactionID(xid);
                if (!stateUpdater.compareAndSet(this, null, new State(transactionID, false, new AtomicInteger()))) {
                    throw new XAException(-5);
                }
            } else if (flags == 0x8000000) {
                State state;
                State state2;
                do {
                    if ((state = this.state) == null || !state.suspended) {
                        throw new XAException(-5);
                    }
                    state2 = state;
                    state = new State(state, false);
                } while (!stateUpdater.compareAndSet(this, state2, state));
            } else {
                throw new XAException(-5);
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            if (flags == 0x2000000) {
                State state;
                State state2;
                do {
                    if ((state = this.state) == null || state.suspended) {
                        throw new XAException(-5);
                    }
                    state2 = state;
                    state = new State(state, true);
                } while (!stateUpdater.compareAndSet(this, state2, state));
            } else if (flags == 0x20000000 || flags == 0x4000000) {
                if (stateUpdater.getAndSet(this, null) == null) {
                    throw new XAException(-5);
                }
            } else {
                throw new XAException(-5);
            }
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            XidTransactionID transactionID = new XidTransactionID(xid);
            EJBReceiverContext receiverContext = this.ejbClientContext.requireNodeEJBReceiverContext(this.nodeName);
            EJBReceiver receiver = receiverContext.getReceiver();
            return receiver.sendPrepare(receiverContext, transactionID);
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            XidTransactionID transactionID = new XidTransactionID(xid);
            EJBReceiverContext receiverContext = this.ejbClientContext.requireNodeEJBReceiverContext(this.nodeName);
            EJBReceiver receiver = receiverContext.getReceiver();
            receiver.sendCommit(receiverContext, transactionID, onePhase);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            XidTransactionID transactionID = new XidTransactionID(xid);
            EJBReceiverContext receiverContext = this.ejbClientContext.requireNodeEJBReceiverContext(this.nodeName);
            EJBReceiver receiver = receiverContext.getReceiver();
            receiver.sendForget(receiverContext, transactionID);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            XidTransactionID transactionID = new XidTransactionID(xid);
            EJBReceiverContext receiverContext = this.ejbClientContext.requireNodeEJBReceiverContext(this.nodeName);
            EJBReceiver receiver = receiverContext.getReceiver();
            receiver.sendRollback(receiverContext, transactionID);
        }

        @Override
        public boolean isSameRM(XAResource resource) throws XAException {
            return resource instanceof ResourceImpl && this.isSameRM((ResourceImpl)resource);
        }

        boolean isSameRM(ResourceImpl resource) throws XAException {
            return resource != null && this.transactionKey == resource.transactionKey && this.nodeName.equals(resource.nodeName);
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            return false;
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            return new Xid[0];
        }
    }

    static final class State {
        private final XidTransactionID transactionID;
        private final boolean suspended;
        private final AtomicInteger participantCnt;

        State(XidTransactionID transactionID, boolean suspended, AtomicInteger cnt) {
            this.transactionID = transactionID;
            this.suspended = suspended;
            this.participantCnt = cnt;
        }

        State(State old, boolean suspended) {
            this.transactionID = old.transactionID;
            this.participantCnt = old.participantCnt;
            this.suspended = suspended;
        }
    }

    final class SynchronizationImpl
    implements Synchronization {
        private final EJBClientContext ejbClientContext;
        private final String nodeName;
        private final XidTransactionID transactionID;

        SynchronizationImpl(EJBClientInvocationContext ejbClientInvocationContext, XidTransactionID transactionID) {
            this.ejbClientContext = ejbClientInvocationContext.getClientContext();
            this.nodeName = ejbClientInvocationContext.getReceiver().getNodeName();
            this.transactionID = transactionID;
        }

        @Override
        public void beforeCompletion() {
            EJBReceiverContext receiverContext = this.ejbClientContext.requireNodeEJBReceiverContext(this.nodeName);
            EJBReceiver receiver = receiverContext.getReceiver();
            receiver.beforeCompletion(receiverContext, this.transactionID);
        }

        @Override
        public void afterCompletion(int status) {
        }
    }

    static class NodeKey {
        private final String nodeName;

        NodeKey(String nodeName) {
            this.nodeName = nodeName;
        }

        public boolean equals(Object obj) {
            return obj instanceof NodeKey && this.equals((NodeKey)obj);
        }

        boolean equals(NodeKey obj) {
            return obj != null && this.nodeName.equals(obj.nodeName);
        }

        public int hashCode() {
            return this.nodeName.hashCode();
        }
    }
}

