/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFile;
import org.hornetq.journal.HornetQJournalBundle;
import org.hornetq.journal.HornetQJournalLogger;

public class NIOSequentialFile
extends AbstractSequentialFile {
    private FileChannel channel;
    private RandomAccessFile rfile;
    private Semaphore maxIOSemaphore;
    private final int defaultMaxIO;
    private int maxIO;

    public NIOSequentialFile(SequentialFileFactory factory, String directory, String fileName, int maxIO, Executor writerExecutor) {
        super(directory, new File(directory + "/" + fileName), factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    public NIOSequentialFile(SequentialFileFactory factory, File file, int maxIO, Executor writerExecutor) {
        super(file.getParent(), new File(file.getPath()), factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockStart(int position) throws Exception {
        return position;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public synchronized void open() throws Exception {
        this.open(this.defaultMaxIO, true);
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws Exception {
        try {
            this.rfile = new RandomAccessFile(this.getFile(), "rw");
            this.channel = this.rfile.getChannel();
            this.fileSize = this.channel.size();
        }
        catch (IOException e) {
            this.factory.onIOError(new HornetQIOErrorException(e.getMessage(), e), e.getMessage(), this);
            throw e;
        }
        if (this.writerExecutor != null && useExecutor) {
            this.maxIOSemaphore = new Semaphore(maxIO);
            this.maxIO = maxIO;
        }
    }

    @Override
    public void fill(int position, int size, byte fillCharacter) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            bb.put(fillCharacter);
        }
        bb.flip();
        this.channel.position(position);
        this.channel.write(bb);
        this.channel.force(false);
        this.channel.position(0L);
        this.fileSize = this.channel.size();
    }

    @Override
    public synchronized void waitForClose() throws Exception {
        while (this.isOpen()) {
            this.wait();
        }
    }

    @Override
    public synchronized void close() throws Exception {
        super.close();
        if (this.maxIOSemaphore != null) {
            while (!this.maxIOSemaphore.tryAcquire(this.maxIO, 60L, TimeUnit.SECONDS)) {
                HornetQJournalLogger.LOGGER.errorClosingFile(this.getFileName());
            }
        }
        this.maxIOSemaphore = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.rfile != null) {
            this.rfile.close();
        }
        this.channel = null;
        this.rfile = null;
        this.notifyAll();
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    @Override
    public synchronized int read(ByteBuffer bytes, IOAsyncTask callback) throws Exception {
        try {
            if (this.channel == null) {
                throw new Exception("File " + this.getFileName() + " has a null channel");
            }
            int bytesRead = this.channel.read(bytes);
            if (callback != null) {
                callback.done();
            }
            bytes.flip();
            return bytesRead;
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onError(HornetQExceptionType.IO_ERROR.getCode(), e.getLocalizedMessage());
            }
            this.factory.onIOError(new HornetQIOErrorException(e.getMessage(), e), e.getMessage(), this);
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.channel != null) {
            this.channel.force(false);
        }
    }

    @Override
    public long size() throws Exception {
        if (this.channel == null) {
            return this.getFile().length();
        }
        return this.channel.size();
    }

    @Override
    public void position(long pos) throws Exception {
        super.position(pos);
        this.channel.position(pos);
    }

    public String toString() {
        return "NIOSequentialFile " + this.getFile();
    }

    @Override
    public SequentialFile cloneFile() {
        return new NIOSequentialFile(this.factory, this.getFile(), this.maxIO, this.writerExecutor);
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOAsyncTask callback) {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            this.internalWrite(bytes, sync, callback);
        }
        catch (Exception e) {
            callback.onError(HornetQExceptionType.GENERIC_EXCEPTION.getCode(), e.getMessage());
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.internalWrite(bytes, sync, null);
    }

    @Override
    public void writeInternal(ByteBuffer bytes) throws Exception {
        this.internalWrite(bytes, true, null);
    }

    @Override
    protected ByteBuffer newBuffer(int size, int limit) {
        size = limit;
        return super.newBuffer(size, limit);
    }

    private void internalWrite(final ByteBuffer bytes, final boolean sync, final IOAsyncTask callback) throws Exception {
        if (!this.isOpen()) {
            if (callback == null) {
                throw HornetQJournalBundle.BUNDLE.fileNotOpened();
            }
            callback.onError(HornetQExceptionType.IO_ERROR.getCode(), "File not opened");
            return;
        }
        this.position.addAndGet(bytes.limit());
        if (this.maxIOSemaphore == null || callback == null) {
            try {
                this.doInternalWrite(bytes, sync, callback);
            }
            catch (IOException e) {
                this.factory.onIOError(new HornetQIOErrorException(e.getMessage(), e), e.getMessage(), this);
            }
        } else {
            this.maxIOSemaphore.acquire();
            this.writerExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            NIOSequentialFile.this.doInternalWrite(bytes, sync, callback);
                        }
                        catch (IOException e) {
                            HornetQJournalLogger.LOGGER.errorSubmittingWrite(e);
                            NIOSequentialFile.this.factory.onIOError(new HornetQIOErrorException(e.getMessage(), e), e.getMessage(), NIOSequentialFile.this);
                            callback.onError(HornetQExceptionType.IO_ERROR.getCode(), e.getMessage());
                        }
                        catch (Throwable e) {
                            HornetQJournalLogger.LOGGER.errorSubmittingWrite(e);
                            callback.onError(HornetQExceptionType.IO_ERROR.getCode(), e.getMessage());
                        }
                    }
                    finally {
                        NIOSequentialFile.this.maxIOSemaphore.release();
                    }
                }
            });
        }
    }

    private void doInternalWrite(ByteBuffer bytes, boolean sync, IOAsyncTask callback) throws IOException {
        this.channel.write(bytes);
        if (sync) {
            this.sync();
        }
        if (callback != null) {
            callback.done();
        }
    }
}

