/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.HornetQAddressExistsException;
import org.hornetq.api.core.HornetQAlreadyReplicatingException;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQDuplicateIdException;
import org.hornetq.api.core.HornetQDuplicateMetaDataException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQIncompatibleClientServerException;
import org.hornetq.api.core.HornetQInterceptorRejectedPacketException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQLargeMessageException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.HornetQObjectClosedException;
import org.hornetq.api.core.HornetQQueueExistsException;
import org.hornetq.api.core.HornetQSecurityException;
import org.hornetq.api.core.HornetQSessionCreationException;
import org.hornetq.api.core.HornetQTransactionOutcomeUnknownException;
import org.hornetq.api.core.HornetQTransactionRolledBackException;
import org.hornetq.api.core.HornetQUnBlockedException;
import org.hornetq.api.core.HornetQUnsupportedPacketException;

public enum HornetQExceptionType {
    INTERNAL_ERROR(0){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQInternalErrorException(msg);
        }
    }
    ,
    UNSUPPORTED_PACKET(1){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQUnsupportedPacketException(msg);
        }
    }
    ,
    NOT_CONNECTED(2){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQNotConnectedException(msg);
        }
    }
    ,
    CONNECTION_TIMEDOUT(3){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQConnectionTimedOutException(msg);
        }
    }
    ,
    DISCONNECTED(4){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQDisconnectedException(msg);
        }
    }
    ,
    UNBLOCKED(5){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQUnBlockedException(msg);
        }
    }
    ,
    IO_ERROR(6){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQIOErrorException(msg);
        }
    }
    ,
    QUEUE_DOES_NOT_EXIST(100){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQNonExistentQueueException(msg);
        }
    }
    ,
    QUEUE_EXISTS(101){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQQueueExistsException(msg);
        }
    }
    ,
    OBJECT_CLOSED(102){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQObjectClosedException(msg);
        }
    }
    ,
    INVALID_FILTER_EXPRESSION(103){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQInvalidFilterExpressionException(msg);
        }
    }
    ,
    ILLEGAL_STATE(104){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQIllegalStateException(msg);
        }
    }
    ,
    SECURITY_EXCEPTION(105){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQSecurityException(msg);
        }
    }
    ,
    ADDRESS_EXISTS(107){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQAddressExistsException(msg);
        }
    }
    ,
    INCOMPATIBLE_CLIENT_SERVER_VERSIONS(108){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQIncompatibleClientServerException(msg);
        }
    }
    ,
    LARGE_MESSAGE_ERROR_BODY(110){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQLargeMessageException(msg);
        }
    }
    ,
    TRANSACTION_ROLLED_BACK(111){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQTransactionRolledBackException(msg);
        }
    }
    ,
    SESSION_CREATION_REJECTED(112){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQSessionCreationException(msg);
        }
    }
    ,
    DUPLICATE_ID_REJECTED(113){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQDuplicateIdException(msg);
        }
    }
    ,
    DUPLICATE_METADATA(114){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQDuplicateMetaDataException(msg);
        }
    }
    ,
    TRANSACTION_OUTCOME_UNKNOWN(115){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQTransactionOutcomeUnknownException(msg);
        }
    }
    ,
    ALREADY_REPLICATING(116){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQAlreadyReplicatingException(msg);
        }
    }
    ,
    INTERCEPTOR_REJECTED_PACKET(117){

        @Override
        public HornetQException createException(String msg) {
            return new HornetQInterceptorRejectedPacketException(msg);
        }
    }
    ,
    GENERIC_EXCEPTION(999),
    NATIVE_ERROR_INTERNAL(200),
    NATIVE_ERROR_INVALID_BUFFER(201),
    NATIVE_ERROR_NOT_ALIGNED(202),
    NATIVE_ERROR_CANT_INITIALIZE_AIO(203),
    NATIVE_ERROR_CANT_RELEASE_AIO(204),
    NATIVE_ERROR_CANT_OPEN_CLOSE_FILE(205),
    NATIVE_ERROR_CANT_ALLOCATE_QUEUE(206),
    NATIVE_ERROR_PREALLOCATE_FILE(208),
    NATIVE_ERROR_ALLOCATE_MEMORY(209),
    ADDRESS_FULL(210);

    private static final Map<Integer, HornetQExceptionType> TYPE_MAP;
    private final int code;

    private HornetQExceptionType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public HornetQException createException(String msg) {
        return new HornetQException(msg + ", code:" + (Object)((Object)this));
    }

    public static HornetQException createException(int code, String msg) {
        return HornetQExceptionType.getType(code).createException(msg);
    }

    public static HornetQExceptionType getType(int code) {
        HornetQExceptionType type = TYPE_MAP.get(code);
        if (type != null) {
            return type;
        }
        return GENERIC_EXCEPTION;
    }

    static {
        HashMap<Integer, HornetQExceptionType> map = new HashMap<Integer, HornetQExceptionType>();
        for (HornetQExceptionType type : EnumSet.allOf(HornetQExceptionType.class)) {
            map.put(type.getCode(), type);
        }
        TYPE_MAP = Collections.unmodifiableMap(map);
    }
}

