/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip.util;

public class Inet6Util {
    public static boolean isValidIP6Address(String ipAddress) {
        int length = ipAddress.length();
        boolean doubleColon = false;
        int numberOfColons = 0;
        int numberOfPeriods = 0;
        int numberOfPercent = 0;
        String word = "";
        char c = '\u0000';
        char prevChar = '\u0000';
        int offset = 0;
        if (length < 2) {
            return false;
        }
        block9: for (int i = 0; i < length; ++i) {
            prevChar = c;
            c = ipAddress.charAt(i);
            switch (c) {
                case '[': {
                    if (i != 0) {
                        return false;
                    }
                    if (ipAddress.charAt(length - 1) != ']') {
                        return false;
                    }
                    offset = 1;
                    if (length >= 4) continue block9;
                    return false;
                }
                case ']': {
                    if (i != length - 1) {
                        return false;
                    }
                    if (ipAddress.charAt(0) == '[') continue block9;
                    return false;
                }
                case '.': {
                    if (++numberOfPeriods > 3) {
                        return false;
                    }
                    if (!Inet6Util.isValidIP4Word(word)) {
                        return false;
                    }
                    if (numberOfColons != 6 && !doubleColon) {
                        return false;
                    }
                    if (numberOfColons == 7 && ipAddress.charAt(0 + offset) != ':' && ipAddress.charAt(1 + offset) != ':') {
                        return false;
                    }
                    word = "";
                    continue block9;
                }
                case ':': {
                    if (i == offset && (ipAddress.length() <= i || ipAddress.charAt(i + 1) != ':')) {
                        return false;
                    }
                    if (++numberOfColons > 7) {
                        return false;
                    }
                    if (numberOfPeriods > 0) {
                        return false;
                    }
                    if (prevChar == ':') {
                        if (doubleColon) {
                            return false;
                        }
                        doubleColon = true;
                    }
                    word = "";
                    continue block9;
                }
                case '%': {
                    if (numberOfColons == 0) {
                        return false;
                    }
                    ++numberOfPercent;
                    if (i + 1 >= length) {
                        return false;
                    }
                    try {
                        Integer.parseInt(ipAddress.substring(i + 1));
                        continue block9;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                default: {
                    if (numberOfPercent == 0) {
                        if (word.length() > 3) {
                            return false;
                        }
                        if (!Inet6Util.isValidHexChar(c)) {
                            return false;
                        }
                    }
                    word = word + c;
                }
            }
        }
        if (numberOfPeriods > 0) {
            if (numberOfPeriods != 3 || !Inet6Util.isValidIP4Word(word)) {
                return false;
            }
        } else {
            if (numberOfColons != 7 && !doubleColon) {
                return false;
            }
            if (numberOfPercent == 0 && word == "" && ipAddress.charAt(length - 1 - offset) == ':' && ipAddress.charAt(length - 2 - offset) != ':') {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIP4Word(String word) {
        if (word.length() < 1 || word.length() > 3) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return Integer.parseInt(word) <= 255;
    }

    static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isValidIPV4Address(String value) {
        int periods = 0;
        int i = 0;
        int length = value.length();
        if (length > 15) {
            return false;
        }
        char c = '\u0000';
        String word = "";
        for (i = 0; i < length; ++i) {
            c = value.charAt(i);
            if (c == '.') {
                if (++periods > 3) {
                    return false;
                }
                if (word == "") {
                    return false;
                }
                if (Integer.parseInt(word) > 255) {
                    return false;
                }
                word = "";
                continue;
            }
            if (!Character.isDigit(c)) {
                return false;
            }
            if (word.length() > 2) {
                return false;
            }
            word = word + c;
        }
        if (word == "" || Integer.parseInt(word) > 255) {
            return false;
        }
        return periods == 3;
    }
}

