/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip.cache;

import java.util.Properties;
import javax.sip.PeerUnavailableException;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.cache.SipCache;

public class SipCacheFactory {
    public static SipCache createSipCache(ClusteredSipStack clusteredSipStack, Properties configurationProperties) throws PeerUnavailableException {
        String cacheClassName = configurationProperties.getProperty("org.mobicents.ha.javax.sip.CACHE_CLASS_NAME");
        if (cacheClassName == null) {
            throw new IllegalArgumentException("the sip cache class name can't be null, please set the org.mobicents.ha.javax.sip.CACHE_CLASS_NAME property accordingly");
        }
        try {
            SipCache sipCache = (SipCache)Class.forName(cacheClassName).newInstance();
            sipCache.setClusteredSipStack(clusteredSipStack);
            sipCache.setConfigurationProperties(configurationProperties);
            return sipCache;
        }
        catch (Exception e) {
            String errmsg = "The SipCache class name: " + cacheClassName + " could not be instantiated. Ensure the org.mobicents.ha.javax.sip.CACHE_CLASS_NAME property has been set correctly and that the class is on the classpath.";
            throw new PeerUnavailableException(errmsg, (Throwable)e);
        }
    }
}

