/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip;

import java.io.Serializable;
import java.net.InetAddress;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RouteHeader;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingService;

public class SipLoadBalancer
implements Serializable {
    private static SipFactory sipFactory = SipFactory.getInstance();
    private static AddressFactory addressFactory;
    private static HeaderFactory headerFactory;
    private static final long serialVersionUID = 1L;
    private InetAddress address;
    private int sipPort;
    private int httpPort;
    private int rmiPort;
    private transient LoadBalancerHeartBeatingService loadBalancerHeartBeatingService;
    private transient RouteHeader balancerRouteHeaderUdp;
    private transient RouteHeader balancerRouteHeaderTcp;
    private transient boolean available = false;
    private transient boolean displayWarning = true;
    private transient Address sipAddress;

    public SipLoadBalancer(LoadBalancerHeartBeatingService loadBalancerHeartBeatingService, InetAddress address, int sipPort, int httpPort, int rmiPort) {
        this.address = address;
        this.sipPort = sipPort;
        this.httpPort = httpPort;
        this.rmiPort = rmiPort;
        this.loadBalancerHeartBeatingService = loadBalancerHeartBeatingService;
        try {
            SipURI sipUriUdp = addressFactory.createSipURI(null, address.getHostAddress());
            sipUriUdp.setPort(sipPort);
            sipUriUdp.setLrParam();
            SipURI sipAddressUri = (SipURI)sipUriUdp.clone();
            sipUriUdp.setTransportParam("udp");
            SipURI sipUriTcp = (SipURI)sipUriUdp.clone();
            sipUriTcp.setTransportParam("tcp");
            Address routeAddressUdp = addressFactory.createAddress((URI)sipUriUdp);
            this.balancerRouteHeaderUdp = headerFactory.createRouteHeader(routeAddressUdp);
            Address routeAddressTcp = addressFactory.createAddress((URI)sipUriTcp);
            this.balancerRouteHeaderTcp = headerFactory.createRouteHeader(routeAddressTcp);
            this.sipAddress = addressFactory.createAddress((URI)sipAddressUri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setSipPort(int sipPort) {
        this.sipPort = sipPort;
    }

    public int getSipPort() {
        return this.sipPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public RouteHeader getBalancerRouteHeaderTcp() {
        return this.balancerRouteHeaderTcp;
    }

    public RouteHeader getBalancerRouteHeaderUdp() {
        return this.balancerRouteHeaderUdp;
    }

    public void setBalancerRouteHeaderTcp(RouteHeader balancerRouteHeader) {
        this.balancerRouteHeaderTcp = balancerRouteHeader;
    }

    public void setBalancerRouteHeaderUdp(RouteHeader balancerRouteHeader) {
        this.balancerRouteHeaderUdp = balancerRouteHeader;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isDisplayWarning() {
        return this.displayWarning;
    }

    public void setDisplayWarning(boolean displayWarning) {
        this.displayWarning = displayWarning;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.sipPort;
        result = 31 * result + this.httpPort;
        result = 31 * result + this.rmiPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipLoadBalancer other = (SipLoadBalancer)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.sipPort != other.sipPort) {
            return false;
        }
        if (this.httpPort != other.httpPort) {
            return false;
        }
        return this.rmiPort == other.rmiPort;
    }

    public String toString() {
        return this.getAddress() + ":" + this.getSipPort() + ":" + this.getHttpPort() + ":" + this.getRmiPort();
    }

    public void switchover(String fromJvmRoute, String toJvmRoute) {
        this.loadBalancerHeartBeatingService.sendSwitchoverInstruction(this, fromJvmRoute, toJvmRoute);
    }

    public Address getSipAddress() {
        return this.sipAddress;
    }

    public void setSipAddress(Address sipAddress) {
        this.sipAddress = sipAddress;
    }

    static {
        try {
            addressFactory = sipFactory.createAddressFactory();
            headerFactory = sipFactory.createHeaderFactory();
        }
        catch (PeerUnavailableException e) {
            throw new RuntimeException("Problem with factory creation", e);
        }
    }
}

