/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.address.Address;
import org.mobicents.ha.javax.sip.AbstractLoadBalancerElector;
import org.mobicents.ha.javax.sip.SipLoadBalancer;

public class RoundRobinLoadBalancerElector
extends AbstractLoadBalancerElector {
    final ArrayList<SipLoadBalancer> balancers = new ArrayList();
    AtomicInteger index = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoadBalancer(SipLoadBalancer address) {
        ArrayList<SipLoadBalancer> arrayList = this.balancers;
        synchronized (arrayList) {
            this.balancers.add(address);
        }
    }

    private int getNextIndex() {
        int next;
        int current;
        while (!this.index.compareAndSet(current, next = (current = this.index.get()) == this.balancers.size() ? 1 : current + 1)) {
        }
        return next - 1;
    }

    public Address getLoadBalancer() {
        return this.getLoadBalancer(true).getSipAddress();
    }

    private SipLoadBalancer getLoadBalancer(boolean secondChance) {
        SipLoadBalancer result = null;
        switch (this.balancers.size()) {
            case 1: {
                result = this.balancers.get(0);
                if (!result.isAvailable()) {
                    return null;
                }
                return result;
            }
            case 0: {
                return null;
            }
        }
        try {
            result = this.balancers.get(this.getNextIndex());
            if (!result.isAvailable()) {
                for (int tries = 0; tries < this.balancers.size(); ++tries) {
                    result = this.balancers.get(this.getNextIndex());
                    if (!result.isAvailable()) continue;
                    return result;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (secondChance) {
                return this.getLoadBalancer(false);
            }
            if (this.logger.isLoggingEnabled()) {
                this.logger.logError("Failed to get load balancer", (Exception)e);
            }
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoadBalancer(Address address) {
        ArrayList<SipLoadBalancer> arrayList = this.balancers;
        synchronized (arrayList) {
            this.balancers.remove(address);
        }
    }

    public SipLoadBalancer getLoadBalancerExt() {
        return this.getLoadBalancer(true);
    }
}

