/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ha.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sip.ListeningPoint;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingListener;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingService;
import org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceImplMBean;
import org.mobicents.ha.javax.sip.SipLoadBalancer;
import org.mobicents.ha.javax.sip.util.Inet6Util;
import org.mobicents.tools.sip.balancer.NodeRegisterRMIStub;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerHeartBeatingServiceImpl
implements LoadBalancerHeartBeatingService,
LoadBalancerHeartBeatingServiceImplMBean {
    private static StackLogger logger = CommonLogger.getLogger(LoadBalancerHeartBeatingServiceImpl.class);
    public static String LB_HB_SERVICE_MBEAN_NAME = "org.mobicents.jain.sip:type=load-balancer-heartbeat-service,name=";
    public static final int DEFAULT_RMI_PORT = 2000;
    public static final String BALANCER_SIP_PORT_CHAR_SEPARATOR = ":";
    public static final String BALANCERS_CHAR_SEPARATOR = ";";
    public static final int DEFAULT_LB_SIP_PORT = 5065;
    public static final int DEFAULT_LB_HTTP_PORT = 2080;
    ClusteredSipStack sipStack = null;
    protected String balancers;
    protected String jvmRoute;
    protected Map<String, SipLoadBalancer> register = new ConcurrentHashMap<String, SipLoadBalancer>();
    protected long heartBeatInterval = 5000L;
    protected Timer heartBeatTimer = new Timer();
    protected TimerTask hearBeatTaskToRun = null;
    protected List<String> cachedAnyLocalAddresses = new ArrayList<String>();
    protected boolean started = false;
    protected Set<LoadBalancerHeartBeatingListener> loadBalancerHeartBeatingListeners = new CopyOnWriteArraySet<LoadBalancerHeartBeatingListener>();
    ObjectName oname = null;

    @Override
    public void init(ClusteredSipStack clusteredSipStack, Properties stackProperties) {
        this.sipStack = clusteredSipStack;
        this.balancers = stackProperties.getProperty("org.mobicents.ha.javax.sip.BALANCERS");
        this.heartBeatInterval = Integer.parseInt(stackProperties.getProperty("org.mobicents.ha.javax.sip.HEARTBEAT_INTERVAL", "5000"));
    }

    public void stopBalancer() {
        this.stop();
    }

    @Override
    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LoadBalancerHeartBeatingServiceImpl.this.stopBalancer();
                logger.logInfo("Shutting down the Load Balancer Link");
            }
        });
        if (!this.started) {
            if (this.balancers != null && this.balancers.length() > 0) {
                String[] balancerDescriptions;
                String[] arr$ = balancerDescriptions = this.balancers.split(BALANCERS_CHAR_SEPARATOR);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String balancerDescription;
                    String balancerAddress = balancerDescription = arr$[i$];
                    int sipPort = 5065;
                    int httpPort = 2080;
                    int rmiPort = 2000;
                    if (balancerDescription.indexOf(BALANCER_SIP_PORT_CHAR_SEPARATOR) != -1) {
                        String[] balancerDescriptionSplitted = balancerDescription.split(BALANCER_SIP_PORT_CHAR_SEPARATOR);
                        balancerAddress = balancerDescriptionSplitted[0];
                        try {
                            sipPort = Integer.parseInt(balancerDescriptionSplitted[1]);
                            if (balancerDescriptionSplitted.length > 2) {
                                httpPort = Integer.parseInt(balancerDescriptionSplitted[2]);
                                if (balancerDescriptionSplitted.length > 3) {
                                    rmiPort = Integer.parseInt(balancerDescriptionSplitted[3]);
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            logger.logError("Impossible to parse the following sip balancer port " + balancerDescriptionSplitted[1], (Exception)e);
                        }
                    }
                    if (Inet6Util.isValidIP6Address(balancerAddress) || Inet6Util.isValidIPV4Address(balancerAddress)) {
                        try {
                            this.addBalancer(InetAddress.getByName(balancerAddress).getHostAddress(), sipPort, httpPort, rmiPort);
                        }
                        catch (UnknownHostException e) {
                            logger.logError("Impossible to parse the following sip balancer address " + balancerAddress, (Exception)e);
                        }
                        continue;
                    }
                    this.addBalancer(balancerAddress, sipPort, httpPort, 0, rmiPort);
                }
            }
            this.started = true;
        }
        this.hearBeatTaskToRun = new BalancerPingTimerTask();
        this.heartBeatTimer.scheduleAtFixedRate(this.hearBeatTaskToRun, 2000L, this.heartBeatInterval);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Created and scheduled tasks for sending heartbeats to the sip balancer.");
        }
        this.registerMBean();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Load Balancer Heart Beating Service has been started");
        }
    }

    @Override
    public void stop() {
        ArrayList<SIPNode> info = this.getConnectorsAsSIPNode();
        this.removeNodesFromBalancers(info);
        this.register.clear();
        if (this.hearBeatTaskToRun != null) {
            this.hearBeatTaskToRun.cancel();
        }
        this.hearBeatTaskToRun = null;
        this.loadBalancerHeartBeatingListeners.clear();
        this.started = false;
        this.heartBeatTimer.cancel();
        this.unRegisterMBean();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Load Balancer Heart Beating Service has been stopped");
        }
    }

    protected void registerMBean() {
        String mBeanName = LB_HB_SERVICE_MBEAN_NAME + this.sipStack.getStackName();
        try {
            this.oname = new ObjectName(mBeanName);
            if (this.sipStack.getMBeanServer() != null && !this.sipStack.getMBeanServer().isRegistered(this.oname)) {
                this.sipStack.getMBeanServer().registerMBean(this, this.oname);
            }
        }
        catch (Exception e) {
            logger.logError("Could not register the Load Balancer Service as an MBean under the following name " + mBeanName, e);
        }
    }

    protected void unRegisterMBean() {
        String mBeanName = LB_HB_SERVICE_MBEAN_NAME + this.sipStack.getStackName();
        try {
            if (this.oname != null && this.sipStack.getMBeanServer() != null && this.sipStack.getMBeanServer().isRegistered(this.oname)) {
                this.sipStack.getMBeanServer().unregisterMBean(this.oname);
            }
        }
        catch (Exception e) {
            logger.logError("Could not unregister the stack as an MBean under the following name" + mBeanName);
        }
    }

    @Override
    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public void setHeartBeatInterval(long heartBeatInterval) {
        if (heartBeatInterval < 100L) {
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Setting HeartBeatInterval from " + this.heartBeatInterval + " to " + heartBeatInterval);
        }
        this.heartBeatInterval = heartBeatInterval;
        this.hearBeatTaskToRun.cancel();
        this.hearBeatTaskToRun = new BalancerPingTimerTask();
        this.heartBeatTimer.scheduleAtFixedRate(this.hearBeatTaskToRun, 0L, this.heartBeatInterval);
    }

    private InetAddress fetchHostAddress(String hostName, int index) {
        if (hostName == null) {
            throw new NullPointerException("Host name cant be null!!!");
        }
        InetAddress[] hostAddr = null;
        try {
            hostAddr = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("HostName is not a valid host name or it doesnt exists in DNS", uhe);
        }
        if (index < 0 || index >= hostAddr.length) {
            throw new IllegalArgumentException("Index in host address array is wrong, it should be [0]<x<[" + hostAddr.length + "] and it is [" + index + "]");
        }
        InetAddress address = hostAddr[index];
        return address;
    }

    @Override
    public String[] getBalancers() {
        return this.register.keySet().toArray(new String[this.register.keySet().size()]);
    }

    @Override
    public boolean addBalancer(String addr, int sipPort, int httpPort, int rmiPort) {
        if (addr == null) {
            throw new NullPointerException("addr cant be null!!!");
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Something wrong with host creation.", e);
        }
        String balancerName = address.getCanonicalHostName() + BALANCER_SIP_PORT_CHAR_SEPARATOR + rmiPort;
        if (this.register.get(balancerName) != null) {
            logger.logInfo("Sip balancer " + balancerName + " already present, not added");
            return false;
        }
        SipLoadBalancer sipLoadBalancer = new SipLoadBalancer(this, address, sipPort, httpPort, rmiPort);
        this.register.put(balancerName, sipLoadBalancer);
        for (LoadBalancerHeartBeatingListener loadBalancerHeartBeatingListener : this.loadBalancerHeartBeatingListeners) {
            loadBalancerHeartBeatingListener.loadBalancerAdded(sipLoadBalancer);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("following balancer name : " + balancerName + "/address:" + addr + " added");
        }
        return true;
    }

    @Override
    public boolean addBalancer(String hostName, int sipPort, int httpPort, int index, int rmiPort) {
        return this.addBalancer(this.fetchHostAddress(hostName, index).getHostAddress(), sipPort, httpPort, rmiPort);
    }

    @Override
    public boolean removeBalancer(String addr, int sipPort, int httpPort, int rmiPort) {
        if (addr == null) {
            throw new NullPointerException("addr cant be null!!!");
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Something wrong with host creation.", e);
        }
        SipLoadBalancer sipLoadBalancer = new SipLoadBalancer(this, address, sipPort, httpPort, rmiPort);
        String keyToRemove = null;
        Iterator<String> keyIterator = this.register.keySet().iterator();
        while (keyIterator.hasNext() && keyToRemove == null) {
            String key = keyIterator.next();
            if (!this.register.get(key).equals(sipLoadBalancer)) continue;
            keyToRemove = key;
        }
        if (keyToRemove != null) {
            this.register.remove(keyToRemove);
            for (LoadBalancerHeartBeatingListener loadBalancerHeartBeatingListener : this.loadBalancerHeartBeatingListeners) {
                loadBalancerHeartBeatingListener.loadBalancerRemoved(sipLoadBalancer);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("following balancer name : " + keyToRemove + "/address:" + addr + " removed");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeBalancer(String hostName, int sipPort, int httpPort, int index, int rmiPort) {
        InetAddress[] hostAddr = null;
        try {
            hostAddr = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("HostName is not a valid host name or it doesnt exists in DNS", uhe);
        }
        if (index < 0 || index >= hostAddr.length) {
            throw new IllegalArgumentException("Index in host address array is wrong, it should be [0]<x<[" + hostAddr.length + "] and it is [" + index + "]");
        }
        InetAddress address = hostAddr[index];
        return this.removeBalancer(address.getHostAddress(), sipPort, httpPort, rmiPort);
    }

    protected ArrayList<SIPNode> getConnectorsAsSIPNode() {
        ArrayList<SIPNode> info = new ArrayList<SIPNode>();
        Integer sipTcpPort = null;
        Integer sipUdpPort = null;
        Integer sipWsPort = null;
        String address = null;
        String hostName = null;
        Iterator listeningPointIterator = this.sipStack.getListeningPoints();
        while (listeningPointIterator.hasNext()) {
            ListeningPoint listeningPoint = (ListeningPoint)listeningPointIterator.next();
            address = listeningPoint.getIPAddress();
            if (address.equals("localhost")) {
                address = "127.0.0.1";
            }
            int port = listeningPoint.getPort();
            String transport = listeningPoint.getTransport();
            if (transport.equalsIgnoreCase("tcp")) {
                sipTcpPort = port;
            } else if (transport.equalsIgnoreCase("udp")) {
                sipUdpPort = port;
            } else if (transport.equalsIgnoreCase("ws")) {
                sipWsPort = port;
            }
            try {
                InetAddress[] aArray = InetAddress.getAllByName(address);
                if (aArray == null || aArray.length <= 0) continue;
                hostName = aArray[0].getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                logger.logError("An exception occurred while trying to retrieve the hostname of a sip connector", (Exception)e);
            }
        }
        ArrayList<String> ipAddresses = new ArrayList<String>();
        boolean isAnyLocalAddress = false;
        try {
            isAnyLocalAddress = InetAddress.getByName(address).isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            logger.logWarning("Unable to enumerate mapped interfaces. Binding to 0.0.0.0 may not work.");
            isAnyLocalAddress = false;
        }
        if (isAnyLocalAddress) {
            if (this.cachedAnyLocalAddresses.isEmpty()) {
                try {
                    Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (networkInterfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = networkInterfaces.nextElement();
                        Enumeration<InetAddress> bindings = networkInterface.getInetAddresses();
                        while (bindings.hasMoreElements()) {
                            InetAddress addr = bindings.nextElement();
                            String networkInterfaceIpAddress = addr.getHostAddress();
                            this.cachedAnyLocalAddresses.add(networkInterfaceIpAddress);
                        }
                    }
                }
                catch (SocketException e) {
                    logger.logWarning("Unable to enumerate network interfaces. Binding to 0.0.0.0 may not work.");
                }
            } else {
                ipAddresses.addAll(this.cachedAnyLocalAddresses);
            }
        } else {
            ipAddresses.add(address);
        }
        String httpPortString = System.getProperty("org.mobicents.properties.httpPort");
        String sslPortString = System.getProperty("org.mobicents.properties.sslPort");
        if (httpPortString == null && sslPortString == null) {
            logger.logWarning("HTTP or HTTPS port couldn't be retrieved from System properties, trying with JMX");
            Integer httpPort = null;
            Boolean httpBound = false;
            Integer sslPort = null;
            Boolean sslBound = false;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName http = new ObjectName("jboss.as:socket-binding-group=standard-sockets,socket-binding=http");
                httpPort = (Integer)mBeanServer.getAttribute(http, "boundPort");
                httpBound = (Boolean)mBeanServer.getAttribute(http, "bound");
                ObjectName https = new ObjectName("jboss.as:socket-binding-group=standard-sockets,socket-binding=https");
                sslPort = (Integer)mBeanServer.getAttribute(https, "boundPort");
                sslBound = (Boolean)mBeanServer.getAttribute(https, "bound");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (httpBound.booleanValue() && httpPort != null) {
                System.setProperty("org.mobicents.properties.httpPort", String.valueOf(httpPort));
            } else if (sslBound.booleanValue() && sslPort != null) {
                System.setProperty("org.mobicents.properties.sslPort", String.valueOf(sslPort));
            }
        }
        Properties props = System.getProperties();
        for (String ipAddress : ipAddresses) {
            SIPNode node = new SIPNode(hostName, ipAddress);
            int httpPort = 0;
            int sslPort = 0;
            if (httpPortString != null) {
                httpPort = Integer.parseInt(httpPortString);
                node.getProperties().put("httpPort", httpPort);
            }
            if (sslPortString != null) {
                sslPort = Integer.parseInt(sslPortString);
                node.getProperties().put("sslPort", sslPort);
            }
            if (sipTcpPort != null) {
                node.getProperties().put("tcpPort", sipTcpPort);
            }
            if (sipUdpPort != null) {
                node.getProperties().put("udpPort", sipUdpPort);
            }
            if (sipWsPort != null) {
                node.getProperties().put("wsPort", sipWsPort);
            }
            if (this.jvmRoute != null) {
                node.getProperties().put("jvmRoute", this.jvmRoute);
            }
            node.getProperties().put("version", System.getProperty("org.mobicents.server.version", "0"));
            info.add(node);
        }
        return info;
    }

    protected void sendKeepAliveToBalancers(ArrayList<SIPNode> info) {
        Thread.currentThread().setContextClassLoader(NodeRegisterRMIStub.class.getClassLoader());
        for (SipLoadBalancer balancerDescription : new HashSet<SipLoadBalancer>(this.register.values())) {
            try {
                long startTime = System.currentTimeMillis();
                Registry registry = LocateRegistry.getRegistry(balancerDescription.getAddress().getHostAddress(), balancerDescription.getRmiPort());
                NodeRegisterRMIStub reg = (NodeRegisterRMIStub)registry.lookup("SIPBalancer");
                ArrayList<SIPNode> reachableInfo = this.getReachableSIPNodeInfo(balancerDescription.getAddress(), info);
                if (reachableInfo.isEmpty()) {
                    logger.logWarning("All connectors are unreachable from the balancer");
                }
                reg.handlePing(reachableInfo);
                balancerDescription.setDisplayWarning(true);
                if (!balancerDescription.isAvailable()) {
                    logger.logInfo("Keepalive: SIP Load Balancer Found! " + balancerDescription);
                }
                balancerDescription.setAvailable(true);
                startTime = System.currentTimeMillis() - startTime;
                if (startTime <= 200L) continue;
                logger.logWarning("Heartbeat sent too slow in " + startTime + " millis at " + System.currentTimeMillis());
            }
            catch (IOException e) {
                balancerDescription.setAvailable(false);
                if (balancerDescription.isDisplayWarning()) {
                    logger.logWarning("sendKeepAlive: Cannot access the SIP load balancer RMI registry: " + e.getMessage() + "\nIf you need a cluster configuration make sure the SIP load balancer is running. Host " + balancerDescription.toString());
                }
                balancerDescription.setDisplayWarning(false);
            }
            catch (Exception e) {
                balancerDescription.setAvailable(false);
                if (balancerDescription.isDisplayWarning()) {
                    logger.logError("sendKeepAlive: Cannot access the SIP load balancer RMI registry: " + e.getMessage() + "\nIf you need a cluster configuration make sure the SIP load balancer is running. Host " + balancerDescription.toString(), e);
                }
                balancerDescription.setDisplayWarning(false);
            }
        }
        if (logger.isLoggingEnabled(64)) {
            logger.logTrace("Finished gathering, Gathered info[" + info + "]");
        }
    }

    protected ArrayList<SIPNode> getReachableSIPNodeInfo(InetAddress balancerAddr, ArrayList<SIPNode> info) {
        if (balancerAddr.isLoopbackAddress()) {
            return info;
        }
        ArrayList<SIPNode> rv = new ArrayList<SIPNode>();
        for (SIPNode node : info) {
            try {
                NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getByName(node.getIp()));
                boolean b = balancerAddr.isReachable(ni, 5, 900);
                if (!b) continue;
                rv.add(node);
            }
            catch (IOException e) {
                logger.logError("IOException", (Exception)e);
            }
        }
        if (logger.isLoggingEnabled(64)) {
            logger.logTrace("Reachable SIP Node:[balancer=" + balancerAddr + "],[node info=" + rv + "]");
        }
        return rv;
    }

    protected void removeNodesFromBalancers(ArrayList<SIPNode> info) {
        Thread.currentThread().setContextClassLoader(NodeRegisterRMIStub.class.getClassLoader());
        for (SipLoadBalancer balancerDescription : new HashSet<SipLoadBalancer>(this.register.values())) {
            try {
                Registry registry = LocateRegistry.getRegistry(balancerDescription.getAddress().getHostAddress(), balancerDescription.getRmiPort());
                NodeRegisterRMIStub reg = (NodeRegisterRMIStub)registry.lookup("SIPBalancer");
                reg.forceRemoval(info);
                if (!balancerDescription.isAvailable()) {
                    logger.logInfo("Remove: SIP Load Balancer Found! " + balancerDescription);
                    balancerDescription.setDisplayWarning(true);
                }
                balancerDescription.setAvailable(true);
            }
            catch (IOException e) {
                if (balancerDescription.isDisplayWarning()) {
                    logger.logWarning("remove: Cannot access the SIP load balancer RMI registry: " + e.getMessage() + "\nIf you need a cluster configuration make sure the SIP load balancer is running.");
                    balancerDescription.setDisplayWarning(false);
                }
                balancerDescription.setAvailable(true);
            }
            catch (Exception e) {
                if (balancerDescription.isDisplayWarning()) {
                    logger.logError("remove: Cannot access the SIP load balancer RMI registry: " + e.getMessage() + "\nIf you need a cluster configuration make sure the SIP load balancer is running.", e);
                    balancerDescription.setDisplayWarning(false);
                }
                balancerDescription.setAvailable(true);
            }
        }
        if (logger.isLoggingEnabled(64)) {
            logger.logTrace("Finished gathering, Gathered info[" + info + "]");
        }
    }

    public void setBalancers(String balancers) {
        this.balancers = balancers;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRoute;
    }

    @Override
    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    @Override
    public void addLoadBalancerHeartBeatingListener(LoadBalancerHeartBeatingListener loadBalancerHeartBeatingListener) {
        this.loadBalancerHeartBeatingListeners.add(loadBalancerHeartBeatingListener);
    }

    @Override
    public void removeLoadBalancerHeartBeatingListener(LoadBalancerHeartBeatingListener loadBalancerHeartBeatingListener) {
        this.loadBalancerHeartBeatingListeners.remove(loadBalancerHeartBeatingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSwitchoverInstruction(SipLoadBalancer sipLoadBalancer, String fromJvmRoute, String toJvmRoute) {
        logger.logInfo("switching over from " + fromJvmRoute + " to " + toJvmRoute);
        if (fromJvmRoute == null || toJvmRoute == null) {
            return;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(NodeRegisterRMIStub.class.getClassLoader());
            Registry registry = LocateRegistry.getRegistry(sipLoadBalancer.getAddress().getHostAddress(), sipLoadBalancer.getRmiPort());
            NodeRegisterRMIStub reg = (NodeRegisterRMIStub)registry.lookup("SIPBalancer");
            reg.switchover(fromJvmRoute, toJvmRoute);
            sipLoadBalancer.setDisplayWarning(true);
            if (!sipLoadBalancer.isAvailable()) {
                logger.logInfo("Switchover: SIP Load Balancer Found! " + sipLoadBalancer);
            }
        }
        catch (IOException e) {
            sipLoadBalancer.setAvailable(false);
            if (sipLoadBalancer.isDisplayWarning()) {
                logger.logWarning("Cannot access the SIP load balancer RMI registry: " + e.getMessage() + "\nIf you need a cluster configuration make sure the SIP load balancer is running.");
                sipLoadBalancer.setDisplayWarning(false);
            }
        }
        catch (Exception e) {
            sipLoadBalancer.setAvailable(false);
            if (sipLoadBalancer.isDisplayWarning()) {
                logger.logError("Cannot access the SIP load balancer RMI registry: " + e.getMessage() + "\nIf you need a cluster configuration make sure the SIP load balancer is running.", e);
                sipLoadBalancer.setDisplayWarning(false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public SipLoadBalancer[] getLoadBalancers() {
        return this.register.values().toArray(new SipLoadBalancer[0]);
    }

    protected class BalancerPingTimerTask
    extends TimerTask {
        protected BalancerPingTimerTask() {
        }

        public void run() {
            ArrayList<SIPNode> info = LoadBalancerHeartBeatingServiceImpl.this.getConnectorsAsSIPNode();
            LoadBalancerHeartBeatingServiceImpl.this.sendKeepAliveToBalancers(info);
        }
    }
}

